/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation;

import java.io.Serializable;
import jp.kitec.kwt.KLineType;
import jp.kitec.lib.util.RefList;
import nethome.presentation.primitive.GLine;

public class HatchPattern
implements Serializable {
    public static final short MINMAXFIT = 0;
    public static final short INTERVALFIT = 1;
    public static final short SIZEDEPEND = 2;
    public static final short SUBTYPESIZE = 3;
    private String mName;
    private String[] mGroupName;
    public RefList<Double> mInfinityX;
    public RefList<Double> mInfinityY;
    public RefList<GLine> mLines;
    public double mDisplaySize;
    public double mCycleX;
    public double mCycleY;
    public double mMinX;
    public double mMaxX;
    public double mMinY;
    public double mMaxY;
    public short mFitPattern;
    public double mOffsetToInside = 0.0;
    public boolean mFrameLine = false;
    public KLineType mLtype = null;
    private boolean mSmooth;
    private final RefList mSubTypes;

    public HatchPattern(String[] group) {
        this.mGroupName = group;
        this.mMinY = Double.MAX_VALUE;
        this.mMinX = Double.MAX_VALUE;
        this.mMaxY = -1.7976931348623157E308;
        this.mMaxX = -1.7976931348623157E308;
        this.mInfinityX = new RefList();
        this.mInfinityY = new RefList();
        this.mLines = new RefList();
        this.mOffsetToInside = 0.0;
        this.mFrameLine = false;
        this.mSmooth = false;
        this.mDisplaySize = -1.0;
        this.mSubTypes = new RefList();
    }

    public RefList getSubTypes() {
        return this.mSubTypes;
    }

    public void addSubType(int x, int y, int w, int h) {
        int[] st = new int[]{x, y, w, h};
        this.mSubTypes.addElement((Object)st);
    }

    public void addSubType2(double cx, double cy, double w, double h) {
        double[] st = new double[]{cx, cy, w, h};
        this.mSubTypes.addElement((Object)st);
    }

    public int[] getSubtype(int w, int h) {
        for (int i = 0; i < this.mSubTypes.size(); ++i) {
            int[] st = (int[])this.mSubTypes.elementAt(i);
            if (st[0] != w || st[1] != h) continue;
            return st;
        }
        return null;
    }

    public double[] getSubtype2(int w, int h) {
        for (int i = 0; i < this.mSubTypes.size(); ++i) {
            double[] st = (double[])this.mSubTypes.elementAt(i);
            if (!(Math.abs(st[0] - (double)w) < (double)0.001f) || !(Math.abs(st[1] - (double)h) < (double)0.001f)) continue;
            return st;
        }
        return null;
    }

    public void setGroup(String[] s) {
        this.mGroupName = s;
    }

    public String[] getGroupName() {
        return this.mGroupName;
    }

    public void setName(String s) {
        this.mName = s;
    }

    public String getName() {
        return this.mName;
    }

    public void setArea(double f) {
        this.mDisplaySize = f;
    }

    public double getArea() {
        return this.mDisplaySize;
    }

    public void setFitPattern(short fitpattern) {
        this.mFitPattern = fitpattern;
    }

    public void setCycle(double cycx, double cycy) {
        this.mCycleX = cycx;
        this.mCycleY = cycy;
    }

    public void setSmooth(boolean b) {
        this.mSmooth = b;
    }

    public boolean getSmooth() {
        return this.mSmooth;
    }

    public void setMinMax(double xmin, double ymin, double xmax, double ymax) {
        this.mMinX = xmin;
        this.mMaxX = xmax;
        this.mMinY = ymin;
        this.mMaxY = ymax;
    }

    public void addInfinityX(double x) {
        Double f = new Double(x);
        this.mInfinityX.addElement((Object)f);
    }

    public void addInfinityY(double y) {
        Double f = new Double(y);
        this.mInfinityY.addElement((Object)f);
    }

    public void addLine(double x1, double y1, double x2, double y2) {
        this.mLines.addElement((Object)new GLine(x1, y1, x2, y2));
    }

    public void addMinMaxLine() {
        this.mLines.addElement((Object)new GLine(this.mMinX, this.mMinY, this.mMaxX, this.mMinY));
        this.mLines.addElement((Object)new GLine(this.mMinX, this.mMinY, this.mMinX, this.mMaxY));
        this.mLines.addElement((Object)new GLine(this.mMinX, this.mMaxY, this.mMaxX, this.mMaxY));
        this.mLines.addElement((Object)new GLine(this.mMaxX, this.mMinY, this.mMaxX, this.mMaxY));
    }
}

