/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import jp.kitec.kwt.KArea;
import jp.kitec.kwt.KImage;
import jp.kitec.kwt.KRotatedArea;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.presentation.GeomName;
import nethome.presentation.GeomParser;
import nethome.presentation.primitive.Geometry;
import nethome.util.ToolPolygon;

@GeomName(name="IMAGE")
public class GImage
extends Geometry {
    protected KRotatedArea mArea = new KRotatedArea();
    protected KImage mImage;

    public GImage() {
    }

    public GImage(Point2d cp, double angle, Vector2d size, KImage image) {
        this.mArea.setCenter(cp);
        this.mArea.setRotation(angle);
        this.mArea.setSize(size);
        this.mImage = image;
    }

    public Point2d getCenter() {
        return this.mArea.getCenter();
    }

    public void setCenter(Point2d cp) {
        this.mArea.setCenter(cp);
    }

    public double getAngle() {
        return this.mArea.getRotation();
    }

    public void setAngle(double angl) {
        this.mArea.setRotation(angl);
    }

    public Vector2d getSize() {
        return this.mArea.getSize();
    }

    public void setSize(Vector2d size) {
        this.mArea.setSize(size);
    }

    public KImage getImage() {
        return this.mImage;
    }

    public void setImage(KImage image) {
        this.mImage = image;
    }

    @Override
    public GImage copy() {
        return this.copyTo(new GImage());
    }

    @Override
    protected GImage copyTo(Geometry g) {
        if (g == null || !(g instanceof GImage)) {
            return null;
        }
        GImage gt = (GImage)g;
        super.copyTo(gt);
        gt.mArea = new KRotatedArea();
        gt.mArea.set(this.mArea);
        gt.mImage = this.mImage;
        return gt;
    }

    public Point2d[] getPoints() {
        return this.mArea.getPoints();
    }

    @Override
    public void updateMinMax(KArea area) {
        for (Point2d p : this.getPoints()) {
            area.updateMinMax(p.x, p.y);
        }
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        return this.mArea.distanceTo(x, y);
    }

    @Override
    public boolean isInner(double minx, double miny, double maxx, double maxy) {
        for (Point2d p : this.mArea.getPoints()) {
            if (!(p.x < minx || p.x > maxx || p.y < miny) && !(p.y > maxy)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInner(RefList<Point2d> v) {
        for (Point2d p : this.mArea.getPoints()) {
            if (ToolPolygon.isInnerPolygon(v, p.x, p.y)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        savenode.addNode("x", this.getCenter().x);
        savenode.addNode("y", this.getCenter().y);
        savenode.addNode("angle", this.getAngle());
        savenode.addNode("sx", this.getSize().x);
        savenode.addNode("sy", this.getSize().y);
    }

    public static void readData(ObjectFolder of, Geometry g, GeomParser ps) throws Exception {
        if (!(g instanceof GImage)) {
            return;
        }
        Geometry.readData(of, g, ps);
        GImage gp = (GImage)g;
        double x = 0.0;
        double y = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        ObjectNode on = of.getNode("x");
        if (on != null) {
            x = on.getDouble();
        }
        if ((on = of.getNode("y")) != null) {
            y = on.getDouble();
        }
        if ((on = of.getNode("angle")) != null) {
            gp.setAngle(on.getDouble());
        }
        if ((on = of.getNode("sx")) != null) {
            sx = on.getDouble();
        }
        if ((on = of.getNode("sy")) != null) {
            sy = on.getDouble();
        }
        gp.setCenter(new Point2d(x, y));
        gp.setSize(new Vector2d(sx, sy));
    }
}

