/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive.draw;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KFill;
import jp.kitec.kwt.KLineType;
import jp.kitec.vecmath.KPoint2d;
import nethome.presentation.LocalAxis2Df;
import nethome.presentation.primitive.DrawParameters;
import nethome.presentation.primitive.GRect;
import nethome.presentation.primitive.draw.AbstractCustomDrawer;

public class GRectDrawer
extends AbstractCustomDrawer<GRect> {
    protected transient List<KPoint2d> _pbuf;

    @Override
    protected void doDraw(IRichGraphics d, DrawParameters params) {
        KColor fore = params.get(DrawParameters.KEY_DRAW_COLOR, ((GRect)this.mGeom).getGeomColor());
        KFill back = params.get(DrawParameters.KEY_FILL_COLOR, ((GRect)this.mGeom).getFillColor());
        boolean fill = params.get(DrawParameters.KEY_FILL, true) != false && ((GRect)this.mGeom).isFillMode();
        LocalAxis2Df la = params.get(DrawParameters.KEY_LOCAL_AXIS, null);
        KLineType lineType = params.get(DrawParameters.KEY_LINE_TYPE, ((GRect)this.mGeom).getLineType());
        List<KPoint2d> mPoints = ((GRect)this.mGeom).getPoints();
        List<KPoint2d> pts = null;
        if (la != null) {
            int i;
            if (this._pbuf == null) {
                this._pbuf = new ArrayList<KPoint2d>();
            }
            if (this._pbuf.size() != mPoints.size()) {
                this._pbuf.clear();
                i = 0;
                while (i < mPoints.size()) {
                    this._pbuf.add(new KPoint2d());
                    ++i;
                }
            }
            i = 0;
            while (i < mPoints.size()) {
                Point2d p1 = (Point2d)mPoints.get(i);
                Point2d p2 = (Point2d)this._pbuf.get(i);
                p2.x = la.getGlobalX(p1.x, p1.y);
                p2.y = la.getGlobalY(p1.x, p1.y);
                ++i;
            }
            pts = this._pbuf;
        } else {
            pts = mPoints;
        }
        if (fill) {
            d.setColor(back);
            d.drawFillPolygon(pts, lineType);
        }
        if (((GRect)this.mGeom).isDrawLine()) {
            d.setColor((KFill)fore);
            d.drawPolygon(pts, lineType);
        }
    }
}

