/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.kitec.kwt.KArea;
import jp.kitec.lib.geom.KPath2d;
import jp.kitec.lib.geom.KPathSegmentUtil;
import jp.kitec.lib.util.StringUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.presentation.GeomName;
import nethome.presentation.GeomParser;
import nethome.presentation.primitive.GCurve;
import nethome.presentation.primitive.GPolygon;
import nethome.presentation.primitive.Geometry;

@GeomName(name="PATH")
public class GPathShape
extends GCurve {
    private int mWindingRule = 4096;
    protected ArrayList<KPath2d> mSegments = new ArrayList();
    private int mDivCount = 10;

    public int getWindingRule() {
        return this.mWindingRule;
    }

    public void setWindingRule(int wind) {
        this.mWindingRule = wind;
    }

    public List<KPath2d> getSegments() {
        return Collections.unmodifiableList(this.mSegments);
    }

    @Override
    public boolean isClosed() {
        for (KPath2d p : this.mSegments) {
            if (p.getType() != 4) continue;
            return true;
        }
        return false;
    }

    public void clearSegment() {
        this.mSegments.clear();
    }

    public void addSegment(KPath2d seg) {
        this.mSegments.add(seg);
    }

    public void addSegments(List<? extends KPath2d> segs) {
        this.mSegments.addAll(segs);
    }

    @Override
    public GPathShape copy() {
        return this.copyTo(new GPathShape());
    }

    @Override
    protected GPathShape copyTo(Geometry g) {
        if (g == null || !(g instanceof GPathShape)) {
            return null;
        }
        GPathShape np = (GPathShape)g;
        super.copyTo(g);
        np.mWindingRule = this.mWindingRule;
        np.clearSegment();
        double[] points = new double[6];
        int i = 0;
        while (i < this.mSegments.size()) {
            KPath2d org = this.mSegments.get(i);
            int type = org.getType();
            org.getPoints(points);
            np.addSegment(KPathSegmentUtil.getPathSegment((int)type, (double[])points));
            ++i;
        }
        return np;
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        String[] segments = KPathSegmentUtil.write(this.mSegments);
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"segments", (String)StringUtil.concat((String[])segments, (String)" "));
        ObjectFolder.addNodeInt((ObjectFolder)savenode, (String)"winding", (int)this.mWindingRule);
    }

    public static void readData(ObjectFolder of, Geometry g, GeomParser ps) throws Exception {
        if (!(g instanceof GPolygon)) {
            return;
        }
        GCurve.readData(of, g, ps);
        GPathShape gp = (GPathShape)g;
        ObjectNode on = of.getNode("segments");
        if (on != null) {
            String[] tokens = on.getString().split(" ");
            gp.mSegments.addAll(KPathSegmentUtil.read((String[])tokens));
        }
        if ((on = of.getNode("winding")) != null) {
            gp.mWindingRule = on.getInt();
        }
    }

    @Override
    public void updateMinMax(KArea area) {
        double currx = 0.0;
        double curry = 0.0;
        int i = 0;
        while (i < this.mSegments.size()) {
            KPath2d seg = this.mSegments.get(i);
            seg.updateMinMax(area, currx, curry);
            currx = seg.getX1();
            curry = seg.getY1();
            ++i;
        }
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        double min = Double.POSITIVE_INFINITY;
        double currx = 0.0;
        double curry = 0.0;
        int i = 0;
        while (i < this.mSegments.size()) {
            KPath2d seg = this.mSegments.get(i);
            double l = seg.distanceTo(x, y, currx, curry, this.mDivCount);
            if (l < min) {
                min = l;
            }
            currx = seg.getX1();
            curry = seg.getY1();
            ++i;
        }
        return min;
    }
}

