/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import jp.kitec.kwt.KArea;
import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KFontMetrics;
import jp.kitec.kwt.KRotatedArea;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.NethomeCoreResource;
import nethome.presentation.GeomName;
import nethome.presentation.GeomParser;
import nethome.presentation.primitive.GCurve;
import nethome.presentation.primitive.Geometry;
import nethome.util.ToolPolygon;

@GeomName(name="TEXT")
public class GText
extends GCurve {
    protected KRotatedArea mArea = new KRotatedArea();
    protected float mSize;
    protected String mText;
    protected String mScaleFontName;
    protected boolean mDir = true;
    protected int mStyle;

    protected GText() {
    }

    public GText(Point2d p1, String scaleFontLabel, String text, double angl, float size, int style) {
        this();
        this.mArea = new KRotatedArea();
        this.mArea.setCenter(p1);
        this.mArea.setRotation(angl);
        this.mText = text;
        this.mSize = size;
        this.mScaleFontName = scaleFontLabel;
        this.mStyle = style;
        this.mGeomColor = KColor.BLACK;
        this.update();
    }

    public GText(double x, double y, String scaleFontLabel, String text, double angl, float size, int style) {
        this(new Point2d(x, y), scaleFontLabel, text, angl, size, style);
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    public String getScaleFontName() {
        return this.mScaleFontName;
    }

    public Point2d getCenter() {
        return this.mArea.getCenter();
    }

    public void setCenter(Point2d cp) {
        this.mArea.setCenter(cp);
    }

    public double getAngle() {
        return this.mArea.getRotation();
    }

    public void setAngle(double angl) {
        this.mArea.setRotation(angl);
    }

    public int getStyle() {
        return this.mStyle;
    }

    public boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    @Override
    public void updateMinMax(KArea area) {
        this.mArea.updateMinMax(area);
    }

    @Override
    public GText copy() {
        return this.copyTo(new GText());
    }

    @Override
    protected GText copyTo(Geometry g) {
        if (g == null || !(g instanceof GText)) {
            return null;
        }
        GText gt = (GText)g;
        super.copyTo(gt);
        gt.mArea = new KRotatedArea();
        gt.mArea.set(this.mArea);
        gt.mText = this.mText;
        gt.mSize = this.mSize;
        gt.mScaleFontName = this.mScaleFontName;
        gt.mStyle = this.mStyle;
        gt.mDir = this.mDir;
        return gt;
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        return this.mArea.distanceTo(x, y);
    }

    @Override
    public boolean isInner(double minx, double miny, double maxx, double maxy) {
        Point2d[] point2dArray = this.mArea.getPoints();
        int n = point2dArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point2d p = point2dArray[n2];
            if (p.x < minx || p.x > maxx || p.y < miny || p.y > maxy) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isInner(RefList<Point2d> v) {
        Point2d[] point2dArray = this.mArea.getPoints();
        int n = point2dArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point2d p = point2dArray[n2];
            if (!ToolPolygon.isInnerPolygon(v, p.x, p.y)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setDir(boolean dir) {
        this.mDir = dir;
    }

    public boolean isDir() {
        return this.mDir;
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        savenode.addNode("x", this.getCenter().x);
        savenode.addNode("y", this.getCenter().y);
        savenode.addNode("scalefontname", this.mScaleFontName);
        savenode.addNode("string", this.mText);
        savenode.addNode("angle", this.getAngle());
        savenode.addNode("textsize", this.mSize);
        savenode.addNode("dir", this.mDir);
        savenode.addNode("style", this.mStyle);
    }

    public static void readData(ObjectFolder of, Geometry g, GeomParser ps) throws Exception {
        if (!(g instanceof GText)) {
            return;
        }
        GCurve.readData(of, g, ps);
        double x = 0.0;
        double y = 0.0;
        GText gp = (GText)g;
        ObjectNode on = of.getNode("x");
        if (on != null) {
            x = on.getDouble();
        }
        if ((on = of.getNode("y")) != null) {
            y = on.getDouble();
        }
        if ((on = of.getNode("scalefontname")) != null) {
            gp.mText = on.getString();
        }
        if ((on = of.getNode("string")) != null) {
            gp.mText = on.getString();
        }
        if ((on = of.getNode("angle")) != null) {
            gp.setAngle(on.getDouble());
        }
        if ((on = of.getNode("textsize")) != null) {
            gp.mSize = on.getFloat();
        }
        if ((on = of.getNode("dir")) != null) {
            gp.mDir = on.getBool();
        }
        if ((on = of.getNode("style")) != null) {
            gp.mStyle = on.getInt();
        }
        gp.setCenter(new Point2d(x, y));
        gp.update();
    }

    public void update() {
        KFont scaleFont = NethomeCoreResource.getScaleFont((String)this.mScaleFontName);
        KFontMetrics fm = scaleFont.getFontMetrics(null);
        double scale = (double)this.mSize / scaleFont.getSize();
        double size = 0.0;
        if (this.mDir) {
            size = fm.getDescent() + fm.getAscent();
            double width = fm.stringWidth(this.mText);
            double w = width * scale / 2.0;
            this.mArea.setSize(new Vector2d(w * 2.0, size * scale));
        } else {
            double w = 0.0;
            int i = 0;
            while (i < this.mText.length()) {
                String ss = this.mText.substring(i, i + 1);
                double tw = fm.stringWidth(ss) / 2.0;
                w = Math.max(w, tw);
                ++i;
            }
            size = fm.getDescent() + fm.getAscent();
            double h = (double)this.mText.length() * size * scale / 2.0;
            this.mArea.setSize(new Vector2d(w * 2.0, h * scale));
        }
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String s) {
        this.mText = s;
        this.update();
    }

    public float getSize() {
        return this.mSize;
    }

    public void setSize(float mSize) {
        this.mSize = mSize;
    }
}

