/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import java.util.ArrayList;
import javax.vecmath.Point2d;
import jp.kitec.kwt.KArea;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.presentation.GeomName;
import nethome.presentation.GeomParser;
import nethome.presentation.primitive.Element;
import nethome.presentation.primitive.Geometry;
import nethome.util.ToolPolygon;

@GeomName(name="GROUP")
public class GGroup
extends Geometry {
    private ArrayList<Geometry> mChildren = new ArrayList();
    private KArea mArea;
    private boolean mAutoArea = true;
    private boolean mTraverseChildren;

    public int getChildCount() {
        return this.mChildren.size();
    }

    public Geometry getChild(int index) {
        return this.mChildren.get(index);
    }

    public void addChild(Geometry e) {
        if (this.mAutoArea) {
            this.mArea = null;
        }
        this.mChildren.add(e);
    }

    public void removeChild(Geometry o) {
        if (this.mAutoArea) {
            this.mArea = null;
        }
        this.mChildren.remove(o);
    }

    public void setArea(KArea area) {
        if (this.mAutoArea) {
            throw new IllegalStateException();
        }
        if (this.mArea == null) {
            this.mArea = new KArea();
        }
        this.mArea.setArea(area);
    }

    public void setAutoArea(boolean autoArea) {
        this.mAutoArea = autoArea;
        if (this.mAutoArea) {
            this.mArea = null;
        }
    }

    public void setTraverseChildren(boolean traverseChildren) {
        this.mTraverseChildren = traverseChildren;
    }

    public boolean isTraverseChildren() {
        return this.mTraverseChildren;
    }

    @Override
    public void updateMinMax(KArea area) {
        if (this.mArea == null) {
            this.updateArea();
        }
        area.updateMinMax(this.mArea);
    }

    private void updateArea() {
        this.mArea = new KArea();
        for (Geometry g : this.mChildren) {
            g.updateMinMax(this.mArea);
        }
    }

    @Override
    public GGroup copy() {
        return this.copyTo(new GGroup());
    }

    @Override
    protected GGroup copyTo(Geometry g) {
        if (g == null || !(g instanceof GGroup)) {
            return null;
        }
        GGroup np = (GGroup)g;
        for (Geometry c : this.mChildren) {
            np.addChild(c.copy());
        }
        return np;
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        if (this.mTraverseChildren) {
            double len = Double.POSITIVE_INFINITY;
            for (Geometry c : this.mChildren) {
                double l = c.getDistanceToPoint(x, y);
                if (!(l < len)) continue;
                len = l;
            }
            return len;
        }
        if (this.mArea == null) {
            this.updateArea();
        }
        return this.mArea.distanceTo(x, y);
    }

    @Override
    public boolean isInner(double minx, double miny, double maxx, double maxy) {
        if (this.mTraverseChildren) {
            for (Geometry c : this.mChildren) {
                if (c.isInner(minx, miny, maxx, maxy)) continue;
                return false;
            }
            return true;
        }
        if (this.mArea == null) {
            this.updateArea();
        }
        return this.mArea.minX >= minx && this.mArea.maxX <= maxx && this.mArea.minY >= miny && this.mArea.maxY <= maxy;
    }

    @Override
    public boolean isInner(RefList<Point2d> v) {
        if (this.mTraverseChildren) {
            for (Geometry c : this.mChildren) {
                if (c.isInner(v)) continue;
                return false;
            }
            return true;
        }
        return ToolPolygon.isInnerPolygon(v, this.mArea.minX, this.mArea.minY) && ToolPolygon.isInnerPolygon(v, this.mArea.minX, this.mArea.maxY) && ToolPolygon.isInnerPolygon(v, this.mArea.maxX, this.mArea.minY) && ToolPolygon.isInnerPolygon(v, this.mArea.maxX, this.mArea.maxY);
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        ObjectFolder children = new ObjectFolder("c");
        for (Geometry c : this.mChildren) {
            ObjectFolder of = new ObjectFolder("_");
            c.save(of);
            children.addChild((ObjectNode)of, true);
        }
        ObjectFolder.addNodeBool((ObjectFolder)savenode, (String)"traverse", (boolean)this.mTraverseChildren);
        ObjectFolder.addNodeBool((ObjectFolder)savenode, (String)"autoarea", (boolean)this.mAutoArea);
        if (!this.mAutoArea && this.mArea != null) {
            ObjectFolder areaf = new ObjectFolder("");
            this.mArea.save(areaf);
            savenode.addChild((ObjectNode)areaf);
        }
        savenode.addChild((ObjectNode)children);
    }

    public static void readData(ObjectFolder of, Geometry g, GeomParser ps) throws Exception {
        ObjectNode on2;
        if (!(g instanceof GGroup)) {
            return;
        }
        GGroup gp = (GGroup)g;
        Geometry.readData(of, g, ps);
        ObjectFolder cfolder = (ObjectFolder)of.getNamedElement("c").get(0);
        for (ObjectNode on2 : cfolder.getChildren()) {
            Element c = ps.getGeometry((ObjectFolder)on2);
            gp.mChildren.add((Geometry)c);
        }
        on2 = of.getNode("traverse");
        if (on2 != null) {
            gp.mTraverseChildren = ObjectNode.getNodeBool((ObjectNode)on2);
        }
        if ((on2 = of.getNode("autoarea")) != null) {
            gp.mAutoArea = ObjectNode.getNodeBool((ObjectNode)on2);
        }
        if (!gp.mAutoArea && (on2 = of.getNode("AREA")) != null) {
            gp.mArea = new KArea();
            KArea.readData((ObjectFolder)((ObjectFolder)on2), (KArea)gp.mArea);
        }
    }
}

