/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.kitec.kwt.KArea;
import jp.kitec.lib.geom.KPath2d;
import jp.kitec.lib.geom.KPathSegmentUtil;
import nethome.presentation.primitive.GCurve;
import nethome.presentation.primitive.Geometry;

public class GPathShape
extends GCurve {
    private int mWindingRule = 4096;
    protected ArrayList<KPath2d> mSegments = new ArrayList();
    private int mDivCount = 10;

    public int getWindingRule() {
        return this.mWindingRule;
    }

    public void setWindingRule(int wind) {
        this.mWindingRule = wind;
    }

    public List<KPath2d> getSegments() {
        return Collections.unmodifiableList(this.mSegments);
    }

    @Override
    public boolean isClosed() {
        for (KPath2d p : this.mSegments) {
            if (p.getType() != 4) continue;
            return true;
        }
        return false;
    }

    public void clearSegment() {
        this.mSegments.clear();
    }

    public void addSegment(KPath2d seg) {
        this.mSegments.add(seg);
    }

    public void addSegments(List<? extends KPath2d> segs) {
        this.mSegments.addAll(segs);
    }

    @Override
    public GPathShape copy() {
        return this.copyTo(new GPathShape());
    }

    @Override
    protected GPathShape copyTo(Geometry g) {
        if (g == null || !(g instanceof GPathShape)) {
            return null;
        }
        GPathShape np = (GPathShape)g;
        np.mFillColor = this.mFillColor;
        np.mGeomColor = this.mGeomColor;
        np.mWindingRule = this.mWindingRule;
        np.mFill = this.mFill;
        np.clearSegment();
        double[] points = new double[6];
        for (int i = 0; i < this.mSegments.size(); ++i) {
            KPath2d org = this.mSegments.get(i);
            int type = org.getType();
            org.getPoints(points);
            np.addSegment(KPathSegmentUtil.getPathSegment((int)type, (double[])points));
        }
        return np;
    }

    @Override
    public void updateMinMax(KArea area) {
        double currx = 0.0;
        double curry = 0.0;
        for (int i = 0; i < this.mSegments.size(); ++i) {
            KPath2d seg = this.mSegments.get(i);
            seg.updateMinMax(area, currx, curry);
            currx = seg.getX1();
            curry = seg.getY1();
        }
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        double min = Double.POSITIVE_INFINITY;
        double currx = 0.0;
        double curry = 0.0;
        for (int i = 0; i < this.mSegments.size(); ++i) {
            KPath2d seg = this.mSegments.get(i);
            double l = seg.distanceTo(x, y, currx, curry, this.mDivCount);
            if (l < min) {
                min = l;
            }
            currx = seg.getX1();
            curry = seg.getY1();
        }
        return min;
    }
}

