/*
 * Created on 2005/03/23
 */
package nethome5.op;

import nethome5.doc.Project;
import nethome5.geom.primitive.Geometry;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import jp.kitec.lib.kwt.KArea;

/**
 * 要素の置き換え。
 * 指定された二つの図形の左下座標(minX, maxY)が入れ替わるように置き換える。
 *
 * @author kawae
 * @since 2005/03/23
 */
public class OpReplaceElement implements IOperation {

	private Project mProject;
	private Geometry mGeom1;
	private Geometry mGeom2;

	public OpReplaceElement(Project project,
			Geometry geom1, Geometry geom2) {
		this.mProject = project;
		this.mGeom1 = geom1;
		this.mGeom2 = geom2;
	}

	@Override
	public boolean canPlay() {
		return (mGeom1 != null) && (mGeom2 != null) && (mGeom1 != mGeom2);
	}

	@Override
	public IStatus play(IProgressMonitor monitor) {
		monitor.beginTask("", 1);
		Geometry g1 = mGeom1;
		Geometry g2 = mGeom2;

		if (g1 != null && g2 != null && g1 != g2) {
			KArea area1 = new KArea();
			area1.maximize();
			g1.updateMinMax(area1);

			KArea area2 = new KArea();
			area2.maximize();
			g2.updateMinMax(area2);

			double x1 = area1.minX;
			double x2 = area2.minX;
			double y1 = area1.maxY;
			double y2 = area2.maxY;
//			double y1 = g1.getArea().minY;
//			double y2 = g2.getArea().minY;

			double ofsx1 = x2 - x1;
			double ofsy1 = y2 - y1;

			double ofsx2 = x1 - x2;
			double ofsy2 = y1 - y2;
			g1.offset(ofsx1, ofsy1);
			g2.offset(ofsx2, ofsy2);
			mProject.addHistory();
			mProject.fireProjectChanged(this);
		}
		monitor.done();
		return Status.OK_STATUS;
	}
}
