/*
 * Created on 2004/07/05
 */
package nethome5.op;

import java.util.List;

import nethome5.doc.Layer;
import nethome5.doc.Project;
import nethome5.geom.primitive.Geometry;
import nethome5.geom.primitive.IStaticGeometry;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * 前面に移動コマンド
 *
 * @author kawae
 */
public class OpMoveToTop implements IOperation {

	protected Project mProject;

	public OpMoveToTop(Project prj) {
		this.mProject = prj;
	}

	@Override
	public boolean canPlay() {
		Layer l = mProject.getCurrentLayer();
		if (l == null)
			return false;

		List selects = l.getSelectBuffer();
		return selects.size() > 0;
	}

	@Override
	public IStatus play(IProgressMonitor monitor) {
		monitor.beginTask("", 1);
		Layer l = mProject.getCurrentLayer();
		List<Geometry> selects = l.getSelectBuffer();
		for (int i = 0; i < selects.size(); i++) {
			Geometry o = selects.get(i);
			l.getPrims().remove(o);
			l.getPrims().add(o);
		}
		int insertcount = 0;
		for (int i = 0; i < l.getPrims().size(); i++) {
			Geometry o = l.getPrims().get(i);
			if (o instanceof IStaticGeometry) {
				l.getPrims().remove(o);
				l.getPrims().add(insertcount++, o);
			}
		}
		l.sortSelectBuffer();
		mProject.addHistory();
		mProject.fireProjectChanged(this);

		monitor.worked(1);
		monitor.done();
		return Status.OK_STATUS;
	}
}
