package nethome.ui.command;

import jp.kitec.lib.gui.event.CallBackListener;
import nethome.doc.Project;
import nethome.op.IOperation;
import nethome.ui.INethomeRuntime;
import nethome.ui.NethomeRuntime;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractProjectOperationCommand extends Command implements CallBackListener {
	protected IOperation mOperation;
	protected IProgressMonitor mMonitor;

	public AbstractProjectOperationCommand() {
		mMonitor = new NullProgressMonitor();
	}

	@Override
	public void play() {
		INethomeRuntime mr = NethomeRuntime.getInstance();
		Project prj = mr.getActiveProject();
		mOperation = createOperation(prj);
		if (!mOperation.canPlay())
			throw new IllegalStateException();
		mOperation.play(mMonitor);
	}

	protected abstract IOperation createOperation(Project prj);

	@Override
	public void actionCallBack(Object o) {
		play();
	}
}

