/*
 * Created on 2004/07/02
 *
 */
package nethome.op;

/**
 * 削除コマンド
 * 選択されているものを削除する。
 */
import nethome.doc.Layer;
import nethome.doc.Project;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class OpDelete implements IOperation {

	private Project mProject;

	public OpDelete(Project project) {
		super();
		this.mProject = project;
	}

	@Override
	public boolean canPlay() {
		Layer l = mProject.getCurrentLayer();
		if (l != null)
			return l.getSelectBuffer().size() > 0;
		return false;
	}

	@Override
	public IStatus play(IProgressMonitor monitor) {
		monitor.beginTask("", 1);

		Layer l = mProject.getCurrentLayer();

		if (l.getSelectBuffer().size() > 0) {
			for (int i = 0; i < l.getSelectBuffer().size(); i++) {
				l.removePrimitive(l.getSelectBuffer().get(i));
			}
			l.clearSelectBuffer();
			mProject.addHistory();
			mProject.fireProjectChanged(this);
		}
		monitor.worked(1);
		monitor.done();
		return Status.OK_STATUS;
	}
}
