/*
 * Created on 2004/07/07
 */
package nethome.op;

import java.util.List;

import nethome.doc.Layer;
import nethome.doc.Project;
import nethome.geom.primitive.Geometry;
import nethome.geom.primitive.IStaticGeometry;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * 全て選択コマンド
 * @author kawae
 */
public class OpSelectAll implements IOperation {

	private Project mProject;

	public OpSelectAll(Project mProject) {
		this.mProject = mProject;
	}

	@Override
	public boolean canPlay() {
		return true;
	}

	@Override
	public IStatus play(IProgressMonitor monitor) {
		monitor.beginTask("", 1);
		Layer l = mProject.getCurrentLayer();
		l.clearSelectBuffer();
		List<Geometry> selectBuffer = l.getSelectBuffer();
		for (int i = 0; i < l.getPrims().size(); i++) {
			Object o = l.getPrims().get(i);
			if (o instanceof IStaticGeometry)
				continue;
			selectBuffer.add(l.getPrims().get(i));
		}
		l.sortSelectBuffer();
		monitor.done();
		return Status.OK_STATUS;
	}
}
