/*
 * Created on 2004/07/05
 */
package nethome.op;

import java.util.List;

import nethome.doc.Layer;
import nethome.doc.Project;
import nethome.geom.primitive.Geometry;
import nethome.geom.primitive.IStaticGeometry;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * @author kawae
 *
 */
public class OpMoveToBottom implements IOperation {

	protected Project mProject;

	public OpMoveToBottom(Project prj) {
		this.mProject = prj;
	}

	@Override
	public boolean canPlay() {
		Layer l = mProject.getCurrentLayer();
		if (l == null)
			return false;

		List selects = l.getSelectBuffer();
		return selects.size() > 0;
	}

	@Override
	public IStatus play(IProgressMonitor monitor) {
		monitor.beginTask("", 1);
		Layer l = mProject.getCurrentLayer();
		List<Geometry> selects = l.getSelectBuffer();
		for (int i = 0; i < selects.size(); i++) {
			Geometry o = selects.get(selects.size() - i - 1);
			l.getPrims().remove(o);
			l.getPrims().add(0, o);
		}
		int insertcount = 0;
		for (int i = 0; i < l.getPrims().size(); i++) {
			Geometry o = l.getPrims().get(i);
			if (o instanceof IStaticGeometry) {
				l.getPrims().remove(o);
				l.getPrims().add(insertcount++, o);
			}
		}

		l.sortSelectBuffer();
		mProject.addHistory();
		mProject.fireProjectChanged(this);
		monitor.worked(1);
		monitor.done();
		return Status.OK_STATUS;
	}
}
