/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 * @author matsuzaki
 */
/**
 *
 */
package nethome5.ui;

import java.util.ArrayList;
import java.util.List;

import nethome5.geom.primitive.Geometry;

public class DefaultDrawData {
	public static final short DRAW_FULL   = 0;
	public static final short DRAW_SIMPLE = 1;
	public static final short DRAW_LINE   = 2;

	/** */
	protected List<Geometry> mAdditionalDrawGeoms;

	/** オプションの描画要素 */
	protected List mOptionalDrawElement;

	/** グリッドを表示するかどうか */
	protected boolean mDispGrid;

	/** シンプル表示フラグ */
	protected short mDrawMode = DRAW_FULL;

	public DefaultDrawData() {
		mAdditionalDrawGeoms = new ArrayList<Geometry>();
		mOptionalDrawElement = new ArrayList();
	}

	/**
	 * オプショナル描画オブジェクト群の取得
	 */
	public List getOptionalDrawList() {
		return mOptionalDrawElement;
	}

	/**
	 * オプショナル描画オブジェクトの追加
	 */
	public void addOptionalDrawObject(Object o) {
		if (mOptionalDrawElement.contains(o))
			return;
		mOptionalDrawElement.add(o);
	}

	/**
	 * オプショナル描画オブジェクトの削除
	 */
	public void removeOptionalDrawObject(Object o) {
		if (!mOptionalDrawElement.contains(o))
			return;
		mOptionalDrawElement.remove(o);
	}

	public void addAdditionalDrawingGeometry(Geometry g) {
		if (mAdditionalDrawGeoms.contains(g))
			return;
		mAdditionalDrawGeoms.add(g);
	}

	public void removeAdditionalDrawingGeometry(Geometry g) {
		if (!mAdditionalDrawGeoms.contains(g))
			return;
		mAdditionalDrawGeoms.remove(g);
	}

	public void removeAllAdditionalDrawingGeometry() {
		mAdditionalDrawGeoms.clear();
	}

	/**
	 * @param dispGrid the dispGrid to set
	 */
	public void setDispGrid(boolean dispGrid) {
		mDispGrid = dispGrid;
	}

	/**
	 * @return the dispGrid
	 */
	public boolean isDispGrid() {
		return mDispGrid;
	}

	public void setDrawMode(short b) {
		mDrawMode = b;
	}

	public short getDrawMode() {
		return mDrawMode;
	}
}