/**
 *
 */
package nethome5.text;

import java.io.Serializable;

import jp.kitec.lib.util.StringUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome5.text.TextLayout.Alignment;
import nethome5.text.TextLayout.HorDirection;
import nethome5.text.TextLayout.TextDirection;
import nethome5.text.TextLayout.TextLineAutoTurn;
import nethome5.text.TextLayout.VerDirection;

/**
 *
 * @since 2010/05/11
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
@SuppressWarnings("serial")
public class GenericTextLayout implements ITextLayout, Serializable {
	/* 現在、向きは設定できない */
	/** 横書きの垂直方向の向き */
	private VerDirection vDirectionYoko = VerDirection.TB;
	/** 横書きの水平方向の向き */
	private HorDirection hDirectionYoko = HorDirection.LR;
	/** 縦書きの垂直方向の向き */
	private VerDirection vDirectionTate = VerDirection.TB;
	/** 縦書きの水平方向の向き */
	private HorDirection hDirectionTate = HorDirection.RL;

	/*  */
	/** 行のアラインメント */
	protected Alignment lineAlignment = Alignment.TOP;
	/** 文字のアラインメント */
	protected Alignment charAlignment = Alignment.TOP;
	/** 縦書き横書き */
	protected TextDirection textDirection = TextDirection.HOR;
	/** テキスト自動折り返し */
	protected TextLineAutoTurn autoTurn = TextLineAutoTurn.ON;
	/** マージン */
	protected double marginTop = 1, marginBot = 1, marginLeft = 1, marginRight = 1;

	/**  */
	protected double fixLineSpacePoint = 2;
	/**  */
	protected boolean autoSpacing = true;
	/**  */
	protected double autoSpaceRatio = 0.6f;
	/**
	 * コンストラクタ.
	 * @since 2010/05/11
	 * @author kamimura
	 */
	public GenericTextLayout() {
	}

	/*
	 * @see nethome.text.ITextLayout#getAutoTurn()
	 * @since 2010/05/11
	 */
	@Override
	public TextLineAutoTurn getAutoTurn() {
		return this.autoTurn;
	}

	/*
	 * @see nethome.text.ITextLayout#getCharAlignment()
	 * @since 2010/05/11
	 */
	@Override
	public Alignment getCharAlignment() {
		return this.charAlignment;
	}

	/*
	 * @see nethome.text.ITextLayout#getHorDirectionTate()
	 * @since 2010/05/11
	 */
	@Override
	public HorDirection getHorDirectionTate() {
		return this.hDirectionTate;
	}

	/*
	 * @see nethome.text.ITextLayout#getHorDirectionYoko()
	 * @since 2010/05/11
	 */
	@Override
	public HorDirection getHorDirectionYoko() {
		return this.hDirectionYoko;
	}

	/*
	 * @see nethome.text.ITextLayout#getLineAlignment()
	 * @since 2010/05/11
	 */
	@Override
	public Alignment getLineAlignment() {
		return this.lineAlignment;
	}

	/*
	 * @see nethome.text.ITextLayout#getTextDirection()
	 * @since 2010/05/11
	 */
	@Override
	public TextDirection getTextDirection() {
		return this.textDirection;
	}

	/*
	 * @see nethome.text.ITextLayout#getVertDirectionTate()
	 * @since 2010/05/11
	 */
	@Override
	public VerDirection getVertDirectionTate() {
		return this.vDirectionTate;
	}

	/*
	 * @see nethome.text.ITextLayout#getVertDirectionYoko()
	 * @since 2010/05/11
	 */
	@Override
	public VerDirection getVertDirectionYoko() {
		return this.vDirectionYoko;
	}

	/*
	 * @see nethome.text.ITextLayout#setAutoTurn(option.text.TextLayout.TextLineAutoTurn)
	 * @since 2010/05/11
	 */
	@Override
	public void setAutoTurn(TextLineAutoTurn autoTurn) {
		this.autoTurn = autoTurn;
	}

	/*
	 * @see nethome.text.ITextLayout#setCharAlignment(option.text.TextLayout.Alignment)
	 * @since 2010/05/11
	 */
	@Override
	public void setCharAlignment(Alignment charAlignment) {
		this.charAlignment = charAlignment;
	}

	/*
	 * @see nethome.text.ITextLayout#setHorDirectionTate(option.text.TextLayout.HorDirection)
	 * @since 2010/05/11
	 */
	@Override
	public void setHorDirectionTate(HorDirection hDirectionTate) {
		this.hDirectionTate = hDirectionTate;
	}

	/*
	 * @see nethome.text.ITextLayout#setHorDirectionYoko(option.text.TextLayout.HorDirection)
	 * @since 2010/05/11
	 */
	@Override
	public void setHorDirectionYoko(HorDirection hDirectionYoko) {
		this.hDirectionYoko = hDirectionYoko;
	}

	/*
	 * @see nethome.text.ITextLayout#setLayout(nethome.text.ITextLayout)
	 * @since 2010/05/11
	 */
	@Override
	public void setLayout(ITextLayout layout) {
		if(layout==null)
			return;
		this.setAutoTurn(layout.getAutoTurn());
		this.setCharAlignment(layout.getCharAlignment());
		this.setHorDirectionTate(layout.getHorDirectionTate());
		this.setHorDirectionYoko(layout.getHorDirectionYoko());
		this.setLineAlignment(layout.getLineAlignment());
		this.setTextDirection(layout.getTextDirection());
		this.setVertDirectionTate(layout.getVertDirectionTate());
		this.setVertDirectionYoko(layout.getVertDirectionYoko());

		this.setMargin(layout.getTopMargin(), layout.getBottomMargin(), layout.getLeftMargin(), layout.getRightMargin());

		this.setAutoLineSpacing(layout.isAutoLineSpacing());
		this.setFixLineSpaceInPoint(layout.getFixLineSpaceInPoint());
		this.setAutoLineSpaceRatio(layout.getAutoLineSpaceRatio());
	}

	/*
	 * @see nethome.text.ITextLayout#setLineAlignment(option.text.TextLayout.Alignment)
	 * @since 2010/05/11
	 */
	@Override
	public void setLineAlignment(Alignment lineAlignment) {
		this.lineAlignment = lineAlignment;
	}

	/*
	 * @see nethome.text.ITextLayout#setTextDirection(option.text.TextLayout.TextDirection)
	 * @since 2010/05/11
	 */
	@Override
	public void setTextDirection(TextDirection textDirection) {
		this.textDirection = textDirection;
	}

	/*
	 * @see nethome.text.ITextLayout#setVertDirectionTate(option.text.TextLayout.VerDirection)
	 * @since 2010/05/11
	 */
	@Override
	public void setVertDirectionTate(VerDirection vDirectionTate) {
		this.vDirectionTate = vDirectionTate;
	}

	/*
	 * @see nethome.text.ITextLayout#setVertDirectionYoko(option.text.TextLayout.VerDirection)
	 * @since 2010/05/11
	 */
	@Override
	public void setVertDirectionYoko(VerDirection vDirectionYoko) {
		this.vDirectionYoko = vDirectionYoko;
	}

	@Override
	public void setMargin(double top, double bot, double left, double right) {
		this.marginTop = top;
		this.marginBot = bot;
		this.marginLeft = left;
		this.marginRight = right;
	}

	@Override
	public double getTopMargin() {
		return marginTop;
	}

	@Override
	public double getBottomMargin() {
		return marginBot;
	}

	@Override
	public double getLeftMargin() {
		return marginLeft;
	}

	@Override
	public double getRightMargin() {
		return marginRight;
	}
	@Override
	public void loadLayout(ObjectFolder savenode) {
		ObjectNode on;
		if((on = savenode.getNode("textDirection"))!=null)
			textDirection = getEnum(TextDirection.class, on);
		if((on = savenode.getNode("turn"))!=null)
			autoTurn = getEnum(TextLineAutoTurn.class, on);
		if((on = savenode.getNode("alignChar"))!=null)
			charAlignment = getEnum(Alignment.class, on);
		if((on = savenode.getNode("alignLine"))!=null)
			lineAlignment = getEnum(Alignment.class, on);
		if((on = savenode.getNode("dirHorTate"))!=null)
			hDirectionTate = getEnum(HorDirection.class, on);
		if((on = savenode.getNode("dirHorYoko"))!=null)
			hDirectionYoko = getEnum(HorDirection.class, on);
		if((on = savenode.getNode("dirVerTate"))!=null)
			vDirectionTate = getEnum(VerDirection.class, on);
		if((on = savenode.getNode("dirVerYoko"))!=null)
			vDirectionYoko = getEnum(VerDirection.class, on);

		if((on = savenode.getNode("margin"))!=null){
			double[] margin = StringUtil.parseDouble(ObjectNode.getNodeString(on));
			if(margin!=null && margin.length>=4){
				marginTop = margin[0];
				marginBot = margin[1];
				marginLeft = margin[2];
				marginRight = margin[3];
			}
		}

		if((on = savenode.getNode("autoSpacing"))!=null)
			autoSpacing = ObjectNode.getNodeBool(on);
		if((on = savenode.getNode("fixLineSpace"))!=null)
			fixLineSpacePoint = ObjectNode.getNodeDouble(on);
		if((on = savenode.getNode("autoLineSpaceRatio"))!=null)
			autoSpaceRatio = ObjectNode.getNodeDouble(on);

		if(savenode.getNode("autoSpacing")==null){
			setAutoLineSpacing(false);
			setFixLineSpaceInPoint(1.5f);
		}
	}

	@Override
	public void saveLayout(ObjectFolder savenode) {
		ObjectFolder.addNodeString(savenode, "textDirection", this.textDirection.name());
		ObjectFolder.addNodeString(savenode, "turn", this.autoTurn.name());
		ObjectFolder.addNodeString(savenode, "alignChar", this.charAlignment.name());
		ObjectFolder.addNodeString(savenode, "alignLine", this.lineAlignment.name());
		ObjectFolder.addNodeString(savenode, "dirHorTate", this.hDirectionTate.name());
		ObjectFolder.addNodeString(savenode, "dirHorYoko", this.hDirectionYoko.name());
		ObjectFolder.addNodeString(savenode, "dirVerTate", this.vDirectionTate.name());
		ObjectFolder.addNodeString(savenode, "dirVerYoko", this.vDirectionYoko.name());

		{
			StringBuilder sb = new StringBuilder();
			sb.append(this.marginTop);
			sb.append(",");
			sb.append(this.marginBot);
			sb.append(",");
			sb.append(this.marginLeft);
			sb.append(",");
			sb.append(this.marginRight);
			ObjectFolder.addNodeString(savenode, "margin", sb.toString());
		}

		{
			ObjectFolder.addNodeBool(savenode, "autoSpacing", this.autoSpacing);
			ObjectFolder.addNodeDouble(savenode, "fixLineSpace", fixLineSpacePoint);
			ObjectFolder.addNodeDouble(savenode, "autoLineSpaceRatio", autoSpaceRatio);
		}
	}

	@SuppressWarnings("unchecked")
	private <E extends Enum> E getEnum(Class<? extends Enum> e, ObjectNode on){
		try {
			return (E) Enum.valueOf(e, ObjectNode.getNodeString(on));
		} catch (Exception e1) {
			return (E) e.getEnumConstants()[0];
		}
	}

	@Override
	public double getFixLineSpaceInPoint() {
		return this.fixLineSpacePoint;
	}

	@Override
	public boolean isAutoLineSpacing() {
		return this.autoSpacing;
	}

	@Override
	public void setAutoLineSpacing(boolean state) {
		this.autoSpacing = state;
	}

	@Override
	public void setFixLineSpaceInPoint(double point) {
		this.fixLineSpacePoint = point;
	}

	@Override
	public void setAutoLineSpaceRatio(double ratio) {
		this.autoSpaceRatio = ratio;
	}

	@Override
	public double getAutoLineSpaceRatio() {
		return this.autoSpaceRatio;
	}
}
