package nethome5.geom.util;

import jp.kitec.lib.util.RefList;
import nethome5.geom.primitive.GPoint2Df;

/**
 * テッセレーションクラス
 *
 * @author kawae
 */
public class ToolTesse {
	private static final int FLAG_COMPLEX = 1; //コンプレックス頂点
	private static final int FLAG_DISABLE = 2; //無効な頂点
	private static final int FLAG_EXCEPTION = 4; //例外な頂点
	private static final int MAX_TRIANGLE = 256; //最大のプリミティブトライアングル数
	private static final int MAX_INTERSECTIONTEST = 5; //交差判定を開始するポリゴンの頂点数。

	//インデックスバッファ
	public static short[] mIndex = new short[MAX_TRIANGLE * 4];
	private static int mIndexPt = 0;
	private static short[] mSrc = new short[MAX_TRIANGLE];

	//FIXME 計算結果を返すのにスタティックフィールドを使わない
	public static boolean culc(RefList<? extends GPoint2Df> pts) {
		mIndexPt = 0;
		mSrc = new short[pts.size()];
		for (int i = 0; i < pts.size(); i++) {
			((GPoint2Df)pts.elementAt(i)).wideUseFlag = 0;
			mSrc[i] = (short)i;
		}
		for (int i = 0; i < mIndex.length; i++)
			mIndex[i] = 0;
		return tessellation(pts, mSrc, pts.size());
	}


	//------------------------------------------------------
	//テッセレーション（凸ポリゴンに分割する)
	//
	//J3DVertes vtx[] ...頂点
	//short[] src ...インデックス配列
	//int length  ...インデックスの長さ
	//------------------------------------------------------
	private static boolean tessellation(RefList<? extends GPoint2Df> vtx, short[] src, int length) {
		if (length < 3)
			return false;

		//３角形ポリゴンであれば結果を書きこんで終了
		if (length == 3) {
			mIndex[mIndexPt++] = (short) length;
			for (int i = 0; i < length; i++)
				mIndex[mIndexPt++] = src[i];
			return false;
		}

		//コンプレックス頂点を検索
		boolean complex = checkComplex(vtx, src, length);

		//例外頂点を消去
		for (int i = 0; i < length; i++) {
			if ((((GPoint2Df) vtx.elementAt(src[i])).wideUseFlag & FLAG_EXCEPTION) == 0)
				continue;
			for (int j = i; j < length - 1; j++)
				src[j] = src[j + 1];
			length--;
			i--;
		}

		if (complex) {
			//コンプレックス頂点が存在する場合分割
			division(vtx, src, length);
			return true;
		} else {
			//コンプレックス頂点が存在しない場合分割終了
			mIndex[mIndexPt++] = (short) length;
			for (int i = 0; i < length; i++)
				mIndex[mIndexPt++] = src[i];
		}
		return false;
	}
	/**
	 * コンプレックス頂点が存在するか確認
	 */
	private static boolean checkComplex(RefList<? extends GPoint2Df> vtx, short[] src, int length) {
		int complex = 0; //コンプレックス頂点の数

		for (int i = 0; i < length; i++) {
			//頂点
			GPoint2Df v = vtx.elementAt(src[i]);

			//頂点に繋がる二つの辺ベクトルを求める
			GPoint2Df v1 = vtx.elementAt(src[(i - 1 < 0 ? length - 1 : i - 1)]);
			GPoint2Df v2 = vtx.elementAt(src[(i + 1 >= length ? 0 : i + 1)]);

			double angl = ToolMath.getAngle2Lines(v2.x, v2.y, v.x, v.y, v1.x, v1.y);
			if (Math.abs(angl - Math.PI) < ToolMath.EPS) {
				v.wideUseFlag = FLAG_EXCEPTION;
				continue;
			}

			if (angl <= Math.PI) {
				v.wideUseFlag = 0;
			} else {
				v.wideUseFlag = FLAG_COMPLEX;
				complex++;
			}
		}

		//コンプレックス頂点が存在するか判定
		return (complex != 0);
	}

	//------------------------------------------------------
	//テッセレーション（コンプレックス頂点を含むポリゴンの分割）
	//
	//------------------------------------------------------
	private static void division(RefList<? extends GPoint2Df> vtx, short[] src, int length) {
		//コンプレックス頂点を一つ選ぶ
		int i;
		for (i = 0; i < length; i++)
			if ((((GPoint2Df) vtx.elementAt(src[i])).wideUseFlag & FLAG_COMPLEX) > 0)
				break;
		int base = i;

		//無効な頂点の設定
		GPoint2Df v1 = vtx.elementAt(src[base]);
		GPoint2Df v2 = vtx.elementAt(src[(base - 1 < 0 ? length - 1 : base - 1)]);
		GPoint2Df v3 = vtx.elementAt(src[(base + 1 >= length ? 0 : base + 1)]);

		v1.wideUseFlag |= FLAG_DISABLE;
		v2.wideUseFlag |= FLAG_DISABLE;
		v3.wideUseFlag |= FLAG_DISABLE;
		double angl1 = ToolMath.getAngle2Lines(v3.x, v3.y, v1.x, v1.y, v2.x, v2.y);

		for (i = 0; i < length; i++) {
			GPoint2Df t = vtx.elementAt(src[i]);
			if ((t.wideUseFlag & FLAG_DISABLE) != 0)
				continue;
			double angl2 = ToolMath.getAngle2Lines(v3.x, v3.y, v1.x, v1.y, t.x, t.y);
			if (angl2 > angl1)
				t.wideUseFlag |= FLAG_DISABLE;
		}

		//他の線分と交差する頂点を無効化
		if (length > MAX_INTERSECTIONTEST) {
			for (i = 0; i < length; i++) {
				GPoint2Df t = vtx.elementAt(src[i]);
				if ((t.wideUseFlag & FLAG_DISABLE) != 0)
					continue;
				for (int j = 0; j < length; j++) {
					if (intersection(v1, t, vtx.elementAt(src[j]), vtx.elementAt(src[(j + 1) % length]))) {
						t.wideUseFlag |= FLAG_DISABLE;
						break;
					}
				}
			}
		}

		//複数候補がある場合には，最も中心近くの角度のものを選ぶ。
		double da = Float.MAX_VALUE;
		int target = -1;
		for (i = 0; i < length; i++) {
			GPoint2Df t = vtx.elementAt(src[i]);
			if ((t.wideUseFlag & FLAG_DISABLE) != 0)
				continue;
			double angl2 = ToolMath.getAngle2Lines(v3.x, v3.y, v1.x, v1.y, t.x, t.y);
			double dat = Math.abs(angl1 / 2 - (angl1 - angl2));
			if (dat < da) {
				da = dat;
				target = i;
			}
		}

		if (target < 0)
			return;

		//分割したポリゴンに対して再帰的に処理を行う
		short[] dst = new short[length];
		int c, p = base;
		for (i = 0, c = 0; i < length; i++) {
			dst[i] = src[p];
			c++;
			if (p == target)
				break;
			p++;
			if (p >= length)
				p = 0;
		}

		tessellation(vtx, dst, c);

		for (i = 0, c = 0; i < length; i++) {
			dst[i] = src[p];
			c++;
			if (p == base)
				break;
			p++;
			if (p >= length)
				p = 0;
		}
		tessellation(vtx, dst, c);
	}

	//------------------------------------------------------
	//線分の交差判定
	//
	//------------------------------------------------------
	private static boolean intersection(GPoint2Df p1, GPoint2Df p2, GPoint2Df p3, GPoint2Df p4) {
		if (((p1.x - p2.x) * (p3.y - p1.y) + (p1.y - p2.y) * (p1.x - p3.x)) * ((p1.x - p2.x) * (p4.y - p1.y) + (p1.y - p2.y) * (p1.x - p4.x)) < 0) {
			if (((p3.x - p4.x) * (p1.y - p3.y) + (p3.y - p4.y) * (p3.x - p1.x)) * ((p3.x - p4.x) * (p2.y - p3.y) + (p3.y - p4.y) * (p3.x - p2.x)) < 0) {
				return true;
			}
		}
		return false;
	}

}