package nethome5.geom.primitive;

/**
 * スケーリング可能な幾何形状
 * @author matsuzaki
 *
 */
public interface IScalableGeometry {

	/**
	 * X方向へのスケーリングの許可
	 */
	public boolean isScaleEnX();

	/**
	 * X方向へのスケーリングの許可
	 */
	public void setScaleEnX(boolean s);

	/**
	 * Y方向へのスケーリングの許可
	 */
	public boolean isScaleEnY();

	/**
	 * Y方向へのスケーリングの許可
	 */
	public void setScaleEnY(boolean s);

	/**
	 * アスペクト比を固定するか
	 * @return the keepAspect
	 */
	public boolean isKeepAspect();

	/**
	 * アスペクト比を固定するかどうかを設定
	 * @param keepAspect the keepAspect to set
	 */
	public void setKeepAspect(boolean keepAspect);

	/**
	 * スケーリングの基点X
	 */
	public double getScaleBaseX();
	/**
	 * スケーリングの基点X
	 */
	public void setScaleBaseX(double d);

	/**
	 * スケーリングの基点Y
	 */
	public double getScaleBaseY();
	/**
	 * スケーリングの基点Y
	 */
	public void setScaleBaseY(double d);
}
