/*
 * Copyright (c) 2010 KITec Inc,.. All rights reserved.
 * @author matsuzaki
 */
/**
 *
 */
package nethome5.geom.primitive;


/**
 * @author matsuzaki
 *
 */
abstract public class GScalableGeometry extends Geometry implements IScalableGeometry {

	/** X方向へのスケーリングの許可 */
	protected boolean scaleEnX = false;

	/** Y方向へのスケーリングの許可 */
	protected boolean scaleEnY = false;

	/** アスペクト比一定のフラグ */
	protected boolean mKeepAspect = false;

	/** スケーリングの基点X */
	protected double scaleBaseX = 0;

	/** スケーリングの基点Y */
	protected double scaleBaseY = 0;



	/**
	 * コピーインスタンスの取得
	 *
	 * 引数インスタンスに対し属性をコピーする
	 * @param g　コピー属性設定対象オブジェクト
	 * @return
	 * @author kawae
	 * @since 2003/01/01
	 */
	@Override
	protected Geometry copyTo(Geometry g) {
		if (g == null)
			return null;
		super.copyTo(g);
		GScalableGeometry s = (GScalableGeometry)g;
		s.scaleEnX = scaleEnX;
		s.scaleEnY = scaleEnY;
		s.scaleBaseX = scaleBaseX;
		s.scaleBaseY = scaleBaseY;
		s.mKeepAspect = mKeepAspect;
		return g;
	}

	@Override
	public boolean isScaleEnX() {
		return scaleEnX;
	}

	@Override
	public void setScaleEnX(boolean scaleEnX) {
		this.scaleEnX = scaleEnX;
	}

	@Override
	public boolean isScaleEnY() {
		return scaleEnY;
	}

	@Override
	public void setScaleEnY(boolean scaleEnY) {
		this.scaleEnY = scaleEnY;
	}

	@Override
	public double getScaleBaseX() {
		return scaleBaseX;
	}

	@Override
	public void setScaleBaseX(double scaleBaseX) {
		this.scaleBaseX = scaleBaseX;
	}

	@Override
	public double getScaleBaseY() {
		return scaleBaseY;
	}

	@Override
	public void setScaleBaseY(double scaleBaseY) {
		this.scaleBaseY = scaleBaseY;
	}

	/**
	 * アスペクト比を固定するか
	 * @return the keepAspect
	 */
	@Override
	public boolean isKeepAspect() {
		return mKeepAspect;
	}

	/**
	 * アスペクト比を固定するかどうかを設定
	 * @param keepAspect the keepAspect to set
	 */
	@Override
	public void setKeepAspect(boolean keepAspect) {
		mKeepAspect = keepAspect;
	}

}
