/*
 * Created on 2004/08/07
 */
package nethome5.geom;

/**
 * リンク先オブジェクトインターフェース
 * @author kawae
 */
public interface ILinkTarget {
	public static final short LINK_NONE = 0;
	public static final short LINK_FREE = 1;
	public static final short LINK_CENTER = 2;

	/**
	 * 特定の点からリンク先への距離の取得
	 */
	public double getLinkDistance(double x, double y);

	/**
	 * リンク先の点座標の取得
	 * @param px
	 * @param py
	 * @param rx
	 * @param ry
	 * @param linktype	リンクするタイプ
	 * @param resp		結果座標
	 * @return
	 * @author kawae
	 * @since 2004/10/08
	 */
	public boolean getLinkPoint(double px, double py, double rx, double ry, short linktype, double[] resp);

//	/**
//	 * 点から幾何形状中心までの法線の取得
//	 * @param x
//	 * @param y
//	 * @param resv
//	 */
//	public void getVectorPointToCenter(double x, double y, double[] resv);

	/**
	 * 点の法線の取得
	 */
	public void getNormal(double x, double y, double[] resv);
}
