/*
 * Created on 2004/08/07
 */
package nethome5.geom;

import java.util.List;

import nethome5.geom.primitive.Geometry;

/**
 * リンクライン
 * @author kawae
 */
public interface ILinkLine {

	/**
	 * リンクする端点オブジェクトか調べる
	 */
	public boolean isLinkNode(Object o);

	/**
	 * リンクモードの設定
	 * @param mode
	 * @author kawae
	 * @since 2004/10/04
	 */
	public void setLinkModeStart(short mode);
	public void setLinkModeEnd(short mode);

	/**
	 * リンクモードの取得
	 * @return
	 * @author kawae
	 * @since 2004/10/04
	 */
	public short getLinkModeStart();
	public short getLinkModeEnd();

	public void setLinkVH(boolean flag);
	public boolean isLinkVH();

	public boolean isLinkStart(Object o);
	public boolean isLinkEnd(Object o);


	public Object getLinkNodeStart();
	public Object getLinkNodeEnd();

	/**
	 * リンク先を設定
	 */
	public void setLinkObject(Object lnode, ILinkTarget ltarget);

	/**
	 * リンクオブジェクトにリンクしている幾何オブジェクトの取得
	 */
	public Geometry getLinkNode(ILinkTarget ltarget);

	/**
	 * ノードにリンクしているオブジェクトの取得
	 * @param node
	 * @return
	 * @author kawae
	 * @since 2004/10/08
	 */
	public ILinkTarget getLinkObject(Object node);

	public Geometry getRefNode(Geometry g);

	/**
	 * リンクの位置を更新
	 * @param g リンクの縛りの点オブジェクト
	 */
	public void updateLinkShape();

	/**
	 * 読み込み時等、ダミーのリンクオブジェクトのリカバリーを行う。
	 * @param geoms
	 * @author kawae
	 * @since 2004/11/02
	 */
	public void recoverLink(List<Geometry> geoms);
}
