package nethome5.geom;

import java.io.Serializable;

import jp.kitec.lib.util.RefList;
import nethome5.geom.primitive.GLine;
import nethome5.geom.util.ToolMath;

/**
 * <p>タイトル: </p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2001</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
 */
public class HatchPattern implements Serializable {

	/** 最大・最小にフィットパターン */
	public static final short MINMAXFIT = 0;

	/** 指定された間隔でフィットパターン */
	public static final short INTERVALFIT = 1;

	/** 対象の部屋に対してサイズ依存であるものパターン */
	public static final short SIZEDEPEND = 2;

	/** サブタイプリストから自動的に適合するものを選択する。 */
	public static final short SUBTYPESIZE = 3;

	/** ハッチ名 */
	private String mName;

	/** グループ名 */
	private String[] mGroupName;

	/** ｘ方向無限ライン */
	public RefList<Float> mInfinityX;

	/** ｙ方向無限ライン */
	public RefList<Float> mInfinityY;

	/** ライン */
	public RefList<GLine> mLines;

	/** 畳数 */
	public double mDisplaySize;

	/** サイクル */
	public double mCycleX, mCycleY;

	/** 最大・最小（無限パターンは除く) */
	public double mMinX, mMaxX, mMinY, mMaxY;

	/** フィットパターン */
	public short mFitPattern;

	/** 対象ポリゴンに対する内向きオフセット */
	public double mOffsetToInside = 0;

	/** ポリゴン領域を追加するかのフラグ　*/
	public boolean mFrameLine = false;

	/** ラインタイプ */
	public Ltype mLtype = null;

	/** スムースモード（平行なものに段差を付けないか */
	private boolean mSmooth;

	/** サブタイプ */
	private RefList mSubTypes;

	/**
	 * コンストラクタ
	 * @param	fitpattern	フィットするパターン
	 * @param	cycx	x方向の周期
	 * @param	cycy	y方向の周期
	 */
	public HatchPattern(String[] group) {
		mGroupName = group;
		mMinX = mMinY =  Float.MAX_VALUE;
		mMaxX = mMaxY = -Float.MAX_VALUE;
		mInfinityX = new RefList<Float>();
		mInfinityY = new RefList<Float>();
		mLines = new RefList<GLine>();
		mOffsetToInside = 0;
		mFrameLine = false;
		mSmooth = false;
		mDisplaySize = -1;
		mSubTypes = new RefList();
	}

//	public static HatchPattern readData(AbstFile r, Document doc, double version) throws Exception {
//		String str;
//		HatchPattern hp = null;
//		str = r.readLineFromBuffer();
//		StringTokenizer st = new StringTokenizer(str, " ,");
//		String grp[] = null;
//		Object o = MainRuntime.getInstance().getLibrary(LibraryTag.LIBRARY_HATCH);
//		if (o == null || !(o instanceof Library))
//		    return null;
//		Library dl = (Library)o;
//
//		if (st.countTokens() > 1)
//			grp = new String[st.countTokens()];
//		if (grp != null) {
//			int c = 0;
//			while(st.hasMoreElements()) {
//				str = (String)st.nextElement();
//				grp[c++] = str;
//			}
//			ObjectNode on = dl.getLibraryTree(Library.LIB_HATCH);
//			for (int j = 0; j < grp.length; j++) {
//				if (on instanceof ObjectFolder) {
//					on = ((ObjectFolder)on).getNode(grp[j]);
//					if (on == null)
//						break;
//				}
//			}
//			if (on != null)
//				hp = (HatchPattern)on.getObject();
//		}
//
//		while (true) {
//			str = r.readLineFromBuffer();
//			if (str == null) {
//				break;
//			} else if (str.trim().equalsIgnoreCase("</HATCH>"))
//				break;
//		}
//		return hp;
//	}
//
//	public void saveGeom(AbstFile w, String space) throws Exception {
//		String newspace = space + " ";
//		w.writeStringToBuffer(space + "<HATCH>\r\n");
//		String[] grp = getGroupName();
//		w.writeStringToBuffer(newspace);
//		if (grp != null)
//			for (int j = 0; j < grp.length; j++)
//				w.writeStringToBuffer(grp[j] + ",");
//		w.writeStringToBuffer(getName() + "\r\n");
//		w.writeStringToBuffer(space + "</HATCH>\r\n");
//	}

	/**
	 * サブタイプの取得
	 */
	public RefList getSubTypes() {
		return mSubTypes;
	}

	public void addSubType(int x, int y, int w, int h) {
		int[] st = new int[]{x, y, w, h};
		mSubTypes.addElement(st);

	}
	public void addSubType2(double cx, double cy, double w, double h) {
		double[] st = new double[]{cx, cy, w, h};
		mSubTypes.addElement(st);

	}

	public int[] getSubtype(int w, int h) {
		for (int i = 0; i < mSubTypes.size(); i++) {
			int[] st = (int[])mSubTypes.elementAt(i);
			if (st[0] == w && st[1] == h)
				return st;
		}
		return null;
	}
	public double[] getSubtype2(int w, int h) {
		for (int i = 0; i < mSubTypes.size(); i++) {
			double[] st = (double[])mSubTypes.elementAt(i);
			if (Math.abs(st[0] - w) < ToolMath.EPS && Math.abs(st[1] - h) < ToolMath.EPS)
				return st;
		}
		return null;
	}

	public void setGroup(String[] s) {
		mGroupName = s;
	}

	public String[] getGroupName() {
		return mGroupName;
	}

	public void setName(String s) {
		mName = s;
	}

	public String getName() {
		return mName;
	}

	public void setArea(double f) {
		mDisplaySize = f;
	}
	public double getArea() {
		return mDisplaySize;
	}

	/**
	 * フィットパターンの設定
	 */
	public void setFitPattern(short fitpattern) {
		mFitPattern = fitpattern;
	}

	/**
	 * サイクルの指定
	 */
	public void setCycle(double cycx, double cycy) {
		mCycleX = cycx;
		mCycleY = cycy;
	}

	/**
	 * スムースモードの設定
	 */
	public void setSmooth(boolean b) {
		mSmooth = b;
	}

	/**
	 * スムースモードの取得
	 */
	public boolean getSmooth() {
		return mSmooth;
	}

	/**
	 * 最大・最小領域の設定
	 */
	public void setMinMax(double xmin, double ymin, double xmax, double ymax) {
		mMinX = xmin;
		mMaxX = xmax;
		mMinY = ymin;
		mMaxY = ymax;
	}

	/**
	 * ｘ方向無限ライン追加
	 */
	public void addInfinityX(double x) {
		Float f = new Float(x);
		mInfinityX.addElement(f);
	}

	/**
	 * ｙ方向無限ライン追加
	 */
	public void addInfinityY(double y) {
		Float f = new Float(y);
		mInfinityY.addElement(f);
	}

	/**
	 * 線追加
	 */
	public void addLine(double x1, double y1, double x2, double y2) {
		mLines.addElement(new GLine(x1, y1, x2, y2));
	}

	public void addMinMaxLine() {
		mLines.addElement(new GLine(mMinX, mMinY, mMaxX, mMinY));
		mLines.addElement(new GLine(mMinX, mMinY, mMinX, mMaxY));
		mLines.addElement(new GLine(mMinX, mMaxY, mMaxX, mMaxY));
		mLines.addElement(new GLine(mMaxX, mMinY, mMaxX, mMaxY));
	}
}
