package nethome5.doc;

import java.util.EventObject;

/**
 * ProjectEventは、イベントソースでプロジェクトが変更されたことを通知するために使用されます。
 * @author matsuzaki
 *
 */
public class ProjectEvent extends EventObject {

	private static final long serialVersionUID = 1L;

	private Project mProject;

	public ProjectEvent(Object source, Project project) {
		super(source);
		mProject = project;
	}

	/**
	 * 変更されたプロジェクトを返します。
	 * @return
	 */
	public Project getProject() {
		return mProject;
	}
}
