package nethome5.doc;

import java.util.ArrayList;

import jp.kitec.lib.util.History;
import jp.kitec.lib.util.SerializeHistoryDataConverter;

public class DefaultProjectHistoryManager<T extends DefaultProject<T>> implements ProjectHistoryManager<T> {

	/** 管理プロジェクト */
	private T mProject;

	/** ヒストリー */
	private History<Object, byte[]> mHistory;

	/**
	 * コンストラクタ
	 */
	public DefaultProjectHistoryManager(int histnum) {
		mHistory = new History<Object, byte[]>(histnum, new SerializeHistoryDataConverter());
	}

	@Override
	public void setProject(T project) {
		mProject = project;
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#flushHistory()
	 */
	@Override
	public void flushHistory() {
		mHistory.flushHistory();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#setHistoryObject(java.lang.Object)
	 */
	@Override
	public void setHistoryObject(Object o) {
		Object hisObj = mHistory.getConverter().readHistory((byte[])o);
		if (hisObj == null)
			return;
		else {
			Object[] obj = (Object[])hisObj;
			mProject.mLayers = (ArrayList<Layer>)obj[0];
			mProject.mActiveLayer = (Layer)obj[1];
		}
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#getLastHistory()
	 */
	@Override
	public Object getLastHistory() {
		return mHistory.getLastHistory();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#getCurrentHistory()
	 */
	@Override
	public Object getCurrentHistory() {
		return mHistory.getCurrentHistory();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#undo()
	 */
	@Override
	public boolean undo() {
		boolean flag = false;
		Object hisObj = mHistory.undo();
		if (hisObj == null)
			flag = false;
		else {
			Object[] obj = (Object[])hisObj;
			mProject.mLayers = (ArrayList<Layer>)obj[0];
			mProject.mActiveLayer = (Layer)obj[1];
			flag = true;
		}
		if (flag)
			mProject.setSaved(false);
		return flag;
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#redo()
	 */
	@Override
	public boolean redo() {
		boolean flag = false;
		Object hisObj = mHistory.redo();
		if (hisObj == null)
			flag = false;
		else {
			Object[] obj = (Object[])hisObj;
			mProject.mLayers = (ArrayList<Layer>)obj[0];
			mProject.mActiveLayer = (Layer)obj[1];
			flag = true;
		}
		if (flag)
			mProject.setSaved(false);
		return flag;
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#addHistory()
	 */
	@Override
	public void addHistory() {
		for (Layer l : mProject.getLayers()) {
			l.renumberID();
		}
		Object[] obj = new Object[] {mProject.getLayers(), mProject.mActiveLayer};
		mHistory.addHistory(obj);
		mProject.setSaved(false);
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#hasUndo()
	 */
	@Override
	public boolean hasUndo() {
		return mHistory.hasUndo();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#hasRedo()
	 */
	@Override
	public boolean hasRedo() {
		return mHistory.hasRedo();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#setMaxHistory(int)
	 */
	@Override
	public void setMaxHistory(int num) {
		mHistory.setMaxHistory(num);
	}
}