package nethome5.ui;

import nethome5.NethomeCoreResource;

final public class NethomeRuntime {
	static INethomeRuntime mInstance;

	final static String[] CONCRETE_CLASS_NAME = {
		"nethome.ui.SwingNethomeRuntime",
		"nethome.ui.AWTNethomeRuntime"
	};

	static {
		//XXX プロパティファイルか何かで指定したほうがいいか？
		boolean useCustomRuntime = false;
		try {
			useCustomRuntime = Boolean.getBoolean("nethome.use_custom_runtime");
		} catch (SecurityException e) {
		}
		if (!useCustomRuntime) {
			Class<? extends INethomeRuntime> clazz = null;

			if (NethomeCoreResource.RUNTIME_NAME != null) {
				try {
					clazz = (Class<? extends INethomeRuntime>)Class.forName(NethomeCoreResource.RUNTIME_NAME);
				} catch (ClassNotFoundException e) {
				}
			} else {
				for (String name : CONCRETE_CLASS_NAME) {
					try {
						clazz = (Class<? extends INethomeRuntime>)Class.forName(name);
					} catch (ClassNotFoundException e) {
					}
					if (clazz != null)
						break;
				}
			}
			if (clazz == null)
				throw new NullPointerException();
			try {
				mInstance = clazz.newInstance();
			} catch (InstantiationException e) {
				throw new RuntimeException(e);
			} catch (IllegalAccessException e) {
				throw new RuntimeException(e);
			}
		}
	}

	/**
	 * @param instance the instance to set
	 */
	public static void setInstance(INethomeRuntime instance) {
		mInstance = instance;
	}

	public static INethomeRuntime getInstance() {
		return mInstance;
	}
}
