package nethome5.geom.util;

import jp.kitec.lib.util.Item;
import jp.kitec.lib.util.RefList;
import nethome5.geom.primitive.GPoint2Df;

/**
 * <p>タイトル: </p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2002</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
 */

public class ToolPolygon {

	private static double[] tmpf = new double[2];

	/**
	 * 面積の取得
	 * @param polygon
	 * @param p1x
	 * @param p1y
	 * @return
	 */
	public static double getArea(RefList<? extends GPoint2Df> polygon, GPoint2Df cgp) {
		double xbase, ybase;					//計算の基点
		double xold, yold;
		double cgx = 0;
		double cgy = 0;
		double area = 0.0f;

		xbase = ((GPoint2Df)polygon.lastElement()).x;
		ybase = ((GPoint2Df)polygon.lastElement()).y;
		xold = ((GPoint2Df)polygon.elementAt(0)).x;
		yold = ((GPoint2Df)polygon.elementAt(0)).y;
		for (int i = 1; i < polygon.size(); i++) {
			double x = ((GPoint2Df)polygon.elementAt(i)).x;
			double y = ((GPoint2Df)polygon.elementAt(i)).y;

			double areatria = ((xbase - x) * (yold - ybase) + (xold - xbase) * (y - ybase)) / 2.0f;
			cgx += areatria * (x + xold);
			cgy += areatria * (y + yold);

			area += areatria;
			xold = x;
			yold = y;
		}
		if (cgp != null) {
			cgp.x = (cgx / area + xbase) / 3.0f;
			cgp.y = (cgy / area + ybase) / 3.0f;
		}

		if (area < 1.e-3f)
			return 0;

		return area;
	}

	/**
	 * 点がポリゴン内にあるかの判定
	 * @param polygon	ポリゴン(Node派生オブジェクトのリスト)
	 * @param p			検査する点
	 */
	public static boolean isInnerPolygon(RefList<? extends GPoint2Df> polygon, double x, double y) {
		double k;
		double sum = 0;

		for(int i = 0; i < polygon.size(); i++ ) {
			GPoint2Df pa = polygon.elementAt(i);
			GPoint2Df pb = polygon.elementAt(i + 1);
			if (ToolMath.isOnLimitLinePoint2D(x, y, pa.x, pa.y, pb.x, pb.y))
				return true;
			//	２頂点と試験点との成す角を求める
			k = ToolMath.getAngle2D(x, y, pb.x, pb.y) - ToolMath.getAngle2D(x, y, pa.x, pa.y);
			if( k < -Math.PI )
				k += 2 * Math.PI;
			else if( k > Math.PI )
				k -= 2 * Math.PI;
			sum += k;
		}
		sum = Math.abs(sum);
		if(Math.abs(sum - Math.PI * 2) < 1e-3)
			return true;
		return false;
	}

	/**
	 * 点がポリゴンのエッジ上にあるかの判定
	 * @param polygon	ポリゴン(Node派生オブジェクトのリスト)
	 * @param p			検査する点
	 */
	public static <T extends GPoint2Df> boolean isOnLinePolygon(RefList<T> polygon, double x1, double y1, double x2, double y2) {
		Item<T> it = null;
		//始点の検索
		for (int i = 0; i < polygon.size(); i++) {
			GPoint2Df p0 = polygon.elementAt(i - 1);
			GPoint2Df p1 = polygon.elementAt(i);
			GPoint2Df p2 = polygon.elementAt(i + 1);
			if (!ToolMathEx.isParallel2D(p0, p1, p1, p2)) {
				it = polygon.itemAt(i);
				break;
			}
		}
		if (it == null)
			return false;
		//チェック
		Item<T> start = it;
		do {
			GPoint2Df pa = it.getObject();
			GPoint2Df pb = it.nextItem.getObject();
			while(true) {
				it = it.nextItem;
				if (it == start)
					break;
				GPoint2Df pc = it.nextItem.getObject();
				if (!ToolMathEx.isParallel2D(pa, pb, pb, pc))
					break;
				pb = pc;
			}
			if (ToolMath.isOnLimitLinePoint2D(x1, y1, pa.x, pa.y, pb.x, pb.y) && ToolMath.isOnLimitLinePoint2D(x2, y2, pa.x, pa.y, pb.x, pb.y) )
				return true;
		} while(it != start);
		return false;
	}

	/**
	 * 回りが正しい方向か確認
	 * @param	polygon	確認するポリゴン
	 * @return
	 */
	public static boolean isCorrectRotation(RefList<GPoint2Df> polygon) {
		double	minx;
		double	angle;
		Item<GPoint2Df>	node;

		//最も左の頂点を探す
		Item<GPoint2Df> n2nd = polygon.itemAt(0);
		minx = n2nd.getObject().x;
		for (node = polygon.itemAt(0).nextItem; node !=polygon.itemAt(0); node = node.nextItem) {
			if (node.getObject().x < minx) {
				minx = node.getObject().x;
				n2nd = node;
			}
		}

		Item<GPoint2Df> n1st = n2nd.prevItem;
		Item<GPoint2Df> n3rd = null;
		node = n2nd.nextItem;
		GPoint2Df p1 = n1st.getObject();
		GPoint2Df p2 = n2nd.getObject();
		GPoint2Df p3;
		do {
			p3 = node.getObject();
			if (!ToolMath.isParallel2D(p2.x, p2.y, p1.x, p1.y, p2.x, p2.y, p3.x, p3.y)) {
				n3rd = node;
				break;
			}
		} while((node = node.nextItem) != n2nd);
		if (n3rd == null)
			return false;

		//辺の次の頂点との位置関係を調べる
		angle = ToolMath.getAngle2D(n1st.getObject().x, n1st.getObject().y, n2nd.getObject().x, n2nd.getObject().y);
		double[] chkcoord = new double[2];
		ToolMath.rotation2D(n1st.getObject().x, n1st.getObject().y, -angle, n3rd.getObject().x, n3rd.getObject().y, chkcoord);
		if (chkcoord[1] > n1st.getObject().y)
			return true;
		return false;

	}

	/**
	 * ハッチングラインの取得
	 * @param polygon	ハッチラインを抽出するポリゴン
	 * @param x1	一点目X
	 * @param y1	点目Y
	 * @param x2	一点目X
	 * @param y2	二点目Y
	 * @return
	 */
	public static RefList<GPoint2Df> getHatchingLine(RefList<? extends GPoint2Df> polygon, double x1, double y1, double x2, double y2) {
		RefList<GPoint2Df> r = new RefList<GPoint2Df>();
		double[] res = new double[2];

		for (int j = 0; j < polygon.size(); j++) {
			GPoint2Df p1 = polygon.elementAt(j);
			GPoint2Df p2 = polygon.elementAt(j + 1);

			if (isInnerPolygon(polygon, x1, y1))
				r.addElement(new GPoint2Df(x1, y1));
			if (isInnerPolygon(polygon, x2, y2))
				r.addElement(new GPoint2Df(x2, y2));
			if (!ToolMath.isParallel2D(x1, y1, x2, y2, p1.x, p1.y, p2.x, p2.y)) {
				if (ToolMath.isCrossSegment(x1, y1, x2, y2, p1.x, p1.y, p2.x, p2.y, res))
					r.addElement(new GPoint2Df(res[0], res[1]));
			}
		}
		if (r.size() == 0)
			return null;
		removeOverlapNode(r);

		if (r.size() == 0)
			return null;
		return r;
	}

	/**
	 * 重なった点を削除
	 * @param r
	 */
	public static <T extends GPoint2Df> void removeOverlapNode(RefList<T> r) {
		Item<T> it1 = r.itemAt(0), it2, it2next;
		for (int i = 0; i < r.size() - 1; i++) {
			it2 = it1.nextItem;
			int count = r.size();
			for (int j = i + 1; j < count; j++) {
				it2next = it2.nextItem;
				if (ToolMath.isSame2D(it1.getObject().x, it1.getObject().y, it2.getObject().x, it2.getObject().y))
					r.removeItemAt(it2);
				it2 = it2next;
			}
			it1 = it1.nextItem;
		}
	}

	/**
	 * 重なった点を削除
	 * @param r
	 */
	public static void removeOverlapNode2(RefList<? extends GPoint2Df> r) {
		for (int i = 0; i < r.size(); i++) {
			GPoint2Df p1 = r.elementAt(i);
			GPoint2Df p2 = r.elementAt(i + 1);
			if (ToolMath.isSame2D(p1.x, p1.y, p2.x, p2.y)) {
				r.removeElement(p2);
				i--;
			}
		}
	}

	/**
	 * ポリゴン構成点の前後が平行であれば削除
	 * @param	r	対象ポリゴン
	 */
	public static <T extends GPoint2Df> void removeParaNodes(RefList<T> r) {
		int count = r.size();
		Item<T> it = r.itemAt(0);
		for (int i = 0; i < count; i++) {
			Item<T> itnext = it.nextItem;
			GPoint2Df p1 = it.prevItem.getObject();
			GPoint2Df p2 = it.getObject();
			GPoint2Df p3 = it.nextItem.getObject();
			if (ToolMath.isOnLine(p1.x, p1.y, p2.x, p2.y, p2.x, p2.y, p3.x, p3.y))
				r.removeItemAt(it);
			it = itnext;
		}
	}

	/**
	 * 点がポリゴンのエッジ上に乗っているか確認
	 * @param polygon
	 * @param x
	 * @param y
	 * @return
	 */
	public static boolean isOnEdge(RefList<? extends GPoint2Df> polygon, double x, double y) {
		for (int i = 0; i < polygon.size(); i++) {
			GPoint2Df p1 = polygon.elementAt(i);
			GPoint2Df p2 = polygon.elementAt(i + 1);
			if (ToolMath.isOnLimitLinePoint2D(x, y, p1.x, p1.y, p2.x, p2.y))
				return true;
		}
		return false;
	}

	/**
	 * ２つのポリゴンが重なりを持つかの確認
	 * @param pa
	 * @param pb
	 * @return
	 */
	public static boolean isOverlap(RefList<? extends GPoint2Df> pa, RefList<? extends GPoint2Df> pb) {
		for (int i = 0; i < pa.size(); i++) {
			GPoint2Df p = pa.elementAt(i);
			if (isInnerPolygon(pb, p.x, p.y))
				return true;
		}
		for (int i = 0; i < pb.size(); i++) {
			GPoint2Df p = pb.elementAt(i);
			if (isInnerPolygon(pa, p.x, p.y))
				return true;
		}
		return false;
	}

	/**
	 * ２つのポリゴンが交差点を持つかの確認
	 * @param pa
	 * @param pb
	 * @return
	 */
	public static boolean isHasCross(RefList<? extends GPoint2Df> pa, RefList<? extends GPoint2Df> pb) {
		for (int i = 0; i < pa.size(); i++) {
			GPoint2Df p1 = pa.elementAt(i);
			GPoint2Df p2 = pa.elementAt(i + 1);
			for (int j = 0; j < pb.size(); j++) {
				GPoint2Df p3 = pb.elementAt(j);
				GPoint2Df p4 = pb.elementAt(j + 1);
				if (ToolMathEx.isLimitLineCross2D(p1, p2, p3, p4, null))
					return true;
				if (ToolMathEx.isOnLimitLinePoint2D(p1, p3, p4) ||
				    ToolMathEx.isOnLimitLinePoint2D(p3, p1, p2))
				    return true;
			}
		}
		return false;
	}

	/**
	 * 線上ではなく、完全に交差するか確認
	 *
	 */
	public static boolean isCompleteCrossLine(GPoint2Df p1, GPoint2Df p2, GPoint2Df p3, GPoint2Df p4) {
		if (ToolMath.isCrossSegment(p3.x, p3.y, p4.x, p4.y, p1.x, p1.y, p2.x, p2.y, tmpf) && !ToolMath.isOnLine(p3.x, p3.y, p4.x, p4.y, p1.x, p1.y, p2.x, p2.y)) {
			if (!ToolMath.isSame2D(tmpf[0], tmpf[1], p3.x, p3.y) && !ToolMath.isSame2D(tmpf[0], tmpf[1], p4.x, p4.y) &&
				!ToolMath.isSame2D(tmpf[0], tmpf[1], p1.x, p1.y) && !ToolMath.isSame2D(tmpf[0], tmpf[1], p2.x, p2.y)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * aはbに含まれるか
	 * @param a
	 * @param b
	 * @return
	 */
	public static boolean checkInclude(RefList<GPoint2Df> A, RefList<GPoint2Df> B) {
		RefList<GPoint2Df> a = A.getCopy();
		RefList<GPoint2Df> b = B.getCopy();
		intersect(a, b);
		for (int i = 0; i < a.size(); i++) {
			GPoint2Df p1 = a.elementAt(i);
			GPoint2Df p2 = a.elementAt(i + 1);
			double x = (p1.x + p2.x) / 2;
			double y = (p1.y + p2.y) / 2;
			if (!isInnerPolygon(b, x, y))
				return false;
		}
		return true;
	}

	/**
	 * 自己交差していないか確認
	 */
	public static boolean isHasSelfCross(RefList<? extends GPoint2Df> r) {
		for (int i = 0; i < r.size() - 1; i++) {
			for (int j = i + 1; j < r.size(); j++) {
				GPoint2Df p1 = r.elementAt(i);
				GPoint2Df p2 = r.elementAt(i + 1);
				GPoint2Df pa = r.elementAt(j);
				GPoint2Df pb = r.elementAt(j + 1);
				if (ToolMathEx.isLimitLineCross2D(p1, p2, pa, pb, tmpf)) {
					if (ToolMath.isSame2D(p1.x, p1.y, tmpf[0], tmpf[1]) || ToolMath.isSame2D(p2.x, p2.y, tmpf[0], tmpf[1]))
						continue;
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 交点を挿入
	 * @param a
	 * @param b
	 */
	private static void intersect(RefList<GPoint2Df> a, RefList<GPoint2Df> b) {
		for (int i = 0; i < a.size(); i++) {
			GPoint2Df pa1 = a.elementAt(i);
			for (int j = 0; j < b.size(); j++) {
				GPoint2Df pb1 = b.elementAt(j);
				GPoint2Df pb2 = b.elementAt(j + 1);
				if (ToolMath.isOnLimitLinePoint2D(pa1.x, pa1.y, pb1.x, pb1.y, pb2.x, pb2.y)) {
					if (!ToolMath.isSame2D(pa1.x, pa1.y, pb1.x, pb1.y) && !ToolMath.isSame2D(pa1.x, pa1.y, pb2.x, pb2.y)) {
						b.insertElementAt(new GPoint2Df(pa1.x, pa1.y), j);
						break;
					}
				}
			}
		}
		for (int i = 0; i < b.size(); i++) {
			GPoint2Df pb1 = b.elementAt(i);
			for (int j = 0; j < a.size(); j++) {
				GPoint2Df pa1 = b.elementAt(j);
				GPoint2Df pa2 = b.elementAt(j + 1);
				if (ToolMath.isOnLimitLinePoint2D(pb1.x, pb1.y, pa1.x, pa1.y, pa2.x, pa2.y)) {
					if (!ToolMath.isSame2D(pb1.x, pb1.y, pa1.x, pa1.y) && !ToolMath.isSame2D(pb1.x, pb1.y, pa2.x, pa2.y)) {
						a.insertElementAt(new GPoint2Df(pb1.x, pb1.y), j);
						break;
					}
				}
			}
		}

		double res[] = new double[2];
		GPoint2Df atmp, btmp, atmpn, btmpn;

		Item<GPoint2Df> ita = a.itemAt(0);
		do {
			Item<GPoint2Df> itb = b.itemAt(0);
			do {
				atmp  = ita.getObject();
				atmpn = ita.nextItem.getObject();
				btmp  = itb.getObject();
				btmpn = itb.nextItem.getObject();
				if (ToolMath.isOnLine(atmp.x, atmp.y, atmpn.x, atmpn.y, btmp.x, btmp.y, btmpn.x, btmpn.y))
					continue;
				if (ToolMath.isCrossSegment(atmp.x, atmp.y, atmpn.x, atmpn.y, btmp.x, btmp.y, btmpn.x, btmpn.y, res)) {
					if (!ToolMath.isSame2D(atmp.x, atmp.y, res[0], res[1]) && !ToolMath.isSame2D(atmpn.x, atmpn.y, res[0], res[1]))
						a.insertElementAt(new GPoint2Df(res[0], res[1]), ita);
					if (!ToolMath.isSame2D(btmp.x, btmp.y, res[0], res[1]) && !ToolMath.isSame2D(btmpn.x, btmpn.y, res[0], res[1]))
						b.insertElementAt(new GPoint2Df(res[0], res[1]), itb);
				}
			} while ((itb = itb.nextItem) != b.itemAt(0));
		} while ((ita = ita.nextItem) != a.itemAt(0));
	}

	/**
	 * 領域の最大・最小のみで重なりを判断
	 * @param a
	 * @param b
	 * @return
	 */
	public boolean crossCheckArea(RefList<? extends GPoint2Df> a, RefList<? extends GPoint2Df>  b) {
		double xa1 = Float.MAX_VALUE, ya1 = Float.MAX_VALUE, xa2 = -Float.MAX_VALUE, ya2 = -Float.MAX_VALUE;
		double xb1 = Float.MAX_VALUE, yb1 = Float.MAX_VALUE, xb2 = -Float.MAX_VALUE, yb2 = -Float.MAX_VALUE;
		for (int i = 0; i < a.size(); i++) {
			GPoint2Df p = a.elementAt(i);
			if (i == 0) {
				xa1 = xa2 = p.x;
				ya1 = ya2 = p.y;
			} else {
				xa1 = p.x < xa1 ? p.x : xa1;
				ya1 = p.y < ya1 ? p.y : ya1;
				xa2 = p.x > xa2 ? p.x : xa2;
				ya2 = p.y > ya2 ? p.y : ya2;
			}
		}
		for (int i = 0; i < b.size(); i++) {
			GPoint2Df p = b.elementAt(i);
			if (i == 0) {
				xb1 = xb2 = p.x;
				yb1 = yb2 = p.y;
			} else {
				xb1 = p.x < xb1 ? p.x : xb1;
				yb1 = p.y < yb1 ? p.y : yb1;
				xb2 = p.x > xb2 ? p.x : xb2;
				yb2 = p.y > yb2 ? p.y : yb2;
			}
		}

		if (xb1 > xa2)
			return false;
		if (yb1 > ya2)
			return false;
		if (xa1 > xb2)
			return false;
		if (ya1 > yb2)
			return false;
		return true;
	}

	/**
	 * 共通のエッジを持つか確認
	 */
	public static boolean isHasCommonEdge(RefList<GPoint2Df> a, RefList<GPoint2Df> b) {
		intersect(a, b);
		intersect(b, a);
		for (int i = 0; i < a.size(); i++) {
			GPoint2Df p1 = a.elementAt(i);
			GPoint2Df p2 = a.elementAt(i + 1);
			for (int j = 0; j < b.size(); j++) {
				GPoint2Df pa = b.elementAt(j);
				GPoint2Df pb = b.elementAt(j + 1);
				if (ToolMath.isSameLine(p1.x, p1.y, p2.x, p2.y, pa.x, pa.y, pb.x, pb.y))
					return true;
			}
		}
		return false;
	}

	public static void removeOnLinePoint(RefList<? extends GPoint2Df>  pol) {
		for (int i = 0; i < pol.size(); i++) {
			GPoint2Df p1 = pol.elementAt(i);
			GPoint2Df p2 = pol.elementAt(i + 1);
			GPoint2Df p3 = pol.elementAt(i + 2);
			if (ToolMathEx.isSame2D(p1, p2))
				pol.removeElement(p2);
			else if (ToolMathEx.isOnLimitLinePoint2D(p1, p2, p3))
				pol.removeElement(p2);
			else if (ToolMathEx.isOnLimitLinePoint2D(p3, p1, p2))
				pol.removeElement(p2);
			else
				continue;
			i--;
		}
	}

	/**
	 * 	ポリゴンのX最大値の取得
	 */
	public static double getMinX(RefList<? extends GPoint2Df>  r) {
		double min = Float.MAX_VALUE;
		for (int i = 0; i < r.size(); i++) {
			GPoint2Df p = r.elementAt(i);
			min = p.x > min ? min:p.x;
		}
		return min;
	}

	/**
	 * 	ポリゴンのY最大値の取得
	 */
	public static double getMaxX(RefList<? extends GPoint2Df>  r) {
		double max = -Float.MAX_VALUE;
		for (int i = 0; i < r.size(); i++) {
			GPoint2Df p = r.elementAt(i);
			max = p.x < max ? max:p.x;
		}
		return max;
	}

	/**
	 * 	ポリゴンのX最小値の取得
	 */
	public static double getMinY(RefList<? extends GPoint2Df>  r) {
		double min = Float.MAX_VALUE;
		for (int i = 0; i < r.size(); i++) {
			GPoint2Df p = r.elementAt(i);
			min = p.y > min ? min:p.y;
		}
		return min;
	}

	/**
	 * 	ポリゴンのY最小値の取得
	 */
	public static double getMaxY(RefList<? extends GPoint2Df>  r) {
		double max = -Float.MAX_VALUE;
		for (int i = 0; i < r.size(); i++) {
			GPoint2Df p = r.elementAt(i);
			max = p.y < max ? max:p.y;
		}
		return max;
	}

	/**
	 * 	ポリゴンの最大・最小値の取得
	 */
	public static void getMinMax(RefList<? extends GPoint2Df>  r, double[] min, double[] max) {
		min[0] = Float.POSITIVE_INFINITY;
		min[1] = Float.POSITIVE_INFINITY;
		max[0] = Float.NEGATIVE_INFINITY;
		max[1] = Float.NEGATIVE_INFINITY;
		for (int i = 0; i < r.size(); i++) {
			GPoint2Df p = r.elementAt(i);
			min[0] = Math.min(p.x, min[0]);
			min[1] = Math.min(p.y, min[1]);
			max[0] = Math.max(p.x, max[0]);
			max[1] = Math.max(p.y, max[1]);
		}
	}

	public static final int POLY_NO_RELATION = 0;
	public static final int POLY_A_INCLUDE_B = 1;
	public static final int POLY_B_INCLUDE_A = 2;
	/**
	 * ２つのポリゴンの関係をチェック
	 * @param pa
	 * @param pb
	 */
	public static int check2PolygonRelation(RefList<GPoint2Df> pa, RefList<GPoint2Df> pb, boolean protectOrg) {
		RefList<GPoint2Df> a, b;
		if (protectOrg) {
			a = new RefList<GPoint2Df>();
			for (int i = 0; i < pa.size(); i++)
				a.addElement(pa.elementAt(i));
			b = new RefList<GPoint2Df>();
			for (int i = 0; i < pb.size(); i++)
				b.addElement(pb.elementAt(i));
		} else {
			a = pa;
			b = pb;
		}

		//最大値・最小値で判定
		{
			double minx1 = Float.MAX_VALUE, miny1 = Float.MAX_VALUE, maxx1 = -Float.MAX_VALUE, maxy1 = -Float.MAX_VALUE;
			double minx2 = Float.MAX_VALUE, miny2 = Float.MAX_VALUE, maxx2 = -Float.MAX_VALUE, maxy2 = -Float.MAX_VALUE;
			for (int i = 0; i < a.size(); i++) {
				GPoint2Df p = a.elementAt(i);
				minx1 = minx1 < p.x ? minx1 : p.x;
				miny1 = miny1 < p.y ? miny1 : p.y;
				maxx1 = maxx1 > p.x ? maxx1 : p.x;
				maxy1 = maxy1 > p.y ? maxy1 : p.y;
			}
			for (int i = 0; i < b.size(); i++) {
				GPoint2Df p = b.elementAt(i);
				minx2 = minx2 < p.x ? minx2 : p.x;
				miny2 = miny2 < p.y ? miny2 : p.y;
				maxx2 = maxx2 > p.x ? maxx2 : p.x;
				maxy2 = maxy2 > p.y ? maxy2 : p.y;
			}
			if (maxx1 < minx2 || maxx2 < minx1 || maxy1 < miny2 || maxy2 < miny1)
				return POLY_NO_RELATION;
		}
		//含まれているかチェック
		{
			if (checkInclude(a, b))
				return POLY_B_INCLUDE_A;
			if (checkInclude(b, a))
				return POLY_A_INCLUDE_B;
		}

		return -1;
	}

	public static boolean isAddPolylineToPoint(RefList<? extends GPoint2Df>  r, double x, double y) {
		if (r.size() > 0) {
			GPoint2Df p = r.lastElement();
			if (ToolMath.isSame2D(x, y, p.x, p.y))
				return false;
		}

		for (int i = 1; i < r.size(); i++) {
			GPoint2Df p = r.elementAt(i);
			if (ToolMath.isSame2D(x, y, p.x, p.y))
				return false;
		}

		if (r.size() < 3)
			return true;
		GPoint2Df ps = r.elementAt(0);
		GPoint2Df pe = r.lastElement();
		for (int i = 0; i < r.size() - 1; i++) {
			GPoint2Df p1 = r.elementAt(i);
			GPoint2Df p2 = r.elementAt(i + 1);
			if (ToolMath.isSame2D(pe.x, pe.y, x, y))
				return false;
			if (ToolMath.isCrossSegment(p1.x, p1.y, p2.x, p2.y, pe.x, pe.y, x, y, tmpf)) {
				if (!ToolMath.isSame2D(pe.x, pe.y, tmpf[0], tmpf[1]) && !ToolMath.isSame2D(ps.x, ps.y, tmpf[0], tmpf[1]))
					return false;
			}
		}
		return true;
	}

	/**
	 * 3角形処理の特別なポリゴン
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 * @param x3
	 * @param y3
	 * @return
	 */
	public static boolean getTriaRotation(double x1, double y1, double x2, double y2, double x3, double y3) {
		RefList<GPoint2Df> triaList = new RefList<GPoint2Df>();
		triaList.addElement(new GPoint2Df(x1, y1));
		triaList.addElement(new GPoint2Df(x2, y2));
		triaList.addElement(new GPoint2Df(x3, y3));
		return isCorrectRotation(triaList);
	}

	/**
	 * 3角形処理の特別なポリゴン
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 * @param x3
	 * @param y3
	 * @return
	 */
	public static boolean getTriaRotation(double x1, double y1, double x2, double y2, double x3, double y3, RefList<GPoint2Df> triaList) {
		triaList.elementAt(0).setXY(x1, y1);
		triaList.elementAt(1).setXY(x2, y2);
		triaList.elementAt(2).setXY(x3, y3);
		return isCorrectRotation(triaList);
	}
}