/*
 * Created on 2004/11/13
 */
package nethome5.geom.rich;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;

import jp.kitec.lib.util.UtilObject;
import jp.kitec.lib.util.UtilString;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome5.text.ITextFormat;


/**
 * @author kawae
 * @since 2004/11/13
 */
public class KTextLine implements Serializable{
	public static final String GEOMNAME = "TEXT_LINE";

	/** テキスト要素のコレクション */
	private final Vector<KTextElement> mTextElements;

	/**
	 * コンストラクタ
	 *
	 * @author kawae
	 * @since 2004/11/14
	 */
	public KTextLine() {
		mTextElements = new Vector<KTextElement>();
	}

	/**
	 * データの保存
	 * @param savenode
	 */
	public void save(ObjectFolder savenode) {
		if (savenode == null)
			return;
		savenode.setName(GEOMNAME);
		for (int i = 0; i < mTextElements.size(); i++) {
			KTextElement te = mTextElements.elementAt(i);
			ObjectFolder node = new ObjectFolder("");
			te.save(node);
			savenode.addChild(node, true);
		}
	}
	/**
	 * データの保存
	 * @param savenode
	 */
	public static KTextLine readData(ObjectFolder of, KTextLine tl) {
		List<ObjectNode> v = of.getNamedElement(KTextElement.GEOMNAME);
		for (int i = 0; i < v.size(); i++) {
			ObjectFolder tef = (ObjectFolder)v.get(i);
			KTextElement te = new KTextElement();
			KTextElement.readData(tef, te);
			tl.addText(te);
		}
		return tl;
	}

	/**
	 * 内容が同じか確認
	 * @param tl
	 * @return
	 * @author kawae
	 * @since 2004/11/17
	 */
	public boolean isSame(KTextLine tl) {
		if (mTextElements.size() != tl.mTextElements.size())
			return false;
		for (int i = 0; i < mTextElements.size(); i++) {
			KTextElement te1 = mTextElements.elementAt(i);
			KTextElement te2 = tl.mTextElements.elementAt(i);
			if (!te1.isSameTextFormat(te2))
				return false;
			if (UtilString.isDiff(te1.getText(), te2.getText()))
				return false;
		}
		return true;
	}

	/**
	 * 全ての要素にフォーマットを設定
	 * @param f
	 * @author kawae
	 * @since 2004/11/17
	 */
	public void setFormat(ITextFormat f) {
		for (int i = 0; i < mTextElements.size(); i++) {
			KTextElement tl = mTextElements.elementAt(i);
			tl.setFormat(f);
		}
	}

	/**
	 * 要素群の取得
	 * @return
	 * @author kawae
	 * @since 2004/11/14
	 */
	public Vector<KTextElement> getElements() {
		return mTextElements;
	}

	/**
	 * コピーインスタンスの取得
	 * @return
	 * @author kawae
	 * @since 2004/11/17
	 */
	public KTextLine getCopy() {
		return (KTextLine)UtilObject.getCopy(this);
	}

	/**
	 * 全てのテキスト要素の削除
	 *
	 * @author kawae
	 * @since 2004/11/15
	 */
	public void removeAll() {
		mTextElements.removeAllElements();
	}

	/**
	 * テキストの追加
	 * @param s
	 * @param tf
	 * @author kawae
	 * @since 2004/11/17
	 */
	public void addText(String s, ITextFormat tf) {
		KTextElement te = new KTextElement();
		te.setText(s);
		te.setFormat(tf);
		mTextElements.addElement(te);
	}

	/**
	 * テキスト要素の追加
	 * @param e
	 * @author kawae
	 * @since 2004/11/15
	 */
	public void addText(KTextElement e) {
		mTextElements.addElement(e);
	}

	public double getDescent(ITextDpi dpi) {
		double d = -1;
		for (int j = 0; j < mTextElements.size(); j++) {
			KTextElement te = mTextElements.elementAt(j);
			double tmp = te.getFont().getFontMetrics(null).getDescent();
			d = tmp > d ? tmp : d;
		}
		return dpi.getDpiScaleSize(d);
	}

	/**
	 * 最大幅の取得
	 * @param hor
	 * @return
	 * @author kawae
	 * @since 2004/11/16
	 */
	public double getMaxWidth(boolean hor, ITextDpi dpi) {
		double total = 0;
		if (hor) {
			for (int j = 0; j < mTextElements.size(); j++) {
				KTextElement te = mTextElements.elementAt(j);
				total += te.getMaxWidth(hor, dpi);
			}
		} else {
			for (int j = 0; j < mTextElements.size(); j++) {
				KTextElement te = mTextElements.elementAt(j);
				double tmpw = te.getMaxWidth(hor, dpi);
				total = total < tmpw ? tmpw : total;
			}
		}
		return total;
	}

	/**
	 * 最大高さの取得
	 * @param hor
	 * @return
	 * @author kawae
	 * @since 2004/11/16
	 */
	public double getMaxHeight(boolean hor, ITextDpi dpi) {
		double height = 0;
		if (hor) {
			for (int j = 0; j < mTextElements.size(); j++) {
				KTextElement te = mTextElements.elementAt(j);
				height = Math.max(height, te.getMaxHeight(hor, dpi));
			}
		} else {
			for (int j = 0; j < mTextElements.size(); j++) {
				KTextElement te = mTextElements.elementAt(j);
				height += te.getMaxHeight(hor, dpi);
			}
		}
		return height;
	}
}
