package nethome5.geom.primitive;

import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.tree.ObjectFolder;
import nethome5.NethomeCoreResource;
import nethome5.geom.GeomName;
import nethome5.geom.LocalAxis2Df;
import nethome5.geom.util.ToolMath;
import nethome5.geom.util.ToolPolygon;

@GeomName("TEXT")
public class GText extends Geometry {

	/** 中心座標 */
	public GPoint2Df mCp;

	/** 角度 */
	public double mAngl;

	/** サイズ */
	protected double mSize;

	/** 文字列 */
	protected String mText;

	/** 最大・最小値 */
	public double mMinx, mMiny, mMaxx, mMaxy;

	/** スケールフォント名 */
	protected String mScaleFontName;

	/** 描画方向 (true:横) */
	protected boolean mDir = true;

	/** 背景の塗り潰しモード */
	protected boolean mFillBack = false;

	/** 塗りつぶし色 */
	private KColor mFillColor;

	/** 太字 */
	protected boolean mBold = false;

	/**
	 * コンストラクタ
	 */
	protected GText() {
		super();
		mCp = new GPoint2Df();
	}

	/**
	 * コンストラクタ
	 * @param p1
	 * @param scaleFontLabel
	 * @param text
	 * @param angl
	 * @param size
	 * @param bold
	 */
	public GText(GPoint2Df p1, String scaleFontLabel, String text, double angl, double size, boolean bold) {
	    this();
		mCp.setXY(p1.x, p1.y);
		mAngl = angl;
		mText = text;
		mSize = size;
		mScaleFontName = scaleFontLabel;
		mBold = bold;
		mGeomColor = KColor.BLACK;
	}

	/**
	 * 塗り潰しモードの指定
	 * @param fill
	 * @param fillColor
	 */
	public void setFillMode(boolean fill, KColor fillColor) {
		mFillBack = fill;
		mFillColor = fillColor;
	}
//
//	public RefList getControlPoints() {
//		return null;
//	}

	/**
	 *
	 */
	@Override
	public void updateMinMax(KArea area) {
		area.updateMinMax(mMinx, mMiny);
		area.updateMinMax(mMaxx, mMaxy);
	}

	@Override
	public Geometry copy() {
		return copyTo(new GText());
	}

	@Override
	protected Geometry copyTo(Geometry g) {
		if (g == null || !(g instanceof GText))
			return null;
		GText gt = (GText)g;
		super.copyTo(gt);
		gt.mCp = (GPoint2Df)mCp.copy();
		gt.mAngl = mAngl;
		gt.mText = new String(mText);
		gt.mSize = mSize;
		gt.mScaleFontName = mScaleFontName;
		gt.mBold = mBold;
		gt.setFillMode(mFillBack, mFillColor);
		gt.mDir = mDir;
		return gt;
	}

	@Override
	public double getDistanceToPoint(double x, double y) {
		if (x > mMinx && x < mMaxx && y > mMiny && y < mMaxy)
			return 0;
		double len = Double.MAX_VALUE;
		double tmp;
		tmp = ToolMath.getLengthLimitLineToPoint2D(x, y, mMinx, mMiny, mMaxx, mMiny);
		if (tmp >= 0)
			len = Math.min(tmp, len);
		tmp = ToolMath.getLengthLimitLineToPoint2D(x, y, mMaxx, mMiny, mMaxx, mMaxy);
		if (tmp >= 0)
			len = Math.min(tmp, len);
		tmp = ToolMath.getLengthLimitLineToPoint2D(x, y, mMaxx, mMaxy, mMinx, mMaxy);
		if (tmp >= 0)
			len = Math.min(tmp, len);
		tmp = ToolMath.getLengthLimitLineToPoint2D(x, y, mMinx, mMaxy, mMinx, mMiny);
		if (tmp >= 0)
			len = Math.min(tmp, len);
		return len;
	}

	@Override
	public void offset(double x, double y) {
		mMinx += x;
		mMiny += y;
		mMaxx += x;
		mMaxy += y;
		mCp.x += x;
		mCp.y += y;
	}

	@Override
	public void rotate(double xc, double yc, double angl) {
		mCp.rotate(xc, yc, angl);
		mAngl += angl;
	}

	@Override
	public boolean isInner(double minx, double miny, double maxx, double maxy) {
		if (mMinx >= minx && mMaxx <= maxx && mMiny >= miny && mMaxy <= maxy)
			return true;
		return false;
	}

	@Override
	public boolean isInner(RefList<GPoint2Df> v) {
		return ToolPolygon.isInnerPolygon(v, mMinx, mMiny) && ToolPolygon.isInnerPolygon(v, mMaxx, mMaxy);
	}



	/**
	 * 描画方向の設定
	 */
	public void setDir(boolean dir) {
		mDir = dir;
	}


	public boolean isDir() {
		return mDir;
	}


//	public static Object readData(ObjectFolder of, double version) throws Exception {
//		String text = null, scalefontname = null;
//		double x = 0, y = 0, angl = 0, textsize = 0;
//		boolean dir = false, fillback = false, bold = false;
//		ObjectNode on;
//		if ((on = of.getNode("x")) != null)
//			x = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("y")) != null)
//			y = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("string")) != null)
//			text = (String)on.getObject();
//		if ((on = of.getNode("scalefontname")) != null)
//			scalefontname = (String)on.getObject();
//		if ((on = of.getNode("angl")) != null)
//			angl = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("textsize")) != null)
//			textsize = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("dir")) != null)
//			dir = Integer.valueOf((String)on.getObject()).intValue() != 0;
//		if ((on = of.getNode("fillback")) != null)
//			fillback = Integer.valueOf((String)on.getObject()).intValue() != 0;
//		if ((on = of.getNode("bold")) != null)
//			bold = Integer.valueOf((String)on.getObject()).intValue() != 0;
//		GText gt = new GText(new GPoint2Df(x, y), scalefontname, text, angl, textsize, bold);
//		gt.mFillBack = fillback;
//		gt.mDir = dir;
//		Geometry.readData(of, gt);
//		return gt;
//	}
	/**
	 * データの保存
	 * @param savenode
	 */
	@Override
	public void save(ObjectFolder savenode) {
		if (savenode == null)
			return;
		super.save(savenode);

		savenode.addNode("x", mCp.x);
		savenode.addNode("y", mCp.y);
		savenode.addNode("scalefontname", mScaleFontName);
		savenode.addNode("string", mText);
		savenode.addNode("angl", mAngl);
		savenode.addNode("textsize", mSize);
		savenode.addNode("dir", mDir);
		savenode.addNode("fillback", mFillBack);
		savenode.addNode("bold", mBold);
	}

//	/**
//	 * @deprecated save(ObjectFolder)を使用すること。
//	 */
//	public void saveGeom(AbstFile w, String space) throws Exception {
//		XMLWriter.createElementOpen("TEXT");
//		super.saveGeom();
//		XMLWriter.addAttr("x", mCp.x);
//		XMLWriter.addAttr("y", mCp.y);
//		XMLWriter.addAttr("scalefontname", mScaleFontName);
//		XMLWriter.addAttr("string", mText);
//		XMLWriter.addAttr("angl", mAngl);
//		XMLWriter.addAttr("textsize", mSize);
//		XMLWriter.addAttr("dir", mDir);
//		XMLWriter.addAttr("fillback", mFillBack);
//		XMLWriter.addAttr("bold", mBold);
//		XMLWriter.close(w, true, space);
//	}

	@Override
	public void drawHighLight(IRichGraphics d, KColor c, boolean outline) {
		GPoint2Df.drawHighLight(d, c, mMinx, mMiny);
		GPoint2Df.drawHighLight(d, c, mMaxx, mMiny);
		GPoint2Df.drawHighLight(d, c, mMaxx, mMaxy);
		GPoint2Df.drawHighLight(d, c, mMinx, mMaxy);
	}

	@Override
	public void drawGeom(IRichGraphics d) {
		drawGeom(d, mGeomColor, mFillColor);
	}

	@Override
	public void drawGeom(IRichGraphics d, KColor fore, KColor back) {
		if (fore == null)
			fore = mGeomColor;
		if (back == null)
			back = mFillColor;
		drawAbstDevice(d, fore, back, null);
	}

	@Override
	public void drawAlias(IRichGraphics d, KColor fore, KColor back, LocalAxis2Df la) {
		if (back == null)
			back = mFillColor;
		if (fore == null)
			fore = mGeomColor;
		drawAbstDevice(d, fore, back, la);
	}

//	public void writeCadData(CadWriter cw, LocalAxis2Df la) {
//		drawAbstDevice(null, geomColor, _fillColor, la);
//	}

	@Override
	public void drawAbstDevice(IRichGraphics d, KColor fore, KColor back, LocalAxis2Df la) {
		update();
		if (mFillBack) {
			d.setColor(back);
			d.drawFillRect(mMinx, mMiny, mMaxx, mMaxy, null);
		}

		KFont scaleFont = NethomeCoreResource.getScaleFont(mScaleFontName);
		double scale = mSize / NethomeCoreResource.SCALEFONTSIZE;

		double[] _tmpf = new double[2];

		if (mDir) {
			//文字列中心点
			double cx = mCp.x;
			double cy = mCp.y;
			//文字列角度
			double angl = mAngl;
			double textw = scaleFont.stringWidth(mText) * scale;
			double size = mSize;
			double x, y;
			//ローカル座標が存在する場合
			if (la != null) {
				angl += la.mRot * 180 / Math.PI;
				double tx = la.getGlobalX(cx, cy, mKeepAspect, scaleEnX, scaleEnY, scaleBaseX, scaleBaseY);
				double ty = la.getGlobalY(cx, cy, mKeepAspect, scaleEnX, scaleEnY, scaleBaseX, scaleBaseY);
				cx = tx;
				cy = ty;
//				textw = textw * la.getScaleX();
				size = mSize * la.getScaleX();
				if (la.getFlipY())
					angl += 180f;
				ToolMath.rotation2D(0, 0, angl * ToolMath.D2R, - textw / 2, - ((scaleFont.getAscent() - scaleFont.getDescent()) * scale) / 2 * 1, _tmpf);
				x = cx + _tmpf[0] * la.getScaleX();
				y = cy + _tmpf[1] * la.getScaleX();
			} else {
				ToolMath.rotation2D(0, 0, angl * ToolMath.D2R, - textw / 2, - ((scaleFont.getAscent() - scaleFont.getDescent()) * scale) / 2 * 1, _tmpf);
				x = cx + _tmpf[0];
				y = cy + _tmpf[1];

			}
			//描画
//			if (device instanceof Graphics) {
//				ToolMath.rotation2D(0, 0, angl * ToolMath.D2R, - textw / 2, - ((scaleFontFm.getAscent() - scaleFontFm.getDescent()) * scale) / 2 * 1, _tmpf);
//				double x = cx + _tmpf[0];
//				double y = cy + _tmpf[1];
				d.setColor(fore);
				d.drawText(mText, x, y, scaleFont.getName(), scaleFont.getStyle(), (float)size, angl);//, fore);
//			} else {
////				ToolMath.rotation2D(0, 0, angl * ToolMath.D2R, - textw / 2 + (scaleFontFm.getHeight() * scale / 4 * (NethomeLookAndFeel.TEXT_BOLD_OFFSET)), - ((scaleFontFm.getHeight()) * scale) / 2 * 1, _tmpf);
////				x = cx + _tmpf[0];
////				y = cy + _tmpf[1];
//				((CadWriter)device).writeText(mText, x, y, cx, cy, size, (double)(angl), 0, "ＭＳ ゴシック", lineType, mBold, fore);
//			}
		//縦書き
		} else {
			for (int i = 0; i < mText.length(); i++) {
				String ss = mText.substring(i, i + 1);
				double wid = (scaleFont.stringWidth(ss) * scale);
				double hei = (scaleFont.getHeight() * scale);

				double size = (scaleFont.getDescent() + scaleFont.getAscent()) * scale;
				double x1 = mCp.x - wid / 2;
				double y1 = mMaxy - size * (i + 1);
				double x2 = x1 + wid;
				double y2 = y1 + hei;
				double cx = (x1 + x2) / 2;
				double cy = (y1 + y2) / 2;
//				if (device instanceof Graphics) {
					double ofs = scaleFont.getDescent() * scale;
					d.setColor(fore);
					if (NethomeCoreResource.TATE_STRING.indexOf(ss) >= 0)
						d.drawText(ss, cx - hei / 2 + ofs, cy + wid / 2, scaleFont.getName(), scaleFont.getStyle(), (float)mSize, (mAngl - 90));//, fore);
					else {
						d.drawText(ss, cx - wid / 2, cy - hei / 2 + ofs, scaleFont.getName(), scaleFont.getStyle(), (float)mSize, mAngl);//, fore);
//						System.out.println((cx - wid / 2) + "," + (cy - hei / 2 + ofs) + "," + scaleFont.getName() + "," + mSize + "," + ss + "," + fore.getRed()+ "," + fore.getGreen()+ "," + fore.getBlue());
					}
//				} else {
//					if (NethomeResource.TATE_STRING.indexOf(ss) >= 0)
//						((CadWriter)device).writeText(ss, x1 + hei - (hei - wid) / 2, y1 - (hei - wid) / 2, mSize, (double)(mAngl * 180 / Math.PI) - 90, 0, "ＭＳ ゴシック", lineType, mBold, fore);
//					else
//						((CadWriter)device).writeText(ss, x1, y1, mSize, (double)(mAngl * 180 / Math.PI), 0, "ＭＳ ゴシック", lineType, mBold, fore);
//				}
			}
		}
	}

	public void update() {
		KFont scaleFont = NethomeCoreResource.getScaleFont(mScaleFontName);
		double scale = mSize / scaleFont.getSize();
		double size = 0;
		if (mDir) {
			size = scaleFont.getDescent() + scaleFont.getAscent();
			double width = scaleFont.stringWidth(mText);
			double w = width * scale  / 2;
			mMinx = mCp.x - w - size / 10 * scale;
			mMaxx = mCp.x + w + size / 10 * scale;
			mMiny = mCp.y - size / 2 * scale;
			mMaxy = mCp.y + size / 2 * scale;
		} else {
			double w = 0;
			for (int i = 0; i < mText.length(); i++) {
				String ss = mText.substring(i, i + 1);
				double tw = scaleFont.stringWidth(ss) / 2;
				w = Math.max(w, tw);
			}
			mMinx = mCp.x - w * scale;
			mMaxx = mCp.x + w * scale;
			size = scaleFont.getDescent() + scaleFont.getAscent();
			double h = mText.length() * size * scale / 2;
			mMiny = mCp.y - (h);
			mMaxy = mCp.y + (h);
		}
		area.maximize();
		updateMinMax(area);
	}

	/**
	 * @return String
	 */
	public String getText() {
		return mText;
	}

	public void setText(String s) {
		mText = s;
		update();
	}

	/**
	 * @return double
	 */
	public double getSize() {
		return mSize;
	}

	/**
	 * Sets the mSize.
	 * @param mSize The mSize to set
	 */
	public void setSize(double mSize) {
		this.mSize= mSize;
	}

	@Override
	public void flipx(double x, double ofsx) {
		mCp.flipx(x, ofsx);
		area.maximize();
		updateMinMax(area);
	}

	/**
	 * 縦反転
	 */
	@Override
	public void flipy(double y, double ofsy) {
		mCp.flipy(y, ofsy);
		area.maximize();
		updateMinMax(area);
	}

	@Override
	public void rot(double x, double y, double ofsx, double ofsy) {
		mCp.rot(x, y, ofsx, ofsy);
		mDir = !mDir;
		area.maximize();
		updateMinMax(area);
	}
}

