package nethome5.geom;

import java.io.Serializable;

import jp.kitec.lib.geom.KLocalAxis;
import jp.kitec.lib.util.HashUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome5.geom.util.ToolMath;

/**
 * <p>タイトル: ローカル座標</p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2002</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
 */

/**
 * ローカル座標系
 */
public class LocalAxis2Df implements KLocalAxis, Serializable {

	/** 座標系原点の絶対座標 */
	public double mX, mY;

	/** 回転角度 */
	public double mRot;

	/** XY軸の反転 */
	private boolean mFlipX = false, mFlipY = false;
	/** 横方向変形可能フラグ */
	private boolean scaleEnableX = false;
	/** 縦方向変形可能フラグ */
	private boolean scaleEnableY = false;

	/** 拡大率 */
	private double mScaleX = 1.0f;
	private double mScaleY = 1.0f;

	/**
	 * コンストラクタ
	 */
	public LocalAxis2Df() {
		mX = 0;
		mY = 0;
		mRot = 0;
		mFlipX = mFlipY = false;
	}

	/**
	 * 横方向のサイズの取得
	 * @return
	 */
	public double getScaleX() {
		return mScaleX;
	}

	/**
	 * 縦方向のサイズの取得
	 * @return
	 */
	public double getScaleY() {
		return mScaleY;
	}

	public void setScaleX(double x, boolean aspect) {
		if (!scaleEnableX && !scaleEnableY) {
			mScaleX = mScaleY = 1f;
			return;
		} else if (!scaleEnableX) {
			mScaleX = 1f;
			return;
		}
		mScaleX = x;
		if (aspect)
			mScaleY = x;
	}

	public void setScaleY(double y, boolean aspect) {
		if (!scaleEnableX && !scaleEnableY) {
			mScaleX = mScaleY = 1f;
			return;
		} else if (!scaleEnableY) {
			mScaleY = 1f;
			return;
		}
		mScaleY = y;
		if (aspect)
			mScaleX = y;
	}

	public void setScale(double x, double y) {
		if (!scaleEnableX && !scaleEnableY) {
			mScaleX = mScaleY = 1f;
			return;
		}
		mScaleX = x;
		mScaleY = y;
	}

	public void setScaleEnable(boolean x, boolean y) {
		scaleEnableX = x;
		scaleEnableY = y;
	}

	public boolean isScaleEnableX() {
		return scaleEnableX;
	}
	public boolean isScaleEnableY() {
		return scaleEnableY;
	}

	/**
	 * コンストラクタ
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 */
	public LocalAxis2Df(double x1, double y1, double x2, double y2) {
		mFlipX = mFlipY = false;
		scaleEnableX = scaleEnableY = false;
		setLocalCoordinates(x1, y1, x2, y2, mFlipX, mFlipY);
	}

	/**
	 * コンストラクタ
	 * @param lc
	 */
	public LocalAxis2Df(LocalAxis2Df lc) {
		setLocalCoordinates(lc.mX, lc.mY, lc.mRot, lc.mFlipX, lc.mFlipY);
		setScale(lc.mScaleX, lc.mScaleY);
		setScaleEnable(lc.scaleEnableX, lc.scaleEnableY);
	}

//	public static LocalAxis2Df readData(ObjectFolder of, double version) throws Exception {
//		double cx = 0, cy = 0, angl = 0, scalex = 1, scaley = 1;
//		boolean fx = false, fy = false;
//		ObjectNode on = null;
//		if ((on = of.getNode("cx")) != null)
//			cx = Float.valueOf((String)on.getObject()).intValue();
//		if ((on = of.getNode("cy")) != null)
//			cy = Float.valueOf((String)on.getObject()).intValue();
//		if ((on = of.getNode("angl")) != null)
//			angl = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("fx")) != null)
//			fx = Integer.valueOf((String)on.getObject()).intValue() != 0;
//		if ((on = of.getNode("fy")) != null)
//			fy = Integer.valueOf((String)on.getObject()).intValue() != 0;
//		if ((on = of.getNode("scalex")) != null)
//			scalex = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("scaley")) != null)
//			scaley = Float.valueOf((String)on.getObject()).doubleValue();
//
////		String tmp = r.readLineFromBuffer();
////		StringTokenizer st = new StringTokenizer(tmp, " ,");
////		double x = Float.valueOf((String)st.nextElement()).doubleValue();
////		double y = Float.valueOf((String)st.nextElement()).doubleValue();
////		double rot = Float.valueOf((String)st.nextElement()).doubleValue();
////		tmp = (String)st.nextElement();
////		boolean fx = Boolean.valueOf(tmp).booleanValue();
////		tmp = (String)st.nextElement();
////		boolean fy = Boolean.valueOf(tmp).booleanValue();
////		while (true) {
////			String str = r.readLineFromBuffer();
////			if (str == null || str.trim().equalsIgnoreCase("</AXIS>"))
////				break;
////		}
//		LocalAxis2Df la = new LocalAxis2Df();
////		la.setLocalCoordinates(cx, cy, angl, fx, fy);
//		la.mX = cx;
//		la.mY = cy;
//		la.mRot = angl;
//		la.mFlipX = fx;
//		la.mFlipY = fy;
//		la.mScaleX = scalex;
//		la.mScaleY = scaley;
////		la.setScale(scalex, scaley);
//		return la;
//	}

	/**
	 * 読み込み(2005/06/09追加)
	 * @param of
	 * @param version
	 * @return
	 * @throws Exception
	 * @author kawae
	 * @since 2005/06/09
	 */
	public static LocalAxis2Df readData(ObjectFolder of) throws Exception {
		double cx = 0, cy = 0, angl = 0, scalex = 1, scaley = 1;
		boolean fx = false, fy = false;
		ObjectNode on = null;
		if ((on = of.getNode("cx")) != null)
			cx = on.getDouble();
		if ((on = of.getNode("cy")) != null)
			cy = on.getDouble();
		if ((on = of.getNode("angl")) != null)
			angl = on.getDouble();
		if ((on = of.getNode("fx")) != null)
			fx = Boolean.parseBoolean(on.getString());
		if ((on = of.getNode("fy")) != null)
			fy = Boolean.parseBoolean(on.getString());
		if ((on = of.getNode("scalex")) != null)
			scalex = on.getDouble();
		if ((on = of.getNode("scaley")) != null)
			scaley = on.getDouble();

//		String tmp = r.readLineFromBuffer();
//		StringTokenizer st = new StringTokenizer(tmp, " ,");
//		double x = Float.valueOf((String)st.nextElement()).doubleValue();
//		double y = Float.valueOf((String)st.nextElement()).doubleValue();
//		double rot = Float.valueOf((String)st.nextElement()).doubleValue();
//		tmp = (String)st.nextElement();
//		boolean fx = Boolean.valueOf(tmp).booleanValue();
//		tmp = (String)st.nextElement();
//		boolean fy = Boolean.valueOf(tmp).booleanValue();
//		while (true) {
//			String str = r.readLineFromBuffer();
//			if (str == null || str.trim().equalsIgnoreCase("</AXIS>"))
//				break;
//		}
		LocalAxis2Df la = new LocalAxis2Df();
//		la.setLocalCoordinates(cx, cy, angl, fx, fy);
		la.mX = cx;
		la.mY = cy;
		la.mRot = angl;
		la.mFlipX = fx;
		la.mFlipY = fy;
		la.mScaleX = scalex;
		la.mScaleY = scaley;
//		la.setScale(scalex, scaley);
		return la;
	}
	/**
	 * データの保存
	 * @param parent
	 */
	public void save(ObjectFolder parent) {
		if (parent == null)
			return;
		parent.setName("AXIS");
		parent.addNode("cx", mX);
		parent.addNode("cy", mY);
		parent.addNode("angl", mRot);
		parent.addNode("fx", Boolean.toString(mFlipX));
		parent.addNode("fy", Boolean.toString(mFlipY));
		parent.addNode("scalex", mScaleX);
		parent.addNode("scaley", mScaleY);
	}

//	public void saveGeom(AbstFile w, String space) throws Exception {
//		XMLWriter.createElementOpen("AXIS");
//		XMLWriter.addAttr("cx",  mX);
//		XMLWriter.addAttr("cy",  mY);
//		XMLWriter.addAttr("angl",  mRot);
//		XMLWriter.addAttr("fx",  mFlipX);
//		XMLWriter.addAttr("fy",  mFlipY);
//		XMLWriter.addAttr("scalex", mScaleX);
//		XMLWriter.addAttr("scaley", mScaleY);
//		XMLWriter.close(w, true, space);
//
////
////		w.writeStringToBuffer(space + "<AXIS>\r\n");
////		w.writeStringToBuffer(space + " " + mX + "," + mY + "," + mRot + "," + mFlipX + "," + mFlipY + "\r\n");
////		w.writeStringToBuffer(space + "</AXIS>\r\n");
//	}

	public void setLocalCoordinates(double x1, double y1, double x2, double y2, boolean fx, boolean fy) {
		setLocalCoordinates(x1, y1, ToolMath.getAngle2D(x1, y1, x2, y2), fx, fy);
	}

	public void setLocalCoordinates(double x, double y, double rot, boolean fx, boolean fy) {
		mX = x;
		mY = y;
		mRot = rot;
		mFlipX = fx;
		mFlipY = fy;
	}

	public void setLocalCoordinates(LocalAxis2Df lc) {
		mX = lc.mX;
		mY = lc.mY;
		mRot = lc.mRot;
		mFlipX = lc.mFlipX;
		mFlipY = lc.mFlipY;
		mScaleX = lc.mScaleX;
		mScaleY = lc.mScaleY;
		scaleEnableX = lc.scaleEnableX;
		scaleEnableY = lc.scaleEnableY;
	}

	public boolean getFlipX() {
		return mFlipX;
	}

	public void setFlipX(boolean f) {
		mFlipX = f;
	}

	public boolean getFlipY() {
		return mFlipY;
	}

	public void setFlipY(boolean f) {
		mFlipY = f;
	}

	/**
	 * ローカル座標->Xグローバル座標
	 */
	@Override
	public double getGlobalX(double x, double y) {
		if (mFlipX)
			x = -x;
		if (mFlipY)
			y = -y;
		double val = x  * Math.cos(mRot) - y * Math.sin(mRot) + mX;
		return val;
	}
	/**
	 * ローカル座標->Yグローバル座標
	 */
	@Override
	public double getGlobalY(double x, double y) {
		if (mFlipX)
			x = -x;
		if (mFlipY)
			y = -y;
		double val = x * Math.sin(mRot) + y * Math.cos(mRot) + mY;
		return val;
	}


	public double getScaledX(double x, double y, boolean keepaspect, boolean sx, boolean sy, double bx, double by) {
		double scalex;
		if (keepaspect) {
			if (!scaleEnableX && !scaleEnableY)
				scalex = 1f;
			else if (scaleEnableX && scaleEnableY)
				scalex = Math.max(mScaleX, mScaleY);
			else if (scaleEnableX)
				scalex = mScaleX;
			else
				scalex = mScaleY;
		} else {
			scalex = sx?mScaleX:1f;
//			scaley = sy?mScaleY:1f;
		}
		double xx = (x - bx) * scalex;
		double val = (xx + bx);
		return val;
	}

	public double getScaledY(double x, double y, boolean keepaspect, boolean sx, boolean sy, double bx, double by) {
		double scaley;
		if (keepaspect) {
			if (!scaleEnableX && !scaleEnableY)
				scaley = 1f;
			else if (scaleEnableX && scaleEnableY)
				scaley = Math.max(mScaleX, mScaleY);
			else if (scaleEnableX)
				scaley = mScaleX;
			else
				scaley = mScaleY;
		} else {
//			scalex = sx?mScaleX:1f;
			scaley = sy?mScaleY:1f;
		}

		double yy = (y - by) * scaley;
		double val = (yy + by);
		return val;
	}

	/**
	 * ローカル座標->Xグローバル座標(拡大縮小フラグ有り)
	 */
	public double getGlobalX(double x, double y, boolean keepaspect, boolean sx, boolean sy, double bx, double by) {
		double scalex, scaley;
		if (keepaspect) {
			if (!scaleEnableX && !scaleEnableY)
				scalex = scaley = 1f;
			else if (scaleEnableX && scaleEnableY)
				scalex = scaley = Math.max(mScaleX, mScaleY);
			else if (scaleEnableX)
				scalex = scaley = mScaleX;
			else
				scalex = scaley = mScaleY;
		} else {
			scalex = sx?mScaleX:1f;
			scaley = sy?mScaleY:1f;
		}
		double xx = (x - bx) * scalex;
		double yy = (y - by) * scaley;
		if (mFlipX) {
			xx = -xx;
			bx = -bx;
		}
		if (mFlipY) {
			yy = -yy;
			by = -by;
		}
		double val = (xx + bx) * Math.cos(mRot) - (yy + by) * Math.sin(mRot) + mX;
		return val;
	}

	/**
	 * ローカル座標->Yグローバル座標(拡大縮小フラグ有り)
	 */
	public double getGlobalY(double x, double y, boolean keepaspect, boolean sx, boolean sy, double bx, double by) {
		double scalex, scaley;
		if (keepaspect) {
			if (!scaleEnableX && !scaleEnableY)
				scalex = scaley = 1f;
			else if (scaleEnableX && scaleEnableY)
				scalex = scaley = Math.max(mScaleX, mScaleY);
			else if (scaleEnableX)
				scalex = scaley = mScaleX;
			else
				scalex = scaley = mScaleY;
		} else {
			scalex = sx?mScaleX:1f;
			scaley = sy?mScaleY:1f;
		}
		double xx = (x - bx) * scalex;
		double yy = (y - by) * scaley;
		if (mFlipX) {
			xx = -xx;
			bx = -bx;
		}
		if (mFlipY) {
			yy = -yy;
			by = -by;
		}
		double val = (xx + bx) * Math.sin(mRot) + (yy + by) * Math.cos(mRot) + mY;
		return val;
	}

	public double getGlobalLength(double len) {
		return len * mScaleX;
	}

	/**
	 * グローバル座標->Xローカル座標
	 */
	@Override
	public double getLocalX(double x, double y) {
		double val = (x - mX) * Math.cos(-mRot) - (y - mY) * Math.sin(-mRot);
		if (mFlipX)
			val = -val;
		return val;
	}

	/**
	 * グローバル座標->Xローカル座標
	 */
	@Override
	public double getLocalY(double x, double y) {
		double val = (x - mX) * Math.sin(-mRot) + (y - mY) * Math.cos(-mRot);
		if (mFlipY)
			val = -val;
		return val;
	}

	@Override
	public double getGlobalAngl(double rad) {
		rad += mRot;
		if (mFlipX)
			rad = Math.PI - rad;
		if (mFlipY)
			rad = -rad;
		return ToolMath.getAngl2PI(rad);

	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (mFlipX ? 1231 : 1237);
		result = prime * result + (mFlipY ? 1231 : 1237);
		result = prime * result + HashUtil.hashCode(mRot);
		result = prime * result + HashUtil.hashCode(mScaleX);
		result = prime * result + HashUtil.hashCode(mScaleY);
		result = prime * result + HashUtil.hashCode(mX);
		result = prime * result + HashUtil.hashCode(mY);
		result = prime * result + (scaleEnableX ? 1231 : 1237);
		result = prime * result + (scaleEnableY ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		LocalAxis2Df other = (LocalAxis2Df) obj;
		if (mFlipX != other.mFlipX)
			return false;
		if (mFlipY != other.mFlipY)
			return false;
		if (Double.compare(mRot, other.mRot) != 0)
			return false;
		if (Double.compare(mScaleX, other.mScaleX) != 0)
			return false;
		if (Double.compare(mScaleY, other.mScaleY) != 0)
			return false;
		if (Double.compare(mX, other.mX) != 0)
			return false;
		if (Double.compare(mY, other.mY) != 0)
			return false;
		if (scaleEnableX != other.scaleEnableX)
			return false;
		if (scaleEnableY != other.scaleEnableY)
			return false;
		return true;
	}
}
