package nethome5.doc;

public interface ProjectHistoryManager<T extends Project> {

	/**
	 * プロジェクトを設定
	 * @param project
	 */
	public void setProject(T project);

	/**
	 * ヒストリのクリア
	 * @param o
	 */
	public void flushHistory();

	/**
	 * ヒストリに設定
	 * @param o
	 */
	public void setHistoryObject(Object o);

	/**
	 * カレントフロアの最後のヒストリの取得
	 * @return
	 */
	public Object getLastHistory();

	/**
	 * カレントフロアの現在のヒストリの取得
	 * @return
	 */
	public Object getCurrentHistory();

	/**
	 * アンドゥ
	 */
	public boolean undo();

	/**
	 * リドゥ
	 */
	public boolean redo();

	/**
	 * ヒストリに追加
	 *
	 * @author kawae
	 * @since 2004/09/22
	 */
	public void addHistory();

	/**
	 * UNDOヒストリを持つか確認
	 *
	 * @return
	 * @author kawae
	 * @since 2004/11/23
	 */
	public boolean hasUndo();

	/**
	 * REDOヒストリを持つか確認
	 * @return
	 * @author kawae
	 * @since 2004/11/23
	 */
	public boolean hasRedo();

	/**
	 * 指定された数の履歴を保存する新たな履歴を構築する。
	 * @param num
	 */
	public void setMaxHistory(int num);

}
