package nethome5.doc;

import java.util.logging.Logger;

import jp.kitec.lib.util.HistoryDataConverter;
import jp.kitec.lib.util.tree.ObjectFolder;

public class ObjectFolderHistoryDataConverter<T extends Project> implements HistoryDataConverter<T, ObjectFolder> {

	private static final Logger log = Logger.getLogger("nethome.doc.ObjectFolderHistory");

	protected ProjectProvider<T> mProvider;
	protected DocumentFactory mFactory;

	public ObjectFolderHistoryDataConverter(ProjectProvider<T> provider, DocumentFactory factory) {
		mProvider = provider;
		mFactory = factory;
	}

	@Override
	public T readHistory(ObjectFolder h) {
		try {
			T prj = mProvider.getProject();
			prj.load(h, mFactory);
			return prj;
		} catch (RuntimeException e) {
			log.severe("load error " + e);
			return null;
		}
	}

	@Override
	public ObjectFolder writeHistory(T prj) {
		ObjectFolder of = new ObjectFolder("hist");
		of.addChild(prj.save());
		return of;
	}

	static interface ProjectProvider<T extends Project> {
		T getProject();
	}
}