/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 * @author matsuzaki
 */
/**
 *
 */
package nethome5.doc;

import nethome5.geom.GeomParser;

/**
 * @author matsuzaki
 *
 */
abstract public interface DocumentFactory {
	/**
	 * 新規レイヤーマネージャの作成
	 * レイヤーマネージャは必ずここ経由で行う
	 * @param layername　レイヤマネージャの名前
	 * @return
	 * @author kawae
	 * @since 2004/09/30
	 */
	public Layer createLayer(Project prj, String layername);

	/**
	 * 新規プロジェクトフレームの作成
	 * @return
	 */
	public Project createNewProject();

	/**
	 * Geometryの読み込みパーサーの取得
	 * @return
	 * @author kawae
	 * @since 2004/11/02
	 */
	public GeomParser getGeomParser();
}
