package nethome5.doc;

import java.util.EventObject;

/**
 * DocumentEventは、イベントソースでドキュメントが変更されたことを通知するために使用されます。
 * @author matsuzaki
 *
 */
public class DocumentEvent extends EventObject {

	private static final long serialVersionUID = 1L;

	private Document mDocument;

	public DocumentEvent(Object source, Document document) {
		super(source);
		mDocument = document;
	}

	/**
	 * 変更されたドキュメントを返します。
	 * @return
	 */
	public Document getDocument() {
		return mDocument;
	}
}
