/*
 * Created on 2003/08/12
 */
package nethome5;

import jp.kitec.lib.util.UtilString;

/**
 * ユーザ情報クラス
 * @author kawae
 */
public class UserInfo {

	/////////////////////////////////////////////////////////////////////////
	// 定数

	/** 匿名ユーザ用 */
	public static final String ANONYMOUS_USER_NAME = "anonymous";
	public static final String ANONYMOUS_PASSWORD  = "anonymous";


	/** ユーザ名 */
	private String mUserName;

	/** パスワード */
	private String mPassword;

	public UserInfo() {
		this(ANONYMOUS_USER_NAME, ANONYMOUS_PASSWORD);
	}

	public UserInfo(String userName, String password) {
		setUserName(userName);
		setPassword(password);
	}

	public void setUserName(String userName) {
		mUserName = userName;
	}

	public void setPassword(String password) {
		mPassword = password;
	}

	public String getUserName() {
		return mUserName;
	}

	public String getPassword() {
		return mPassword;
	}

//	public String getDigestedUserName() {
//		return UtilString.getMd5(mUserName);
//	}

	public String getDigestedPassword() {
		return UtilString.getMd5(mPassword);
	}

	public static UserInfo getDefaultUserInfo() {
		return new UserInfo();
	}
}