package nethome.geom.util;

import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.util.Item;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.Vector2;
import nethome.geom.HatchPattern;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GLine;
import nethome.geom.primitive.GPoint2Df;

/**
 * <p>タイトル: 八ッチング</p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2002</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
 */
public class ToolHatch {

	/**
	 * 八ッチングの作成
	 *
	 * @param	hp	    ハッチパターン
	 * @param   polygon ハッチング領域の点リスト
	 *
	 * @return  ハッチングされた線群
	 */
	public static Vector2<GLine> createHatch(HatchPattern hp, RefList<? extends GPoint2Df> polygon, double module, double hatchangl, double polygonangl, boolean mirx, boolean miry) {
		Vector2<GLine> lines= new Vector2<GLine>();
		createHatch(hp, polygon, lines, module, hatchangl, polygonangl, mirx, miry);
		return lines;
	}

	/**
	 * 八ッチングの作成
	 *
	 * @param	hp	    ハッチパターン
	 * @param   polygon ハッチング領域の点リスト
	 * @param   lines   ハッチングされた線群リスト
	 */
	public static void createHatch(HatchPattern hp, RefList<? extends GPoint2Df> polygon, Vector2<GLine> lines, double module, double hatchangl, double polygonangl, boolean mirx, boolean miry) {
		if (hp == null)
			return;
		if (hp.mOffsetToInside != 0) {
			RefList<GPoint2Df> tmp= new RefList<GPoint2Df>();
			for (int i= 0; i < polygon.size(); i++) {
				GPoint2Df p1= polygon.elementAt(i);
				GPoint2Df p2= polygon.elementAt(i + 1);
				GPoint2Df p3= polygon.elementAt(i + 2);
				double[] tmpf= new double[2];
				ToolMath.get2LineOffsetCross(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, hp.mOffsetToInside, hp.mOffsetToInside, tmpf);
				tmp.addElement(new GPoint2Df(tmpf[0], tmpf[1]));
			}
			polygon= tmp;
		}
		else {
			RefList<GPoint2Df> tmp= new RefList<GPoint2Df>();
			for (int i= 0; i < polygon.size(); i++) {
				GPoint2Df p1= polygon.elementAt(i);
				tmp.addElement(new GPoint2Df(p1.x, p1.y));
			}
			polygon= tmp;
		}

		double xmin= ToolPolygon.getMinX(polygon);
		double xmax= ToolPolygon.getMaxX(polygon);
		double ymin= ToolPolygon.getMinY(polygon);
		double ymax= ToolPolygon.getMaxY(polygon);

		if (polygonangl != 0) {
			LocalAxis2Df la= new LocalAxis2Df();
			la.mRot= polygonangl;
			double tminx= Double.POSITIVE_INFINITY, tminy= Double.POSITIVE_INFINITY, tmaxx= Double.NEGATIVE_INFINITY, tmaxy= Double.NEGATIVE_INFINITY;
			double tx, ty;
			for (int i= 0; i < polygon.size(); i++) {
				GPoint2Df p1= polygon.elementAt(i);
				tx= la.getLocalX(p1.x, p1.y);
				ty= la.getLocalX(p1.x, p1.y);
				if (tx < tminx) {
					xmin= p1.x;
					tminx= tx;
				}
				if (ty < tminy) {
					ymin= p1.y;
					tminy= ty;
				}
				if (tx > tmaxx) {
					xmax= p1.x;
					tmaxx= tx;
				}
				if (ty > tmaxy) {
					ymax= p1.y;
					tmaxy= ty;
				}
			}
		}

		//無限ハッチライン作成
		//		createHatchingInfinityX(xmin, xmax, ymin, ymax, hp, polygon, lines);
		//		createHatchingInfinityY(xmin, xmax, ymin, ymax, hp, polygon, lines);

		switch (hp.mFitPattern) {
			case HatchPattern.MINMAXFIT : //最大・最小にフィット
				createHatchingMinmaxFit(xmin, xmax, ymin, ymax, hp, polygon, lines);
				break;
			case HatchPattern.INTERVALFIT : //周期フィット
				createHatchingInterval(xmin, xmax, ymin, ymax, hp, polygon, lines, module, hatchangl, polygonangl, mirx, miry);
				break;
			case HatchPattern.SUBTYPESIZE : //サブタイプから選択（主に和室）
				createHatchingFromSubtype(xmin, xmax, ymin, ymax, hp, polygon, lines, module, hatchangl, polygonangl, mirx, miry);
				break;
		}

		if (hp.mFrameLine) {
			for (int i= 0; i < polygon.size(); i++)
				lines.addElement(new GLine(polygon.elementAt(i), polygon.elementAt(i + 1), hp.mLtype));
		}
	}

	private static void createHatchingInterval(double xmin, double xmax, double ymin, double ymax, HatchPattern hp, RefList<? extends GPoint2Df> polygon, Vector2<GLine> lines, double m, double hatchangl, double polygonangl, boolean mirx, boolean miry) {
		LocalAxis2Df la= new LocalAxis2Df();
		la.mX= xmin;
		la.mY= ymin;
		la.mRot= hatchangl;
		KArea aaa= new KArea();
		aaa.maximize();
		aaa.updateMinMax(la.getLocalX(xmin, ymin), la.getLocalY(xmin, ymin));
		aaa.updateMinMax(la.getLocalX(xmax, ymin), la.getLocalY(xmax, ymin));
		aaa.updateMinMax(la.getLocalX(xmax, ymax), la.getLocalY(xmax, ymax));
		aaa.updateMinMax(la.getLocalX(xmin, ymax), la.getLocalY(xmin, ymax));
		for (int i = 0; i < hp.mInfinityX.size(); i++) {
			double f = (hp.mInfinityX.elementAt(i)).doubleValue();
			for (double yy= aaa.minY; yy < aaa.maxY; yy += f * m) {
				double xx1= Math.round(la.getGlobalX(aaa.minX, yy) * 100) / 100;
				double yy1= Math.round(la.getGlobalY(aaa.minX, yy) * 100) / 100;
				double xx2= Math.round(la.getGlobalX(aaa.maxX, yy) * 100) / 100;
				double yy2= Math.round(la.getGlobalY(aaa.maxX, yy) * 100) / 100;
				RefList<GPoint2Df> tmp= ToolPolygon.getHatchingLine(polygon, xx1, yy1, xx2, yy2);
				tmp= sort(xx1, yy1, tmp);
				addDrawLines(tmp, polygon, lines, hp);
			}
		}
		for (int i = 0; i < hp.mInfinityY.size(); i++) {
			double f = (hp.mInfinityY.elementAt(i)).doubleValue();
			for (double xx= aaa.minX; xx < aaa.maxX; xx += f * m) {
				double xx1= Math.round(la.getGlobalX(xx, aaa.minY) * 100) / 100;
				double yy1= Math.round(la.getGlobalY(xx, aaa.minY) * 100) / 100;
				double xx2= Math.round(la.getGlobalX(xx, aaa.maxY) * 100) / 100;
				double yy2= Math.round(la.getGlobalY(xx, aaa.maxY) * 100) / 100;
				RefList<GPoint2Df> tmp= ToolPolygon.getHatchingLine(polygon, xx1, yy1, xx2, yy2);
				tmp= sort(xx1, yy1, tmp);
				addDrawLines(tmp, polygon, lines, hp);
			}
		}
		if (true) {
			for (int j= 0; j < polygon.size(); j++) {
				GPoint2Df p1= polygon.elementAt(j);
				GPoint2Df p2= polygon.elementAt(j + 1);
				lines.addElement(new GLine(p1, p2));
			}
		}
	}

	private static void createHatchingFromSubtype(double xmin, double xmax, double ymin, double ymax, HatchPattern hp, RefList<? extends GPoint2Df> polygon, Vector2<GLine> lines, double m, double hatchangl, double polygonangl, boolean mirx, boolean miry) {
		double w= xmax - xmin;
		double h= ymax - ymin;

		//オリジナルの状態での幅
		int iw, ih;
		//パターン検索用横長のサイズ
		double ww, hh;

		iw= Math.abs((int) ((w - (w % m)) / m));
		ih= Math.abs((int) ((h - (h % m)) / m));
		if (Math.abs(m - w % m) < m / 1000)
			iw++;
		if (Math.abs(m - h % m) < m / 1000)
			ih++;

		double[] type= null;
		boolean flip= false;
		if (iw < ih) {
			flip= true;
			type= hp.getSubtype2(ih, iw);
		}
		else {
			type= hp.getSubtype2(iw, ih);
		}

		if (type == null)
			return;

		if (flip) {
			ww= type[1];
			hh= type[0];
		}
		else {
			ww= type[0];
			hh= type[1];
		}

		boolean err= false;
		double[] tmpf= new double[2];
		ToolMath.rotation2D(0, 0, hatchangl, ww, hh, tmpf);
		double tmpx= Math.abs(tmpf[0]);
		double tmpy= Math.abs(tmpf[1]);
		if (flip) {
			double tt= tmpx;
			tmpx= tmpy;
			tmpy= tt;
		}
		if (Math.abs(tmpx - iw) > .1f || Math.abs(tmpy - ih) > .1f) {
			err= true;
			hatchangl= 0;
		}

		for (int i= 0; i < hp.mLines.size(); i++) {
			GLine sl= hp.mLines.elementAt(i);
			double x1, y1, x2, y2;
			x1= sl.pA.x - type[2];
			y1= sl.pA.y - type[3];
			x2= sl.pB.x - type[2];
			y2= sl.pB.y - type[3];
			if (err && flip) {
				tmpx= x1;
				tmpy= y1;
				x1= -tmpy;
				y1= tmpx;

				tmpx= x2;
				tmpy= y2;
				x2= -tmpy;
				y2= tmpx;
			}

			ToolMath.rotation2D(0, 0, hatchangl, x1 * m, y1 * m, tmpf);
			x1= (tmpf[0] + xmin + ww / 2 * m);
			y1= (tmpf[1] + ymin + hh / 2 * m);
			ToolMath.rotation2D(0, 0, hatchangl, x2 * m, y2 * m, tmpf);
			x2= (tmpf[0] + xmin + ww / 2 * m);
			y2= (tmpf[1] + ymin + hh / 2 * m);

			x1= Math.round(x1 * 100) / 100;
			y1= Math.round(y1 * 100) / 100;
			x2= Math.round(x2 * 100) / 100;
			y2= Math.round(y2 * 100) / 100;
			//ｘ、ｙ反転
			if (mirx) {
				double bx= xmin + ww / 2 * m;
				x1= bx + (bx - x1);
				x2= bx + (bx - x2);
			}
			if (miry) {
				double by= ymin + m * hh / 2;
				y1= by + (by - y1);
				y2= by + (by - y2);
			}

			RefList<GPoint2Df> tmp= ToolPolygon.getHatchingLine(polygon, x1, y1, x2, y2);
			tmp= sort(sl.pA.x, sl.pA.y, tmp);
			addDrawLines(tmp, polygon, lines, hp);
		}
		if (true) {
			for (int j= 0; j < polygon.size(); j++) {
				GPoint2Df p1= polygon.elementAt(j);
				GPoint2Df p2= polygon.elementAt(j + 1);
				lines.addElement(new GLine(p1, p2));
			}
		}
	}

	/**
	 * ハッチング作成(対象の形状の最大・最小にフィット）
	 */
	private static void createHatchingMinmaxFit(double xmin, double xmax, double ymin, double ymax, HatchPattern hp, RefList<? extends GPoint2Df> polygon, Vector2<GLine> lines) {
		if (hp == null)
			return;

		double scalex= Math.abs((xmax - xmin)) / Math.abs(hp.mMaxX - hp.mMinX);
		double scaley= Math.abs((ymax - ymin)) / Math.abs(hp.mMaxY - hp.mMinY);

		for (int i= 0; i < hp.mLines.size(); i++) {
			GLine sl= hp.mLines.elementAt(i);
			RefList<GPoint2Df> tmp= ToolPolygon.getHatchingLine(polygon, sl.pA.x * scalex + xmin, sl.pA.y * scaley + ymin, sl.pB.x * scalex + xmin, sl.pB.y * scaley + ymin);
			tmp= sort(sl.pA.x * scalex + xmin, sl.pA.y * scaley + ymin, tmp);
			addDrawLines(tmp, polygon, lines, hp);
		}
	}

	/**
	 * ハッチング作成(大きさを保持したまま周期的にフィット）
	 */
	/*	private static void createHatchingSizeDependt(double xmin, double xmax, double ymin, double ymax, HatchPattern hp, RefList polygon, RefList lines) {
			if (hp == null)
				return;


			for (double cycx = xmin; cycx < xmax; cycx += hp.mMaxX * hp.getBaseModule()) {
				for (double cycy = ymin; cycy < ymax; cycy += hp.mMaxY * hp.getBaseModule()) {
					for (int i = 0; i < hp.mLines.size(); i++) {
						GLine sl = (GLine)hp.mLines.elementAt(i);
						RefList tmp = ToolPolygon.getHatchingLine(polygon, cycx + sl.mPa.x * hp.getBaseModule(),
															 cycy + sl.mPa.y * hp.getBaseModule(),
															 cycx + sl.mPb.x * hp.getBaseModule(),
															 cycy + sl.mPb.y * hp.getBaseModule());
						tmp = sort(cycx + sl.mPa.x * hp.getBaseModule(),  cycy + sl.mPa.y * hp.getBaseModule(), tmp);
						addDrawLines(tmp, polygon, lines);
					}
				}
			}
		}
	*/
	/**
	 * 描画線リストへ追加
	 */
	private static void addDrawLines(RefList<? extends GPoint2Df> tmp, RefList<? extends GPoint2Df> polygon, Vector2<GLine> lines, HatchPattern hp) {
		if (tmp == null || tmp.isEmpty())
			return;
		Item<? extends GPoint2Df> it = tmp.itemAt(0);
		for (int j= 0; j < tmp.size() - 1; j++) {
			GPoint2Df p1= it.getObject();
			GPoint2Df p2= it.nextItem.getObject();
			if (ToolPolygon.isInnerPolygon(polygon, (p1.x + p2.x) / 2, (p1.y + p2.y) / 2) && !ToolPolygon.isOnEdge(polygon, (p1.x + p2.x) / 2, (p1.y + p2.y) / 2)) {
				lines.addElement(new GLine(new GPoint2Df(p1.x, p1.y), new GPoint2Df(p2.x, p2.y), hp.mLtype));
			}
			it= it.nextItem;
		}
	}

	/**
	 * 距離でソート
	 *
	 * @param	x	距離を検査する基点ｘ
	 * @param	y	距離を検査する基点ｙ
	 * @param	l	ソートする点列
	 */
	private static <T extends GPoint2Df> RefList<T> sort(double x, double y, RefList<T> l) {
		if (l == null)
			return null;
		RefList<T> res= new RefList<T>();
		while (l.size() != 0) {
			Item<T> it= getMinLength(x, y, l);
			res.addElement(it.getObject());
		}
		return res;
	}

	/**
	 * ポイントリスト中からｙ座標が最小のものを取得
	 *
	 * @param	x	距離を検査する基点ｘ
	 * @param	y	距離を検査する基点ｙ
	 * @param	l	ソートする点列
	 */
	private static <T extends GPoint2Df> Item<T> getMinLength(double x, double y, RefList<T> l) {

		double minLength = Double.MAX_VALUE;
		Item<T> minItem= l.itemAt(0);

		Item<T> it= l.itemAt(0).nextItem;
		for (int i= 0; i < l.size(); i++) {
			GPoint2Df p= it.getObject();
			double len= Math.sqrt((p.x - x) * (p.x - x) + (p.y - y) * (p.y - y));
			if (len < minLength) {
				minLength= len;
				minItem= it;
			}
			it= it.nextItem;
		}
		l.removeItemAt(minItem);
		return minItem;
	}
}
