package nethome.doc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jp.kitec.lib.util.tree.ObjectFolder;
import nethome.geom.WorkSheet;
import nethome.geom.primitive.Geometry;


/**
 * 画層最小単位クラス
 *
 * @author kawae
 */
public class Layer implements Serializable {

	/** レイヤ名 */
	private String mName;

	/** 基本エリア */
	protected WorkSheet mWorkSheet;

	/** 表示・非表示フラグ */
	private boolean mVisible;

	/** 保持プリミティブのコレクション */
	protected List<Geometry> mPrims;

	/** 選択バッファ */
	private ArrayList<Geometry> mSelectBuffer;

	/** 選択バッファソート用バッファ */
	private ArrayList<Geometry> mSortTmp = new ArrayList<Geometry>();

	/**
	 * コンストラクタ
	 */
	public Layer() {
		this(null, new WorkSheet());
	}

	/**
	 * コンストラクタ
	 *
	 * @param ws 作業範囲
	 */
	public Layer(WorkSheet ws) {
		this(null, ws);
	}

	/**
	 * コンストラクタ
	 *
	 * @param name レイヤ名
	 * @param ws 作業範囲
	 */
	public Layer(String name, WorkSheet ws) {
		mName = name;
		mPrims = new ArrayList<Geometry>();
		mVisible = true;
		mWorkSheet = ws;

		mSelectBuffer = new ArrayList<Geometry>();
	}

	public void setName(String name) {
		this.mName = name;
	}

	public String getName() {
		return mName;
	}
	/**
	 * ワークシートの指定
	 * @param ws
	 * @author kawae
	 * @since 2004/10/02
	 */
	public void setWorkSheet(WorkSheet ws) {
		mWorkSheet = ws;
	}
	/**
	 * ワークシートの取得
	 */
	public WorkSheet getWorkSheet() {
		return mWorkSheet;
	}

	/**
	 * IDのリナンバリング
	 *
	 * @author kawae
	 * @since 2004/10/12
	 */
	public void renumberID() {
		for (int i = 0; i < mPrims.size(); i++) {
			Geometry g = mPrims.get(i);
			g.setID(i + 1);
		}
	}

	/**
	 * データの保存
	 * @param savenode
	 */
	public void save(ObjectFolder savenode) {
		savenode.setName("LAYER");
		savenode.addNode("TYPE", "LAYER");

		for (int i = 0; i < mPrims.size(); i++) {
			Geometry g = mPrims.get(i);
			ObjectFolder of = new ObjectFolder("");
			g.save(of);
			savenode.addChild(of, true);
		}
	}

	/**
	 * 選択バッファに追加
	 * @param g			追加する幾何オブジェクト
	 * @param flip		true:反転モード（既にバッファ内に存在すればバッファから削除）
	 * 					false:通常モード（単純追加。但し、バッファに存在すれば追加しない）
	 */
	public void addSelectBuffer(Geometry g, boolean flip) {
		if (!mPrims.contains(g))
			return;
		if (mSelectBuffer.contains(g)) {
			if(flip)
				mSelectBuffer.remove(g);
		} else {
			mSelectBuffer.add(g);
		}
		sortSelectBuffer();
	}

	/**
	 * 選択バッファのクリア
	 */
	public void clearSelectBuffer() {
		mSelectBuffer.clear();
	}

	/**
	 * 選択バッファコレクションの取得
	 * @return
	 */
	public List<Geometry> getSelectBuffer() {
		return mSelectBuffer;
	}

	/**
	 * 選択バッファのソート
	 */
	public void sortSelectBuffer() {
		if (mSelectBuffer.size() == 0)
			return;
		mSortTmp.clear();
		//FIXME Setを使う
		for (int i = 0; i < mPrims.size(); i++) {
			Geometry o = mPrims.get(i);
			if (mSelectBuffer.contains(o))
				mSortTmp.add(o);
		}
		mSelectBuffer.clear();
		for (int i = 0; i < mSortTmp.size(); i++)
			mSelectBuffer.add(mSortTmp.get(i));
		mSortTmp.clear();
	}

	/**
	 * レイヤーを初期化する
	 */
	public void refresh() {
		mPrims.clear();
		mVisible = true;
	}

	/**
	 * レイヤー内にプリミティブを持つか確認
	 * @return
	 */
	public boolean isHasData() {
		return !mPrims.isEmpty();
	}

	/**
	 * ファイルの読み込み
	 * サブクラスにて実装する必要がある。
	 *
	 * @param r 未記載
	 * @param doc 未記載
	 * @param version 未記載
	 * @return 未記載
	 * @throws Exception 未記載
	 */
	public static Object readData(ObjectFolder of, Document doc, float version) throws Exception {
		return null;
	}


	/**
	 * 表示・非表示を確認
	 * @return
	 */
	public boolean isVisible() {
		return mVisible;
	}

	/**
	 * 表示状態を設定
	 *
	 * @param b 未記載
	 */
	public void setVisible(boolean b) {
		mVisible = b;
	}

	/**
	 * 要素コレクションの取得
	 *
	 * @return 要素コレクション
	 */
	public List<Geometry> getPrims() {
		return mPrims;
	}

	/**
	 * 要素コレクションの設定
	 *
	 * @param v 設定する要素のコレクション
	 */
	public void setPrims(List<? extends Geometry> v) {
		mPrims.clear();
		mPrims.addAll(v);
	}

	/**
	 * 要素の追加
	 *
	 * @param p 追加する要素
	 */
	public void addPrimitive(Geometry p) {
		mPrims.add(p);
	}

	/**
	 * 要素の削除
	 *
	 * @param p 削除する要素
	 */
	public void removePrimitive(Geometry p) {
		mPrims.remove(p);
	}

	/**
	 * 全ての要素を削除する。
	 */
	public void deleteAll() {
		mPrims.clear();
	}

}
