/**
 *
 */
package nethome.text;

/**
 *
 * @since 2010/04/21
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class TextLayout {
	public enum Alignment{
		TOP,
		CENTER,
		BOTTOM,
		;
	}
	public enum VerDirection{
		/** top to bottom */
		TB,
		/** bottom to top */
		BT,
		;
	}
	public enum HorDirection{
		/** left to right */
		LR,
		/** right to left */
		RL,
		;
	}
	/**
	 * 文字の方向 (縦書き/横書き)
	 *
	 * @since 2010/05/26
	 * @author $Author$
	 * @version $Revision$ $Date::                           $
	 */
	public enum TextDirection{
		/** 横書き */
		HOR,
		/** 縦書き */
		VER,
		;
	}

	public enum TextLineAutoTurn{
		/** 折り返しは考慮しない */
		OFF("標準"),
		/** 文字方向に関して、枠内で折り返し */
		ON("折り返す"),
		/** 文字方向、行方向とも、枠に納まるようにする */
		AUTOADJUST("自動調整"),
		/** 枠と長い方向を一致させる */
		FIT("枠にあわせる"),
		;
		private String desc;
		private TextLineAutoTurn(String desc) {
			this.desc = desc;
		}

		@Override
		public String toString() {
			return desc;
		}
	}
}
