package nethome.geom.util;

import jp.kitec.lib.util.RefList;
import nethome.geom.primitive.GLine;
import nethome.geom.primitive.GPoint2Df;

/**
 * <p>タイトル: </p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2002</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
 */

public class ToolClippingLine {

	private static double[] tmpf = new double[2];
	public ToolClippingLine() {
	}


	/**
	 * 2直線の間で点群をクリッピング
	 *
	 *       pts.elementAt(0)
	 * ------------+-------(l1)
	 *             |
	 *             |
	 *             |
	 *             |
	 * ------------+-------(l2)
	 *      pts.elementAt(n)
	 *
	 * @param l1x1
	 * @param l1y1
	 * @param l1x2
	 * @param l1y2
	 * @param l2x1
	 * @param l2y1
	 * @param l2x2
	 * @param l2y2
	 * @param pts
	 * @return
	 */

	public static void clipLine(double l1x1, double l1y1, double l1x2, double l1y2, double l2x1, double l2y1, double l2x2, double l2y2, RefList<GPoint2Df> pts) {

		GPoint2Df pa = null, pb = null;
		//開始点の検索
		for (int j = 0; j < pts.size() - 1; j++) {
			GPoint2Df p1 = pts.elementAt(j);
			GPoint2Df p2 = pts.elementAt(j + 1);
			if (ToolMath.isCrossSegment(p1.x, p1.y, p2.x, p2.y, l1x1, l1y1, l1x2, l1y2, tmpf)) {
				if (ToolMath.isSame2D(tmpf[0], tmpf[1], p1.x, p1.y)) {
					pa = p1;
					break;
				} else if (ToolMath.isSame2D(tmpf[0], tmpf[1], p2.x, p2.y)) {
					pa = p2;
					break;
				} else {
					GPoint2Df np = new GPoint2Df(tmpf[0], tmpf[1]);
					pts.insertElementAt(np, j);
					pa = np;
					break;
				}
			}
		}
		if (pa == null) {
			GPoint2Df p1 = pts.elementAt(0);
			GPoint2Df p2 = pts.elementAt(1);
			ToolMath.isCrossInfinity(p1.x, p1.y, p2.x, p2.y, l1x1, l1y1, l1x2, l1y2, tmpf);
			p1.x = tmpf[0];
			p1.y = tmpf[1];
			pa = p1;
			pts.addElement(pa);
			pts.setHead(pts.itemAt(-1));
//			debug.Debug.println("start null");
		}

		//終了点の検索
		for (int j = 0; j < pts.size() - 1; j++) {
			GPoint2Df p1 = pts.elementAt(j);
			GPoint2Df p2 = pts.elementAt(j + 1);
			if (ToolMath.isCrossSegment(p1.x, p1.y, p2.x, p2.y, l2x1, l2y1, l2x2, l2y2, tmpf)) {
				if (ToolMath.isSame2D(tmpf[0], tmpf[1], p1.x, p1.y)) {
					pb = p1;
					break;
				} else if (ToolMath.isSame2D(tmpf[0], tmpf[1], p2.x, p2.y)) {
					pb = p2;
					break;
				} else {
					GPoint2Df np = new GPoint2Df(tmpf[0], tmpf[1]);
					pts.insertElementAt(np, j);
					pb = np;
					break;
				}
			}
		}
		if (pb == null) {
			GPoint2Df p1 = pts.elementAt(-1);
			GPoint2Df p2 = pts.elementAt(-2);
			ToolMath.isCrossInfinity(p1.x, p1.y, p2.x, p2.y, l2x1, l2y1, l2x2, l2y2, tmpf);
			p1.x = tmpf[0];
			p1.y = tmpf[1];
			pb = p1;
			pts.addElement(pb);
//			debug.Debug.println("start null2");
		}

		if (pa == null || pb == null) {
			System.out.println("err clipping");
			return;
		}
		boolean flip = false;
		for (int i = 0; i < pts.size(); i++) {
			if (pts.elementAt(i) == pa)
				break;
			else if (pts.elementAt(i) == pb) {
				flip = true;
				break;
			}
			pts.removeElement(pts.elementAt(i));
			i--;
		}
		for (int i = 0; i < pts.size(); i++) {
			if (pts.elementAt(-i - 1) == pa || pts.elementAt(-i - 1) == pb)
				break;
			pts.removeElement(pts.elementAt(-i - 1));
			i--;
		}
		if (flip) {
			pts.flip();
			pts.setHead(pts.itemAt(1));
		}
		for (int i = 0; i < pts.size() - 1; i++) {
			for (int j = i + 1; j < pts.size(); j++) {
				GPoint2Df p1 = pts.elementAt(i);
				GPoint2Df p2 = pts.elementAt(j);
				if (ToolMathEx.isSame2D(p1, p2)) {
					pts.removeItemAt(pts.itemAt(j));
					j--;
				}
			}
		}
	}

	public static RefList<GLine> clipPolygon(RefList<? extends GPoint2Df> poly, GLine line) {
		RefList<GPoint2Df> pts = new RefList<GPoint2Df>();
		pts.addElement(line.pA);
		pts.addElement(line.pB);
		for (int i = 0; i < poly.size(); i++) {
			GPoint2Df pp1 = poly.elementAt(i);
			GPoint2Df pp2 = poly.elementAt(i + 1);
			for (int j = 0; j < pts.size() - 1; j++) {
				GPoint2Df pl1 = pts.elementAt(j);
				GPoint2Df pl2 = pts.elementAt(j + 1);
				if (ToolMath.isCrossSegment(pp1.x, pp1.y, pp2.x, pp2.y, pl1.x, pl1.y, pl2.x, pl2.y, tmpf)) {
					if (!ToolMath.isSame2D(pl1.x, pl1.y, tmpf[0], tmpf[1]) && !ToolMath.isSame2D(pl2.x, pl2.y, tmpf[0], tmpf[1])) {
						pts.insertElementAt(new GPoint2Df(tmpf[0], tmpf[1]), j);
						j--;
						break;
					}
				}
			}
		}
		RefList<GLine> lines = new RefList<GLine>();
		for (int i = 0; i < pts.size() - 1; i++) {
			GPoint2Df pp1 = pts.elementAt(i);
			GPoint2Df pp2 = pts.elementAt(i + 1);
			lines.addElement(new GLine(pp1, pp2));
		}
		for (int i = 0; i < lines.size(); i++) {
			GLine l = lines.elementAt(i);
			if (ToolPolygon.isInnerPolygon(poly, l.pA.x, l.pA.y) && ToolPolygon.isInnerPolygon(poly, l.pB.x, l.pB.y)) {
				lines.removeElement(l);
				i--;
			}
		}
		return lines;
	}
}