package nethome.geom.util;

import java.util.Vector;

import jp.kitec.lib.util.Item;
import jp.kitec.lib.util.RefList;
import nethome.geom.primitive.GPoint2Df;
/**
 * 点列リストと点列リストのブーリアン
 */
public class ToolBooleanPolygon {

	private static final int SHARED  = 0;
	private static final int INSIDE  = 1;
	private static final int OUTSIDE = 2;

	/**
	 * 足し算算実行(p1 + p2);
	 *
	 * @param	p1		オブジェクト１
	 * @param	p2		オブジェクト２
	 */
	public static RefList<LinkedPoint2Df> culcAdd(RefList<? extends GPoint2Df> a, RefList<? extends GPoint2Df> b) {
		RefList<LinkedPoint2Df> A = createLinkedList(a);
		RefList<LinkedPoint2Df> B = createLinkedList(b);
		RefList<LinkedPoint2Df> result = null;

		if (preCulcBoolean(A, B))
			result = addition(A, B);
		A.removeAllElements();
		B.removeAllElements();
		return result;
	}

	/**
	 * 引き算実行(a - b);
	 *
	 * @param	a		オブジェクト１
	 * @param	b		オブジェクト２
	 */
	public static RefList<RefList<LinkedPoint2Df>> culcSub(RefList<? extends GPoint2Df> a, RefList<? extends GPoint2Df> b) {
		RefList<LinkedPoint2Df> A = createLinkedList(a);
		RefList<LinkedPoint2Df> B = createLinkedList(b);
		RefList<RefList<LinkedPoint2Df>> res = null;
		if (preCulcBoolean(A, B)) {
			res = subtraction(A, B);
		}
		else {
			boolean AincludeB = checkInclude(A, B, false);
			boolean BincludeA = checkInclude(B, A, false);
			//完全に一致した場合
			if (AincludeB && BincludeA) {
				res = null;
			} else if ((!AincludeB && !BincludeA) || AincludeB) {
				res = new RefList<RefList<LinkedPoint2Df>>();
				res.addElement(A);
			} else if (BincludeA) {
				res = null;
			}
		}
		return res;
	}

	/**
	 * aがbに含まれるか。
	 *
	 * @param a
	 * @param b
	 * @param flag
	 * @return
	 */
	private static boolean checkInclude(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b, boolean flag) {
//		intersect(a, b);

		for (int i = 0; i < a.size(); i++) {
			GPoint2Df pa = a.elementAt(i);
			GPoint2Df pb = a.elementAt(i + 1);
			double x = (pa.x + pb.x) / 2.;
			double y = (pa.y + pb.y) / 2.;
			if (!ToolPolygon.isInnerPolygon(b, x, y))
				return false;
			if (flag && checkOnEdge(b, x, y))
				return false;
		}
		return true;
	}

	private static boolean checkOnEdge(RefList<LinkedPoint2Df> l, double x, double y) {
		for (int i = 0; i < l.size(); i++) {
			GPoint2Df p1 = l.elementAt(i);
			GPoint2Df p2 = l.elementAt(i + 1);
			if (ToolMath.isOnLimitLinePoint2D(x, y, p1.x, p1.y, p2.x, p2.y))
				return true;
		}
		return false;
	}

	private static boolean isSame(Object p1, Object p2) {
		if (p1 != null && p2 != null && p1 instanceof GPoint2Df && p2 instanceof GPoint2Df) {
			GPoint2Df gp1 = (GPoint2Df)p1;
			GPoint2Df gp2 = (GPoint2Df)p2;
			return ToolMath.isSame2D(gp1.x, gp1.y, gp2.x, gp2.y);
		}
		return false;
	}

	private static RefList<LinkedPoint2Df> createLinkedList(RefList<? extends GPoint2Df> r) {
		RefList<LinkedPoint2Df> ll = new RefList<LinkedPoint2Df>();
		for (int i = 0; i < r.size(); i++) {
			GPoint2Df gp = r.elementAt(i);
			ll.addElement(new LinkedPoint2Df(gp));
		}
		return ll;
	}
	/**
	 * ブーリアン
	 *
	 * @param a 対象の点列リスト
	 * @param b 対象から削除する点列リスト
	 */
	private static boolean preCulcBoolean(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
		ToolPolygon.removeOverlapNode(a);
		ToolPolygon.removeOverlapNode(b);
//		intersect(a, b);
		initializePolygon(a);
		initializePolygon(b);
		addLink(a, b);
		if (!checkLink(a))
			return false;
		setNodeState(a, b);
		setNodeState(b, a);

		return true;
	}

	/**
	 * 初期化
	 *
	 * @param list	初期化するポリゴン
	 */
	private static void initializePolygon(RefList<LinkedPoint2Df> list) {
		Item<LinkedPoint2Df> cur;

		cur = list.itemAt(0);
		do {
			(cur.getObject()).flag = -1;
			(cur.getObject()).mLink = null;
		} while ((cur = cur.nextItem) != list.itemAt(0));
	}

	private static boolean checkLink(RefList<LinkedPoint2Df> a) {
		int count = 0;
		for (int i = 0; i < a.size(); i++) {
			if ((a.elementAt(i)).mLink != null) {
				count++;
			}
		}
		if (count > 1)
			return true;
		return false;
	}

	/**
	 * リンク情報の設定
	 */
	private static void addLink(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
		Item<LinkedPoint2Df> ita, itb;
		ita = a.itemAt(0);
		do {
			itb = b.itemAt(0);
			do {
				LinkedPoint2Df atmp = ita.getObject();
				LinkedPoint2Df btmp = itb.getObject();
				if (ToolMath.getLength2D(atmp.x, atmp.y, btmp.x, btmp.y) < ToolMath.EPS) {
						atmp.mLink = itb;
						btmp.mLink = ita;
				}
			} while ((itb = itb.nextItem) != b.itemAt(0));
		} while ((ita = ita.nextItem) != a.itemAt(0));
	}

	/**
	 *
	 * ノードの内外状態を設定
	 * CHECK:bが使われて無い？
	 */
	private static void setNodeState(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b)	{
		Item<LinkedPoint2Df> cur, b1, b2;
//		GPoint2Df p = new GPoint2Df();

		//リンクを持つ部分の検索
		Item<LinkedPoint2Df> head = null;
		for (int i = 0; i < a.size(); i++) {
			if ((a.elementAt(i)).mLink != null) {
				head = a.itemAt(i);
				break;
			}
		}
		if (head == null)
			return;
			cur = head;
		int prev = -1;
		do {
			if ((cur.getObject()).flag != OUTSIDE && (cur.getObject()).flag >= 0)
				continue;

			b1 = (cur.getObject()).mLink;
			b2 = (cur.nextItem.getObject()).mLink;

			if ( b1 != null && b2 != null && ( b1.nextItem == b2 || b2.nextItem == b1 )) {
				(cur.getObject()).flag = prev = SHARED;
			} else if (b1 != null) {
				LinkedPoint2Df pc = cur.getObject();
				LinkedPoint2Df pn = cur.nextItem.getObject();
				LinkedPoint2Df pa, pb;
				pa = b1.prevItem.getObject();
				pb = b1.nextItem.getObject();
				double angl1 = ToolMath.getAngle2D(pc.x, pc.y, pb.x, pb.y);
				double angl2 = ToolMath.getAngle2D(pc.x, pc.y, pn.x, pn.y);
				double angl3 = ToolMath.getAngle2D(pc.x, pc.y, pa.x, pa.y);
				angl2 = ToolMath.getAngl2PI(angl2 - angl1);
				angl3 = ToolMath.getAngl2PI(angl3 - angl1);
				if (angl2 <= angl3)
					(cur.getObject()).flag = prev = INSIDE;
				else
					(cur.getObject()).flag = prev = OUTSIDE;

			} else {
				(cur.getObject()).flag = prev;
			}
		} while ((cur = cur.nextItem) != head);
	}
/*
	private static void setNodeState2(RefList a, RefList b)	{
		Item cur = a.itemAt(0), b1, b2;
		GPoint2Df p = new GPoint2Df();

		do {
			if ( ((LinkedPoint2Df)cur.getObject()).flag != OUTSIDE && ((LinkedPoint2Df)cur.getObject()).flag >= 0)
				continue;

			b1 = ((LinkedPoint2Df)cur.getObject()).mLink;
			b2 = ((LinkedPoint2Df)cur.nextItem.getObject()).mLink;

			if ( b1 != null && b2 != null && ( b1.nextItem == b2 || b2.nextItem == b1 )) {
				((LinkedPoint2Df)cur.getObject()).flag = SHARED;
			} else if (b1 != null) {
				LinkedPoint2Df pc = (LinkedPoint2Df)cur.getObject();
				LinkedPoint2Df pn = (LinkedPoint2Df)cur.nextItem.getObject();
				LinkedPoint2Df pa, pb;
				pa = (LinkedPoint2Df)b1.prevItem.getObject();
				pb = (LinkedPoint2Df)b1.nextItem.getObject();
				if (ToolMath.isPointPickUporDown(pn.x, pn.y, pa.x, pa.y, pc.x, pc.y) &&
					ToolMath.isPointPickUporDown(pn.x, pn.y, pc.x, pc.y, pb.x, pb.y))
					((LinkedPoint2Df)cur.getObject()).flag = INSIDE;
				else
					((LinkedPoint2Df)cur.getObject()).flag = OUTSIDE;

			} else {
				p.x = (((LinkedPoint2Df)cur.getObject()).x + ((LinkedPoint2Df)cur.nextItem.getObject()).x ) / 2.f;
				p.y = (((LinkedPoint2Df)cur.getObject()).y + ((LinkedPoint2Df)cur.nextItem.getObject()).y ) / 2.f;
				if (ToolPolygon.isInnerPolygon(b, p.x, p.y))
					((LinkedPoint2Df)cur.getObject()).flag = INSIDE;
				else
					((LinkedPoint2Df)cur.getObject()).flag = OUTSIDE;
			}
		} while ((cur = cur.nextItem) != a.itemAt(0));
	}
*/
	private static boolean isIncludeNode(RefList<RefList<LinkedPoint2Df>> resultAll, LinkedPoint2Df lp) {
		if (resultAll.size() == 0)
			return false;
		Item<RefList<LinkedPoint2Df>> it = resultAll.itemAt(0);
		for (int i = 0; i < resultAll.size(); i++) {
			RefList<LinkedPoint2Df> lpl = it.getObject();
			Item<LinkedPoint2Df> it2 = lpl.itemAt(0);
			for (int j = 0; j < lpl.size(); j++) {
				if (isSame(lp, it2.getObject()))
					return true;
				it2 = it2.nextItem;
			}
			it = it.nextItem;
		}
		return false;
	}

	/**
	 * a + b
	 * @param a 元領域
	 * @param b 追加領域
	 * @return
	 */
	private static RefList<LinkedPoint2Df> addition(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
		Item<LinkedPoint2Df> it = serchHead(a, b);
		if (it == null)
			return null;

		RefList<LinkedPoint2Df> res = gatherAdd(it, a.size() + b.size());

		if (res != null)
			ToolPolygon.removeOverlapNode(res);

		return res;
	}

	/**
	 * a - b
	 * @param a 元領域
	 * @param b 削除領域
	 * @return
	 */
	private static RefList<RefList<LinkedPoint2Df>> subtraction(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
		RefList<RefList<LinkedPoint2Df>> resultAll = new RefList<RefList<LinkedPoint2Df>>();

		Item<LinkedPoint2Df> it = a.itemAt(0);
		for (int i = 0; i < a.size(); i++) {
			LinkedPoint2Df lp = it.getObject();
			if (lp.flag == OUTSIDE && !isIncludeNode(resultAll, lp)) {


				RefList<LinkedPoint2Df> res = gatherSub(it, a.size() + b.size());
				if (res != null) {
					ToolPolygon.removeOverlapNode(res);
					resultAll.addElement(res);
				} else {
//					printState(a);
//					printState(b);
					System.out.println("*** fatal err ***");
				}
			}
			it = it.nextItem;
		}

		if (resultAll.size() != 0)
			return resultAll;
		else
			return null;
	}

	/**
	 * 足し算したものを生成
	 */
	private static RefList<LinkedPoint2Df> gatherAdd(Item<LinkedPoint2Df> start, int size) {
		Item<LinkedPoint2Df> cur = start, cn;
		RefList<LinkedPoint2Df> result = new RefList<LinkedPoint2Df>();
		result.addElement(new LinkedPoint2Df(start.getObject()));

		do {
			cn = cur;

			if ((cn.getObject()).flag == SHARED && (cn.getObject()).mLink.nextItem == (cn.nextItem.getObject()).mLink)
				((cn.getObject()).mLink.getObject()).flag = SHARED;

			cur = cur.nextItem;

			if ((cur.getObject()).mLink != null) {
				if (((cur.getObject()).mLink.prevItem.getObject()).flag == INSIDE) {
					cur = (cur.getObject()).mLink;
				} else if (((cur.getObject()).mLink.getObject()).flag == OUTSIDE || ((cur.getObject()).mLink.getObject()).flag == SHARED) {
					cur = (cur.getObject()).mLink;
				}
			}

			if (!isSame(cur.getObject(), start.getObject()))
				result.addElement(new LinkedPoint2Df(cur.getObject()));
			if (result.size() > size)
				return null;
		} while (!isSame(cur.getObject(), start.getObject()));
		return result;
	}

	/**
	 * 引き算したものを生成
	 */
	private static RefList<LinkedPoint2Df> gatherSub(Item<LinkedPoint2Df> start, int size) {
		Item<LinkedPoint2Df> cur = start, cn;
		boolean flag = true;
		RefList<LinkedPoint2Df> result = new RefList<LinkedPoint2Df>();
		GPoint2Df gp = start.getObject();
		LinkedPoint2Df startl = new LinkedPoint2Df(gp.x, gp.y);
		startl.flagObj = gp.flagObj;
		result.addElement(startl);

		do {
			cn = (flag ? cur : cur.prevItem);
//			if (!flag) {
//				((LinkedPoint2Df)cn.getObject()).mFlagObj =
//			}

			if ((cn.getObject()).flag == SHARED && (cn.getObject()).mLink.nextItem == (cn.nextItem.getObject()).mLink)
				((cn.getObject()).mLink.getObject()).flag = SHARED;


			cur = (flag ? cur.nextItem : cur.prevItem);
		//反転補正
			if (!flag) {
				if ((cur.prevItem.getObject()).flagObj != null)
					(cur.getObject()).flagObj = (cur.prevItem.getObject()).flagObj;
			}

			if ((cur.getObject()).mLink != null) {
				if (flag) {
					if (((cur.getObject()).mLink.prevItem.getObject()).flag == INSIDE) {
						flag = false;
						cur = (cur.getObject()).mLink;
						//反転補正
						LinkedPoint2Df lpc = cur.getObject();
						LinkedPoint2Df lpp = cur.prevItem.getObject();
						if (lpp.flagObj != null) {
							lpc.flagObj = lpp.flagObj;
							lpp.flagObj = null;
						}
					}
				} else if (((cur.getObject()).mLink.getObject()).flag == OUTSIDE || ((cur.getObject()).mLink.getObject()).flag == SHARED) {
					flag = true;
					cur = (cur.getObject()).mLink;
				}
			}

			if (!isSame(cur.getObject(), start.getObject()))
				result.addElement(new LinkedPoint2Df(cur.getObject()));
			if (result.size() > size)
				return null;
		} while (!isSame(cur.getObject(), start.getObject()));
		return result;
	}

	/**
	 * スタート位置を算出
	 */
	private static Item<LinkedPoint2Df> serchHead(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {

		//凸包のためのデータ作成
		Vector<GPoint2Df> v = new Vector<GPoint2Df>();
		Item<LinkedPoint2Df> it = b.itemAt(0);
		for (int i = 0; i < b.size(); i++) {
			GPoint2Df gp =  it.getObject();
			v.addElement(new GPoint2Df(gp.x, gp.y));
			it = it.nextItem;
		}

		it = a.itemAt(0);
		for (int i = 0; i < a.size(); i++) {
			GPoint2Df p1 = it.getObject();
			boolean same = false;
			Item<LinkedPoint2Df> it2 = b.itemAt(0);
			for (int j = 0; j < b.size(); j++) {
				GPoint2Df p2 = it2.getObject();
				if (isSame(p1, p2)) {
					same = true;
					break;
				}
				it2 = it2.nextItem;
			}
			if (!same) {
				GPoint2Df gp = it.getObject();
				v.addElement(new GPoint2Df(gp.x, gp.y));
			}
			it = it.nextItem;
		}
		Vector<GPoint2Df> res = TotsuHou.getTotshuhou(v);
		if (res == null)
			return null;

		/**
		 * 凸包の中にaのノードがあるか検査
		 */
		for (int i = 0; i < res.size(); i++) {
			it = a.itemAt(0);
			for (int j = 0; j < a.size(); j++) {
				if (isSame(res.elementAt(i), it.getObject()) && (it.getObject()).flag == OUTSIDE)
					return it;
				it = it.nextItem;
			}
			it = b.itemAt(0);
			for (int j = 0; j < b.size(); j++) {
				if (isSame(res.elementAt(i), it.getObject()) && (it.getObject()).flag == OUTSIDE)
					return it;
				it = it.nextItem;
			}
		}
		return null;
	}
}
