/*
 * Created on 2005/07/26
 */
package nethome.geom.rich;

import jp.kitec.lib.kwt.KColor;

/**
 * 影属性
 *
 * @author kawae
 * @since 2005/07/26
 */
public interface IShadowable {
	public static final int NUM_SHADOW_TYPE = 6;
	public static final int SHADOW_NE = 0;
	public static final int SHADOW_NW = 1;
	public static final int SHADOW_SE = 2;
	public static final int SHADOW_SW = 3;
	public static final int SHADOW_POP = 4;
	public static final int SHADOW_PUSH = 5;

	public static final KColor SHADOW_DEF_COLOR = KColor.LIGHT_GRAY;

	public double getShadowOffset();
	public void setShadowOffset(double f);
	public KColor getShadowColor();
	public void setShadowColor(KColor c);
	public int getShadowType();
	public void setShadowType(int type);
	public boolean isEnableShadowType(int type);
}
