/*
 * Created on 2004/08/06
 */
package nethome.geom.rich;


import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KLineType;
import nethome.geom.primitive.GPoint2Df;

/**
 * 線の端点マークのインターフェース
 * @author kawae
 */
public interface ILinkMark {

	/**
	 * 線の端点の仮想点の取得
	 * @return
	 */
	public GPoint2Df getVirtualNode();

	/**
	 * リンクノードの更新
	 * @param n1	端点
	 * @param n2	端点と反対側の参照点
	 * @param lt	リンクの線種
	 */
	public void setLinkNode(GPoint2Df n1, GPoint2Df n2, KLineType lt);

	public KColor getFillColor();
	public KColor getGeomColor();
}
