package nethome.geom.primitive;


import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.Vector2;
import jp.kitec.lib.util.tree.ObjectFolder;
import nethome.geom.GeomName;
import nethome.geom.LocalAxis2Df;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

/**
 * <p>タイトル: </p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2002</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
 */
@GeomName("POLYGON")
public class GPolygon extends Geometry implements Primitive,IFillableGeometry {

	/** 構成点コレクション */
	protected RefList<GPoint2Df> mPoints;

	/** 描画用ポイントバッファ */
	private transient RefList<GPoint2Df> _pbuf = new RefList<GPoint2Df>();

	/** 線幅 */
	public double mLineWidth;

	/** スムースオプション */
	public int mSmooth;

	/** 塗りつぶしオプション */
	public boolean mFill = false;

	private KColor mFillColor;
	/**
	 * コンストラクタ
	 */
	public GPolygon() {
		this(new RefList<GPoint2Df>(), 0);
	}

	/**
	 * コンストラクタ
	 */
	public GPolygon(RefList<GPoint2Df> p1, int smooth) {
		super();

		mPoints = p1;
		mSmooth = smooth;
		mGeomColor = KColor.BLACK;
		area.maximize();
		updateMinMax(area);
	}

	@Override
	public boolean getSnapNode(double x1, double y1, double gx, double gy, double[] min, double[] res, double eps, short limit) {
		return false;
	}

	@Override
	public void getSnapLoop(Vector2<? super GPoint2Df> v) {
		for (int i = 0; i <= mPoints.size(); i++)
			v.addElement(mPoints.elementAt(i));
	}

	@Override
	public void getCenter(GPoint2Df p) {
		double x = 0;
		double y = 0;
		for (int i = 0; i < mPoints.size(); i++) {
			GPoint2Df p1 = mPoints.elementAt(i);
			x += p1.x;
			y += p1.y;
		}
		p.x = x / mPoints.size();
		p.y = y / mPoints.size();
	}

	@Override
	public GPoint2Df getNearNode(GPoint2Df p1, GPoint2Df p2, double eps) {
		double len, min = Float.MAX_VALUE;
		GPoint2Df res = null;
		for (int k = 0; k < mPoints.size(); k++) {
			GPoint2Df pa = mPoints.elementAt(k);
			if ((len = ToolMath.getLengthLimitLineToPoint2D(pa.x, pa.y, p1.x, p1.y, p2.x, p2.y)) >= 0 && len < eps && len < min) {
				min = len;
				res = pa;
			}
		}
		return res;
	}

	@Override
	public boolean getNearLine(double x, double y, double eps, GPoint2Df[] pts) {
		double len;
		boolean exist = false;
//		double min = Float.MAX_VALUE;
		for (int k = 0; k < mPoints.size(); k++) {
			GPoint2Df pa = mPoints.elementAt(k), pb = mPoints.elementAt(k + 1);
			if ((len = ToolMath.getLengthLimitLineToPoint2D(x, y, pa.x, pa.y, pb.x, pb.y)) >= 0 && len < eps) {
				pts[0] = pa;
				pts[1] = pb;
//				min = len;
				exist = true;
			}
		}
		return exist;
	}

	@Override
	public GPoint2Df getRotbasePoint() {
		return mPoints.elementAt(0);
	}

	@Override
	public void updateMinMax(KArea area) {
		for (int i = 0; i < mPoints.size(); i++) {
			GPoint2Df p = mPoints.elementAt(i);
			area.updateMinMax(p.x, p.y);
		}
	}

	@Override
	public Geometry copy() {
		return copyTo(new GPolygon());
	}

	@Override
	protected Geometry copyTo(Geometry g) {
		if (g == null || !(g instanceof GPolygon))
			return null;
		GPolygon np = (GPolygon)g;
		super.copyTo(g);
//		np.getCopy(np);
		RefList<GPoint2Df> v = new RefList<GPoint2Df>();
		for (int i = 0; i < mPoints.size(); i++)
			v.addElement((GPoint2Df)(mPoints.elementAt(i)).copy());
		np.mPoints = v;
		np.mFill = mFill;
		np.setFillColor(mFillColor);
		np.setGeomColor(mGeomColor);
		np.mSmooth = mSmooth;
		np.area.maximize();
		np.updateMinMax(np.area);
		return np;
	}

	/**
	 * 一番近くの構成点を探す
	 * @param x
	 * @param y
	 * @return
	 */
	@Override
	public GPoint2Df getNearNode(double x, double y) {
		double min = Float.MAX_VALUE;
		GPoint2Df gp = null;
		for (int i = 0; i < mPoints.size(); i++) {
			GPoint2Df p1 = mPoints.elementAt(i);
			double len = ToolMath.getLength2D(x, y, p1.x, p1.y);
			if (len < min) {
				min = len;
				gp = p1;
			}
		}
		return gp;
	}

	/**
	 * 指定点までの距離距離
	 * @param x　指定点X座標
	 * @param y　指定点Y座標
	 * @return 指定点までの距離
	 */
	@Override
	public double getDistanceToPoint(double x, double y) {
		double min = Float.MAX_VALUE;
//		for (int i = 0; i < mPoints.size() - 1; i++) {
		for (int i = 0; i < mPoints.size(); i++) {
			GPoint2Df p1 = getPointAt(i);
			GPoint2Df p2 = getPointAt(i + 1);
			double len = ToolMath.getLengthLimitLineToPoint2D(x, y, p1.x, p1.y, p2.x, p2.y);
			if (len < 0)
				continue;
			else if (len < min)
				min = len;
		}
		return min;
	}

	@Override
	public void offset(double x, double y) {
		for (int i = 0; i < mPoints.size(); i++)
			(mPoints.elementAt(i)).offset(x, y);
		area.maximize();
		updateMinMax(area);
	}

	@Override
	public void rotate(double xc, double yc, double angl) {
		for (int i = 0; i < mPoints.size(); i++)
			(mPoints.elementAt(i)).rotate(xc, yc, angl);
		area.maximize();
		updateMinMax(area);
	}

	/**
	 * 矩形の中に全て入っているか判定
	 * @param minx　矩形最小X値
	 * @param miny　矩形最小Y値
	 * @param maxx　矩形最大X値
	 * @param maxy　矩形最大Y値
	 * @return 矩形内:true
	 * 　　　　 矩形外:false
	 */
	@Override
	public boolean isInner(double minx, double miny, double maxx, double maxy) {
		for (int i = 0; i < mPoints.size(); i++) {
			GPoint2Df p1 = getPointAt(i);
			GPoint2Df p2 = getPointAt(i + 1);
			boolean b1 = false, b2 = false;
			if (p1.x > minx && p1.x < maxx && p1.y > miny && p1.y < maxy)
				b1 = true;
			if (p2.x > minx && p2.x < maxx && p2.y > miny && p2.y < maxy)
				b2 = true;
			if (!b1 || !b2)
				return false;
		}

		return true;
	}

	/**
	 * ポリゴンの中に全て入っているか判定
	 * @param v　ポリゴン
	 * @return 　ポリゴン内:true
	 * 　　　　　ポリゴン外:false
	 */
	@Override
	public boolean isInner(RefList<GPoint2Df> v) {
		for (int i = 0; i < mPoints.size(); i++) {
			GPoint2Df p1 = getPointAt(i);
			GPoint2Df p2 = getPointAt(i + 1);
			boolean b1 = ToolPolygon.isInnerPolygon(v, p1.x, p1.y);
			boolean b2 = ToolPolygon.isInnerPolygon(v, p2.x, p2.y);
			if (!b1 || !b2)
				return false;
		}
		return true;
	}


	public RefList<GPoint2Df> getPoints() {
		return mPoints;
	}
//
//	public RefList getControlPoints() {
//		return mPoints;
//	}

//	public static Object readData(AbstFile r, double version) throws Exception {
//		GPolygon gp = null;
//		RefList<GPoint2Df> pts = new RefList<GPoint2Df>();
//		int smooth = Integer.valueOf(r.readLineFromBuffer().trim()).intValue();
//		int num = Integer.valueOf(r.readLineFromBuffer().trim()).intValue();
//		for (int i = 0; i < num; i++) {
//			StringTokenizer st = new StringTokenizer(r.readLineFromBuffer(), " ,");
//			double x = Float.valueOf((String)st.nextElement()).doubleValue();
//			double y = Float.valueOf((String)st.nextElement()).doubleValue();
//			pts.addElement(new GPoint2Df(x, y));
//		}
//		gp = new GPolygon(pts, smooth);
//		while (true) {
//			String str = r.readLineFromBuffer();
//			if (str == null || str.trim().equalsIgnoreCase("</POLYGON>"))
//				break;
//		}
//		return gp;
//	}

	/**
	 * データの保存
	 * @param savenode
	 */
	@Override
	public void save(ObjectFolder savenode) {
		if (savenode == null)
			return;
		super.save(savenode);

		savenode.addNode("smooth", mSmooth);
		savenode.addNode("fill", mFill);
		savenode.addNode("pointsize", mPoints.size());
		for (int i = 0; i < mPoints.size(); i++) {
			GPoint2Df p = mPoints.elementAt(i);
			savenode.addNode("x" + (i + 1), p.x);
			savenode.addNode("y" + (i + 1), p.y);
		}
	}

	@Override
	public void drawGeom(IRichGraphics d) {
		drawAbstDevice(d, mGeomColor, mFillColor, null);
	}

	@Override
	public void drawGeom(IRichGraphics dr, KColor fore, KColor back) {
		if (back == null)
			back = mFillColor;
		if (fore == null)
			fore = mGeomColor;
		drawAbstDevice(dr, fore, back, null);
	}

	@Override
	public void drawAlias(IRichGraphics d, KColor fore, KColor back, LocalAxis2Df la) {
		if (fore == null)
			fore = mGeomColor;
		if (back == null)
			back = mFillColor;
		drawAbstDevice(d, fore, back, la);
	}

	@Override
	public void drawAbstDevice(IRichGraphics d, KColor fore, KColor back, LocalAxis2Df la) {
		RefList<GPoint2Df> poly = null;
		if (_pbuf != null)
			_pbuf.removeAllElements();
		else
			_pbuf = new RefList<GPoint2Df>();
		if (la != null) {
			for (int i = 0; i < mPoints.size(); i++) {
				GPoint2Df p1 = mPoints.elementAt(i);
				double x1 = la.getGlobalX(p1.x, p1.y, mKeepAspect, scaleEnX, scaleEnY, scaleBaseX, scaleBaseY);
				double y1 = la.getGlobalY(p1.x, p1.y, mKeepAspect, scaleEnX, scaleEnY, scaleBaseX, scaleBaseY);
				_pbuf.addElement(new GPoint2Df(x1, y1));
			}
			poly = _pbuf;
		} else {
			poly = mPoints;
		}

		boolean samecolor = false;
		if (fore != null && back != null) {
			if (fore.getRed() == back.getRed() && fore.getGreen() == back.getGreen() && fore.getBlue() == back.getBlue())
				samecolor = true;
		}

//		double[] x = IRichGraphics.getXBuffer(poly.size());
//		double[] y = IRichGraphics.getYBuffer(poly.size());
//		for (int i = 0; i < poly.size(); i++) {
//			GPoint2Df p = (GPoint2Df)poly.elementAt(i);
//			x[i] = p.x;
//			y[i] = p.y;
//		}
		if (poly.size() > 1) {
		if (mFill && back != null) {
			d.setColor(back);
//			System.out.println(back.getAlpha());
			d.drawFillPolygon(poly, null);
		}
		if (mFill && samecolor)
			return;
		if (fore != null) {
			d.setColor(fore);
			d.drawPolygon(poly, null);
		}
		}
		_pbuf.removeAllElements();
	}

	@Override
	public void drawHighLight(IRichGraphics d, KColor c, boolean outline) {
		if (outline) {
			boolean f = mFill;
			mFill = false;
			drawAbstDevice(d, c, c, null);
			mFill = f;
		}
		for (int i = 0; i < mPoints.size(); i++)
			(mPoints.elementAt(i)).drawHighLight(d, c, false);
	}

	/**
	 * ポリラインの構成点列をLineとして、一番近いものを取得
	 * @param x
	 * @param y
	 * @return
	 */
	public GLine getNearAsLine(double x, double y) {
		double min = Float.MAX_VALUE;
		GPoint2Df pa = null, pb = null;
		for (int i = 0; i < mPoints.size(); i++) {
			GPoint2Df p1 = getPointAt(i);
			GPoint2Df p2 = getPointAt(i + 1);
			double len = ToolMath.getLengthLimitLineToPoint2D(x, y, p1.x, p1.y, p2.x, p2.y);
			if (len < 0)
				continue;
			if (len < min) {
				min = len;
				pa = p1;
				pb = p2;
			}
		}
		if (pa != null && pb != null)
			return new GLine(pa, pb);
		return null;
	}

	@Override
	public void flipx(double x, double ofsx) {
		for (int i = 0; i < mPoints.size(); i++)
			(mPoints.elementAt(i)).flipx(x, ofsx);
		area.maximize();
		updateMinMax(area);
	}

	@Override
	public void flipy(double y, double ofsy) {
		for (int i = 0; i < mPoints.size(); i++)
			(mPoints.elementAt(i)).flipy(y, ofsy);
		area.maximize();
		updateMinMax(area);
	}

	@Override
	public void rot(double x, double y, double ofsx, double ofsy) {
		for (int i = 0; i < mPoints.size(); i++)
			(mPoints.elementAt(i)).rot(x, y, ofsx, ofsy);

		area.maximize();
		updateMinMax(area);
	}
	/**
	 * 塗り潰しモードの設定
	 */
	@Override
	public void setFillMode(boolean flag) {
		mFill = flag;
	}

	@Override
	public boolean isFillMode() {
		return mFill;
	}

	/**
	 * @return Returns the mFillColor.
	 */
	@Override
	public KColor getFillColor() {
		return mFillColor;
	}
	/**
	 * @param fillColor The mFillColor to set.
	 */
	@Override
	public void setFillColor(KColor fillColor) {
		mFillColor = fillColor;
	}

	protected GPoint2Df getPointAt(int n) {
		if (n == mPoints.size())
			return mPoints.elementAt(0);
		else
			return mPoints.elementAt(n);
	}
}
