/*
 * Created on 2004/11/02
 */
package nethome.geom;

import java.lang.reflect.Method;

import jp.kitec.lib.util.tree.ObjectFolder;
import nethome.geom.primitive.Geometry;


/**
 * 幾何読み込みパーサー
 * @author kawae
 * @since 2004/11/02
 */
public class GeomParser {

	public Geometry getGeometry(ObjectFolder f) {
		return getGeometry(f, null);
	}

	protected Geometry getGeometry(ObjectFolder f, Class[] classes) {
		if (f == null || classes == null)
			return null;
		String geomname = f.getName();
		Geometry ng = null;
		Class gClass = null;

		//対象のクラスの取得
		for (Class<?> c : classes) {
			try {
				GeomName annotation = c.getAnnotation(GeomName.class);
				if (annotation == null)
					continue;
				if (annotation.value().equalsIgnoreCase(geomname)) {
					gClass = c;
					break;
				}
			} catch (Exception e) {
			}
		}

		//インスタンスの作成
		if (gClass != null) {
			try {
				Object o = gClass.newInstance();
				if (o != null && o instanceof Geometry) {
					ng = (Geometry)o;
					Class[] argsClass = new Class[] {ObjectFolder.class, Geometry.class, GeomParser.class};
					Method method = ng.getClass().getMethod("readData", argsClass);
					Object[] arguments = new Object[] {f, ng, this};
					method.invoke(null, arguments);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return ng;
	}
}
