package nethome.geom;

import java.util.Vector;

import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KColor;
import nethome.NethomeCoreResource;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.GText;
import nethome.geom.primitive.Geometry;

@GeomName("TEXTGROUP")
public class GTextGroup extends Geometry {

	/** 中心座標 */
	public GPoint2Df mCp;

	/** 角度 */
	public double mAngl;

	/** サイズ */
	public double mSize;

	/** 文字列群 */
	private Vector<GText> mTexts;

	/** 描画方向 (true:横) */
	private boolean mDir = true;

	private boolean mBackFill = false;

	private KColor mFillColor;

	private String mScaleFont;

	/**
	 * コンストラクタ
	 * @param p1
	 * @param scaleFontLabel
	 * @param angl
	 * @param size
	 */
	public GTextGroup(GPoint2Df p1, String scaleFontLabel, double angl, double size) {
		super();
		mCp = new GPoint2Df(p1.x, p1.y);
		mAngl = angl;
		mScaleFont = scaleFontLabel;
		mTexts = new Vector<GText>();
		mSize = size;
	}
//
//	public RefList getControlPoints() {
//		return null;
//	}

	/**
	 * 描画方向の設定
	 */
	public void setDir(boolean dir) {
		mDir = dir;
	}

	public void setBackColor(boolean fill, KColor c) {
		mBackFill = fill;
		mFillColor = c;
	}

	/**
	 * テキストの個数の取得
	 */
	public int getTextSize() {
		return mTexts.size();
	}

	public void update() {
		for (int i = 0; i < mTexts.size(); i++) {
			GText gt = mTexts.elementAt(i);
			gt.setFillMode(mBackFill, mFillColor);
		}
		if (mDir) {
			//トータル高さ
			int toth = 0;
			for (int i = 0; i < mTexts.size(); i++) {
				GText gt = mTexts.elementAt(i);
				gt.update();
				toth += (gt.mMaxy - gt.mMiny);
			}
			double y = 0;
			for (int i = 0; i < mTexts.size(); i++) {
				GText gt = mTexts.elementAt(i);
				if (i == 0)
					y = mCp.y + toth / 2;
				gt.mAngl = mAngl;
				gt.mCp.x = mCp.x;
				gt.mCp.y = y - (gt.mMaxy - gt.mMiny) / 2;
				y = y - (gt.mMaxy - gt.mMiny) ;
			}
		} else {
			int totw = 0;
			for (int i = 0; i < mTexts.size(); i++) {
				GText gt = mTexts.elementAt(i);
				gt.setDir(mDir);
				gt.update();
				totw += (gt.mMaxx - gt.mMinx);
			}
			double x = 0;
			for (int i = 0; i < mTexts.size(); i++) {
				GText gt = mTexts.elementAt(i);
				gt.mAngl = mAngl;
				gt.mCp.y = mCp.y;
				if (NethomeCoreResource.TATEGAKI_DIR) {
					if (i == 0)
						x = mCp.x - totw / 2;
					gt.mCp.x = x + (gt.mMaxx - gt.mMinx) / 2;
					x = x + (gt.mMaxx - gt.mMinx) ;
				} else {
					if (i == 0)
						x = mCp.x + totw / 2;
					gt.mCp.x = x - (gt.mMaxx - gt.mMinx) / 2;
					x = x - (gt.mMaxx - gt.mMinx) ;
				}
			}

//
//			GText gt = (GText)mTexts.elementAt(0);
//			gt.update();
//			gt.setDir(mDir);
//			gt.mAngl = mAngl;
//			gt.mCp.x = mCp.x;
//			gt.mCp.y = mCp.y;

		}
//		if (mTexts.size() > 1) {
//			mDir = true;
//			int toth = 0;
//			for (int i = 0; i < mTexts.size(); i++) {
//				GText gt = (GText)mTexts.elementAt(i);
//				gt.update();
//				toth += (gt.mSize);
//			}
//			double y = 0;
//			for (int i = 0; i < mTexts.size(); i++) {
//				GText gt = (GText)mTexts.elementAt(i);
//				if (i == 0)
//					y = mCp.y + toth / 2;
//				gt.mAngl = mAngl;
//				gt.mCp.x = mCp.x;
//				gt.mCp.y = y - gt.mSize / 2;
//				y = y - gt.mSize;
//			}
//		} else if (mTexts.size() == 1) {
//			GText gt = (GText)mTexts.elementAt(0);
//			gt.update();
//			gt.setDir(mDir);
//			gt.mAngl = mAngl;
//			gt.mCp.x = mCp.x;
//			gt.mCp.y = mCp.y;
//		}
//		}
//		}
	}

//	public void update() {
//		if (mTexts.size() > 1) {
//			mDir = true;
//			int toth = 0;
//			for (int i = 0; i < mTexts.size(); i++) {
//				GText gt = (GText)mTexts.elementAt(i);
//				gt.update();
//				toth += (gt.mSize);
//			}
//			double y = 0;
//			for (int i = 0; i < mTexts.size(); i++) {
//				GText gt = (GText)mTexts.elementAt(i);
//				if (i == 0)
//					y = mCp.y + toth / 2;
//				gt.mAngl = mAngl;
//				gt.mCp.x = mCp.x;
//				gt.mCp.y = y - gt.mSize / 2;
//				y = y - gt.mSize;
//			}
//		} else if (mTexts.size() == 1) {
//			GText gt = (GText)mTexts.elementAt(0);
//			gt.update();
//			gt.setDir(mDir);
//			gt.mAngl = mAngl;
//			gt.mCp.x = mCp.x;
//			gt.mCp.y = mCp.y;
//		}
//	}

	public void addText(String s, double size, boolean bold) {
		if (s == null || s.length() == 0)
			return;
		GText gt = new GText(new GPoint2Df(), mScaleFont, s, 0, size, bold);
		mTexts.addElement(gt);
		update();
	}

	/**
	 * 全テキストの削除
	 */
	public void removeAll() {
		mTexts.removeAllElements();
	}

//	public Geometry getCopy() {
//		GPoint2Df p = (GPoint2Df)mCp.getCopy();
//		return new GTextGroup(p, mAngl, mSize, mText);
//	}

	@Override
	public double getDistanceToPoint(double x, double y) {
		return  nethome.geom.util.ToolMath.getLength2D(x, y, mCp.x, mCp.y);
	}

	@Override
	public void offset(double x, double y) {
		mCp.x += x;
		mCp.y += y;
	}

//	public void rotate(double xc, double yc, double angl) {
//		super.rotate(xc, yc, angl);
//	}

//	public boolean isInner(double minx, double miny, double maxx, double maxy) {
//		if (mMinx >= minx && mMaxx <= maxx && mMiny >= miny && mMaxy <= maxy)
//			return true;
//		return false;
//	}

//	public boolean isInner(RefList v) {
//		return ToolPolygon.isInnerPolygon(v, mMinx, mMiny) && ToolPolygon.isInnerPolygon(v, mMaxx, mMaxy);
//	}


	/**
	 * 横反転
	 */
	@Override
	public void flipx(double x, double ofsx) {
	}

	/**
	 * 縦反転
	 */
	@Override
	public void flipy(double y, double ofsy) {
	}


	public static Object readData(AbstFile r, double version) throws Exception {
//		GText gt = null;
//		StringTokenizer st = new StringTokenizer(r.readLineFromBuffer().trim(), " ,");
//		double x = Float.valueOf((String)st.nextElement()).doubleValue();
//		double y = Float.valueOf((String)st.nextElement()).doubleValue();
//
//		double a = Float.valueOf(r.readLineFromBuffer().trim()).doubleValue();
//		double s = Float.valueOf(r.readLineFromBuffer().trim()).doubleValue();
//		String t = r.readLineFromBuffer().trim();
//		gt = new GText(new GPoint2Df(x, y), a, s, t);
//		while (true) {
//			String str = r.readLineFromBuffer();
//			if (str == null) {
//				break;
//			} else if (str.trim().equalsIgnoreCase("</TEXT>")) {
//				break;
//			}
//		}
//		return gt;
		return null;
	}

//	public void saveGeom(AbstFile w, String space) throws Exception {
//	}

	@Override
	public void drawGeom(IRichGraphics d) {
		drawGeom(d, KColor.BLACK, null);
	}

	@Override
	public void drawGeom(IRichGraphics d, KColor fore, KColor back) {
		for (int i = 0; i < mTexts.size(); i++) {
			GText gt = mTexts.elementAt(i);
			gt.drawGeom(d, fore, back);
		}
	}

//	public void writeCadData(CadWriter cw, LocalAxis2Df la) {
//		for (int i = 0; i < mTexts.size(); i++) {
//			GText gt = (GText)mTexts.elementAt(i);
//			gt.writeCadData(cw, la);
//		}
//	}


//	public static void writeDxf(Object o, AbstFile w, LocalAxis2Df axis, String layer, Ltype lt) throws Exception {
//	}
}
