/*
 * Copyright (c) 2006-2010 KITec Inc,.. All rights reserved.
 */
package nethome;

import java.util.HashMap;
import java.util.Properties;

import jp.kitec.lib.kwt.KFont;


/**
 * リソースを表すクラス
 *
 * @author $Author: tanaka $
 * @version $Revision: 446 $ $Date:: 2010-03-19 20:38:08 +0900#$
 */
public class NethomeCoreResource {

	public static final String TEXT_CONFIRM = "確認";

	/** ライブラリフォルダ */
	public static String LIB_DIR = "library";

	/** 拡張子群 */
	public static String[] LIB_TYPES = null;

	/** 縦書き文字列 */
	public static String TATE_STRING = "ー（）()";

	/** マウスオペレーションの閾値（ドットサイズ）*/
	public static float EPS_DOT_LEN = 5;

	/** スケーリング用フォントサイズ */
	public static int SCALEFONTSIZE = 100;

	/** 基本フォント */
	public static String DEF_FONT_NAME = "Dialog";
	public static KFont mDefFont;

	/** 部屋名表記用のスケールフォント */
	public static String SCALEFONT_DEF_NAME = "DEF";

	public static KFont mScaleFont;

	public static String SCALEFONT_DEF_FONTNAME = "MS Gothic";

	public static int SCALEFONT_DEF_FONTTYPE = KFont.PLAIN;

	/** 部屋名表記用のフォント */
	public static String SCALEFONT_ROOM_NAME = "ROOM";
	public static KFont mRoomNameScaleFont;
	public static String SCALEFONT_ROOM_FONTNAME = "MS Gothic";
	public static int SCALEFONT_ROOM_FONTTYPE = KFont.PLAIN;

	/** グリッド分割数 */
	public static int[] GRID_DIVS = {1, 2, 4};

	/** テキストの縦書きの場合の方向 左から右が true */
	public static boolean TATEGAKI_DIR = false;

	/** マーカのサイズ（ドット） */
	public static short MARKER_SIZE = 3;

	/** 会社名(バージョンに記述される) */
	public static String CORP = "";

	/** テキストプロパティファイル名 */
	public static String mTextPropertyFile = null;

	/** ページ最大数 */
	public static int MAX_PAGE_NUMBER = 3;

	/** テキストリソースプロパティ */
	private static Properties mTextProperty = null;

	/** アプレットモード(true:アプレット false:アプリケーション) */
	public static boolean mAppletMode = true;

	/** NethomeRuntimeの実装クラス名 */
	public static String RUNTIME_NAME = null;

	private static HashMap<String, KFont> mScaleFontDB;


	static {
		mScaleFontDB = new HashMap<String, KFont>();
		update();
	}

	public static void update() {
		//デフォルトのフォント
		mDefFont = KFont.getFont(DEF_FONT_NAME, KFont.PLAIN, 12);
		//スケールフォント（デフォルト）
		mScaleFont = KFont.getFont(SCALEFONT_DEF_FONTNAME, SCALEFONT_DEF_FONTTYPE, SCALEFONTSIZE);
		//スケールフォント（部屋名表記）
		mRoomNameScaleFont = KFont.getFont(SCALEFONT_ROOM_FONTNAME, SCALEFONT_ROOM_FONTTYPE, SCALEFONTSIZE);
	}

	/**
	 * スケールフォントの取得
	 * @param s
	 * @return Font
	 */
	public static KFont getScaleFont(String s) {
		if (s.equalsIgnoreCase(SCALEFONT_DEF_NAME))
			return mScaleFont;
		else if (s.equalsIgnoreCase(SCALEFONT_ROOM_NAME))
			return mRoomNameScaleFont;
		else {
			if (mScaleFontDB.get(s) != null)
				return mScaleFontDB.get(s);
			KFont f = KFont.getFont(s, SCALEFONT_ROOM_FONTTYPE, SCALEFONTSIZE);
			mScaleFontDB.put(s, f);
			return f;
		}
	}


	/**
	 * propertyファイルからリソースファイルを取得
	 * @param s
	 * @return
	 */
	public synchronized static String getTextResource(String s) {
		String res = null;
		try {
			if (mTextProperty == null) {
				mTextProperty = new Properties();
				mTextProperty.load(NethomeCoreResource.class.getResourceAsStream(mTextPropertyFile));
			}
			res = mTextProperty.getProperty(s);
		} catch (Exception e) {
			mTextProperty = null;
			e.printStackTrace();
		}
		return res;
	}

}
