/**
 *
 */
package nethome.text;

import jp.kitec.lib.util.tree.ObjectFolder;
import nethome.text.TextLayout.Alignment;
import nethome.text.TextLayout.HorDirection;
import nethome.text.TextLayout.TextDirection;
import nethome.text.TextLayout.TextLineAutoTurn;
import nethome.text.TextLayout.VerDirection;

/**
 * テキストのレイアウト
 *
 * @since 2010/05/11
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public interface ITextLayout {
	public TextDirection getTextDirection();
	public void setTextDirection(TextDirection textDirection);

	public TextLineAutoTurn getAutoTurn();
	public void setAutoTurn(TextLineAutoTurn autoTurn);

	public Alignment getCharAlignment();
	public void setCharAlignment(Alignment charAlignment);

	public void setLineAlignment(Alignment lineAlignment);
	public Alignment getLineAlignment();

	public HorDirection getHorDirectionTate();
	public HorDirection getHorDirectionYoko();
	public VerDirection getVertDirectionTate();
	public VerDirection getVertDirectionYoko();
	public void setHorDirectionTate(HorDirection hDirectionTate);
	public void setHorDirectionYoko(HorDirection hDirectionYoko);
	public void setVertDirectionTate(VerDirection vDirectionTate);
	public void setVertDirectionYoko(VerDirection vDirectionYoko);

	public void setLayout(ITextLayout layout);

	/**
	 * @param savenode
	 * @since 2010/05/27
	 * @version 2010/05/27
	 */
	public void saveLayout(ObjectFolder savenode);

	/**
	 * @param savenode
	 * @since 2010/05/27
	 * @version 2010/05/27
	 */
	public void loadLayout(ObjectFolder savenode);

	public void setMargin(double top, double bot, double left, double right);

	public double getTopMargin();

	public double getBottomMargin();

	public double getLeftMargin();

	public double getRightMargin();

	/**
	 * 行間の固定ポイント数を
	 * @return
	 * @since 2010/06/30
	 * @version 2010/06/30
	 */
	public double getFixLineSpaceInPoint();

	public void setFixLineSpaceInPoint(double point);

	public boolean isAutoLineSpacing();

	public void setAutoLineSpacing(boolean state);

	/**
	 * 文字高さに対する自動行間ポイントの割合
	 *
	 * @return
	 * @since 2010/07/01
	 * @version 2010/07/01
	 */
	public double getAutoLineSpaceRatio();

	public void setAutoLineSpaceRatio(double ratio);
}
