package nethome.geom.primitive;

import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KArea;
import jp.kitec.kwt.KColor;
import jp.kitec.lib.geom.K2DFigureType;
import jp.kitec.lib.geom.K2DPathFigurePoint;
import jp.kitec.lib.util.tree.ObjectFolder;
import nethome.NethomeCoreResource;
import nethome.geom.GeomName;
import nethome.geom.util.ToolMath;

/**
 * @author kawae
 */
@GeomName("POINT")
public class GPoint2Df extends Geometry implements K2DPathFigurePoint {

	/** 座標値 */
	public double x, y;

	/** 汎用オブジェクト */
	public transient Object flagObj;

	/** 汎用フラグ */
	public transient short wideUseFlag;

//	/** 利用回数 */
//	private int _useCount;

	/**
	 * コンストラクタ
	 */
	public GPoint2Df() {
		super();
	}

	/**
	 *
	 * @return
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigure#getType()
	 */
	@Override
	public int getType() {
		return K2DFigureType.POINT;
	}

	/**
	 * コンストラクタ
	 * @param x
	 * @param y
	 */
	public GPoint2Df(double x, double y) {
		this();

		this.x = x;
		this.y = y;
		area.maximize();
		updateMinMax(area);
	}

	/**
	 * 座標地のセット
	 */
	@Override
	public void setXY(double x, double y) {
		this.x = x;
		this.y = y;
	}

	/**
	 *
	 * @return
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigurePoint#getX()
	 */
	@Override
	public double getX() {
		return x;
	}

	/**
	 *
	 * @return
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigurePoint#getY()
	 */
	@Override
	public double getY() {
		return y;
	}
	/**
	 *
	 * @param x
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigurePoint#setX(double)
	 */
	@Override
	public void setX(double x) {
		this.x = x;
	}

	/**
	 *
	 * @param y
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigurePoint#setY(double)
	 */
	@Override
	public void setY(double y) {
		this.y = y;
	}

	/**
	 * 座標地のセット
	 * @param p
	 */
	public void setXY(GPoint2Df p) {
		setXY(p.getX(), p.getY());
	}

	/**
	 * 最大・最小値の更新
	 */
	@Override
	public void updateMinMax(KArea area) {
		area.updateMinMax(x, y);
	}

	/**
	 * コピーインスタンスの取得
	 */
	@Override
	public Geometry copy() {
		return copyTo(new GPoint2Df());
	}

	/**
	 * コピーインスタンスの取得
	 */
	@Override
	protected Geometry copyTo(Geometry g) {
		if (g == null || !(g instanceof GPoint2Df))
			return null;
		GPoint2Df p = (GPoint2Df)g;
		super.copyTo(p);
		p.setXY(this);
		p.area.maximize();
		p.updateMinMax(p.area);
		return p;
	}

	@Override
	public GPoint2Df getNearNode(double x, double y) {
		return this;
	}

	@Override
	public double getDistanceToPoint(double x, double y) {
		return ToolMath.getLength2D(x, y, this.x, this.y);
	}

	@Override
	public void offset(double dx, double dy) {
		x += dx;
		y += dy;
		area.maximize();
		updateMinMax(area);
	}

	@Override
	public void rotate(double xc, double yc, double angl) {
		double[] _tmpf = new double[2];
		ToolMath.rotation2D(xc, yc, angl, x, y, _tmpf);
		_tmpf[0] = (Math.rint(_tmpf[0] * 1000) / 1000);
		_tmpf[1] = (Math.rint(_tmpf[1] * 1000) / 1000);
		x = area.minX = area.maxX = _tmpf[0];
		y = area.minY = area.maxY = _tmpf[1];
		area.maximize();
		updateMinMax(area);
	}

//	public static Object readData(AbstFile r, double version) throws Exception {
//		GPoint2Df gp = null;
//		int id;
//		double x, y;
//		StringTokenizer st = new StringTokenizer(r.readLineFromBuffer(), " ,");
//		id = Integer.valueOf((String)st.nextElement()).intValue();
//		x = Float.valueOf((String)st.nextElement()).doubleValue();
//		y = Float.valueOf((String)st.nextElement()).doubleValue();
//		gp = new GPoint2Df(x, y);
//		gp.setID(id);
//		while (true) {
//			String str = r.readLineFromBuffer();
//			if (str == null || str.trim().equalsIgnoreCase("</POINT>"))
//				break;
//		}
//		return gp;
//	}

	@Override
	public void drawHighLight(IRichGraphics d, KColor c, boolean outline) {
		drawHighLight(d, c, x, y);
	}

	public static void drawHighLight(IRichGraphics d, KColor c, double x, double y) {
		d.setColor(c);
		d.drawMark(x, y, NethomeCoreResource.MARKER_SIZE, IRichGraphics.MARK_REC_FILL);
		d.setColor(KColor.BLACK);
		d.drawMark(x, y, NethomeCoreResource.MARKER_SIZE, IRichGraphics.MARK_REC);
	}

	/**
	 * 幾何データの保存
	 *
	 * @param savenode		保存対象ノード
	 * @author kawae
	 * @since 2003/01/01
	 */
	@Override
	public void save(ObjectFolder savenode) {
		if (savenode == null)
			return;
		super.save(savenode);
		savenode.addNode("x", x);
		savenode.addNode("y", y);
	}

//	/**
//	 * 利用回数の設定
//	 * @param i	利用回数
//	 */
//	public void setUseCount(int i) {
//		_useCount = i;
//	}
//
//	/**
//	 * 利用回数の取得
//	 * @return
//	 */
//	public int getUseCount() {
//		return _useCount;
//	}


	@Override
	public void flipx(double x, double ofsx) {
		this.x = x - (this.x - x) + ofsx;
		area.maximize();
		updateMinMax(area);
	}

	@Override
	public void flipy(double y, double ofsy) {
		this.y = y - (this.y - y) + ofsy;
		area.maximize();
		updateMinMax(area);
	}

	@Override
	public void rot(double x, double y, double ofsx, double ofsy) {
		double tmpx, tmpy;
		tmpx = this.x;
		tmpy = this.y;
		this.x = x - (tmpy - y) + ofsy;
		this.y = y + (tmpx - x);
		area.maximize();
		updateMinMax(area);
	}

	/**
	 * 描画
	 *
	 * @param	d	描画インターフェース
	 * @author kawae
	 * @since 2003/01/01
	 */
	@Override
	public void drawGeom(IRichGraphics d) {
	}
}
