/*
 * Created on 2004/11/02
 */
package nethome.geom.primitive;

import jp.kitec.kwt.IRichGraphics;
import jp.kitec.lib.util.tree.ObjectFolder;
import nethome.geom.GeomName;
import nethome.geom.GeomParser;
import nethome.geom.ILinkTarget;

/**
 * ダミーのIDのみを持つGeometry
 * 保存からの復帰等の場合、他のオブジェクトにリンク等していて
 * 全てのオブジェクトを復帰させないといけない場合にIDのみで管理
 * を行う。
 * @author kawae
 * @since 2004/11/02
 */
@GeomName("GEOM_DUMMY")
public class GDummyLinkGeom extends Geometry implements ILinkTarget {

	public GDummyLinkGeom(int id) {
		super();
		setID(id);
	}

	public static void readData(ObjectFolder of, Geometry geom, GeomParser ps) throws Exception {
		Geometry.readData(of, geom, ps);
	}

	@Override
	public void drawGeom(IRichGraphics d) {}

	@Override
	public double getLinkDistance(double x, double y) {
		return 0;
	}
	@Override
	public boolean getLinkPoint(double px, double py, double rx, double ry, short linktype, double[] resp) {
		return false;
	}
//	public void getVectorPointToCenter(double x, double y, double[] resv) {}
	@Override
	public void getNormal(double x, double y, double[] resv) {}

}
