package nethome.geom.primitive;

import java.io.Serializable;

import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KArcType;
import jp.kitec.kwt.KArea;
import jp.kitec.kwt.KColor;
import jp.kitec.lib.geom.K2DFigureType;
import jp.kitec.lib.geom.K2DPathFigureArc;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.Vector2;
import jp.kitec.lib.util.tree.ObjectFolder;
import nethome.geom.AreaControl;
import nethome.geom.GeomName;
import nethome.geom.LocalAxis2Df;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

@GeomName("CIRCLE")
public class GCircle extends Geometry implements K2DPathFigureArc, Primitive, IFillableGeometry, Serializable {

	/** 中心座標  */
	protected GPoint2Df mCp;

	/** 半径 */
	protected double _r;

	/** 開始角度 */
	protected double _start;

	/** 終了角度 */
	protected double _end;

	/** 最大・最小点リスト */
	protected RefList<GPoint2Df> _maxPts;

	private GPoint2Df _tmpP = new GPoint2Df();

	/** 塗潰しモード */
	public boolean mFill = false;

	/** 塗潰し色 */
	private KColor mFillColor;

	/**
	 * コンストラクタ
	 *
	 */
	private GCircle() {
	}

	/**
	 * コンストラクタ
	 */
	public GCircle(double cx, double cy, double r, double start, double end) {
		this();

		mGeomColor = KColor.BLACK;
		mCp = new GPoint2Df(cx, cy);
		this._r = r;
		this._start = start;
		this._end = end;
		areaControl = new AreaControl();
		updateMaxPoints();
		area.maximize();

		updateMinMax(area);
	}

	@Override
	public boolean getSnapNode(double x1, double y1, double gx, double gy, double[] min, double[] res, double eps, short limit) {
		return false;
	}

	@Override
	public void getCenter(GPoint2Df p) {
		p.x = mCp.x;
		p.y = mCp.y;
	}

	@Override
	public void getSnapLoop(Vector2<? super GPoint2Df> v) {
	}
	/**
	 * TODO:実装
	 */
	@Override
	public GPoint2Df getNearNode(GPoint2Df p1, GPoint2Df p2, double eps) {
		return null;
	}

	@Override
	public boolean getNearLine(double x, double y, double eps, GPoint2Df[] pts) {
		return false;
	}

	@Override
	public GPoint2Df getRotbasePoint() {
		return _maxPts.elementAt(0);
	}

	public static boolean isParallel(Geometry g1, Geometry g2) {
		if (g1 == null || g2 == null)
			return false;
		if (!(g1 instanceof GCircle) || !(g2 instanceof GCircle))
			return false;
		GCircle c1 = (GCircle)g1;
		GCircle c2 = (GCircle)g2;
		if (Math.abs(c1.getR() - c2.getR()) < ToolMath.EPS && ToolMath.getLength2D(c1.getX(), c1.getY(), c2.getX(), c2.getY()) < ToolMath.EPS) {
			if (Math.abs(c1.getStart() - c2.getEnd()) < ToolMath.EPS) {
				if (!ToolMath.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getStart()))
					return true;
			} else if (Math.abs(c1.getEnd() - c2.getStart()) < ToolMath.EPS) {
				if (!ToolMath.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getEnd()))
					return true;
			}
		}
		return false;
	}

	public static Geometry marge(Geometry g1, Geometry g2) {
		if (isParallel(g1, g2)) {
			GCircle c1 = (GCircle)g1;
			GCircle c2 = (GCircle)g2;
			if (Math.abs(c1.getStart() - c2.getEnd()) < ToolMath.EPS) {
				if (!ToolMath.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getStart())) {
					return new GCircle(c1.getX(), c1.getY(), c1.getR(), c2.getStart(), c1.getEnd());
				}
			} else if (Math.abs(c1.getEnd() - c2.getStart()) < ToolMath.EPS) {
				if (!ToolMath.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getEnd()))
					return new GCircle(c1.getX(), c1.getY(), c1.getR(), c1.getStart(), c2.getEnd());
			}
		}
		return null;
	}

	public double getStart() {
		return _start;
	}

	public void setStart(double f) {
		_start = f;
	}

	public double getEnd() {
		return _end;
	}

	public void setEnd(double f) {
		this._end = f;
	}

	public double getR() {
		return _r;
	}

	public void setR(double r) {
		this._r = r;
	}

	public void setX(double f) {
		mCp.x = f;
	}
	public void setY(double f) {
		mCp.y = f;
	}

	public double getX() {
		return mCp.x;
	}

	public double getY() {
		return mCp.y;
	}


	@Override
	public Geometry copy() {
		return copyTo(new GCircle());
	}

	@Override
	protected Geometry copyTo(Geometry g) {
		if (g == null || !(g instanceof GCircle))
			return null;
		GCircle gc = (GCircle)g;
		super.copyTo(gc);
		gc.mCp = new GPoint2Df(mCp.x, mCp.y);
		gc._r = _r;
		gc._start = _start;
		gc._end = _end;

		gc.setFillMode(mFill);
		gc.setFillColor(mFillColor);
		gc.areaControl = new AreaControl();

		gc.updateMaxPoints();
		gc.area.maximize();
		gc.updateMinMax(gc.area);
		return gc;
	}

	@Override
	public void updateMinMax(KArea area) {
		double s, e;
		s = _start;
		e = _end;
		while (s > e)
			s = s - 360;
//		area.updateMinMax(mCp.x, mCp.y);
		if (s <= 0 && e >= 0)
			area.maxX = Math.max(mCp.x + _r, area.maxX);
		if (s <= 90 && e >= 90)
			area.maxY = Math.max(mCp.y + _r, area.maxY);
		if (s <= 180 && e >= 180)
			area.minX = Math.min(mCp.x - _r, area.minX);
		if (s <= 270 && e >= 270)
			area.minY = Math.min(mCp.y - _r, area.minY);
		if (_start == _end) {
			area.updateMinMax(mCp.x + _r,  mCp.y + _r);
			area.updateMinMax(mCp.x - _r,  mCp.y - _r);
//			area.minX = mCp.x - _r;
//			area.maxX = mCp.x + _r;
//			area.minY = mCp.y - _r;
//			area.maxY = mCp.y + _r;
		} else {
			double x1 = mCp.x + (_r * Math.cos(_start * Math.PI / 180));
			double y1 = mCp.y + (_r * Math.sin(_start * Math.PI / 180));
			double x2 = mCp.x + (_r * Math.cos(_end   * Math.PI / 180));
			double y2 = mCp.y + (_r * Math.sin(_end   * Math.PI / 180));
			area.updateMinMax(x1, y1);
			area.updateMinMax(x2, y2);
		}
	}

	private void updateMaxPoints() {
		double s, e;
		s = _start;
		e = _end;
		while (s > e)
			s = s - 360;

		_maxPts = new RefList<GPoint2Df>();
		if (s < 0 && e > 0 || _start == _end)
			_maxPts.addElement(new GPoint2Df(mCp.x + _r, mCp.y));
		if (s < 90 && e > 90 || _start == _end)
			_maxPts.addElement(new GPoint2Df(mCp.x, mCp.y + _r));
		if (s < 180 && e > 180 || _start == _end)
			_maxPts.addElement(new GPoint2Df(mCp.x - _r, mCp.y));
		if (s < 270 && e > 270 || _start == _end)
			_maxPts.addElement(new GPoint2Df(mCp.x, mCp.y - _r));
		if (_start != _end) {
			GPoint2Df p1 = new GPoint2Df(mCp.x + (_r * Math.cos(_start * Math.PI / 180)), mCp.y + (_r * Math.sin(_start * Math.PI / 180)));
			GPoint2Df p2 = new GPoint2Df(mCp.x + (_r * Math.cos(_end   * Math.PI / 180)), mCp.y + (_r * Math.sin(_end   * Math.PI / 180)));
			_maxPts.addElement(p1);
			_maxPts.addElement(p2);
		}
		areaControl.getPoints().removeAllElements();
		for (int i = 0; i < _maxPts.size(); i++)
			areaControl.getPoints().addElement(_maxPts.elementAt(i));
	}

	@Override
	public GPoint2Df getNearNode(double x, double y) {
		double min, x1, y1;
		_tmpP.x = mCp.x + (_r * Math.cos(_start * Math.PI / 180));
		_tmpP.y = mCp.y + (_r * Math.sin(_start * Math.PI / 180));
		min = ToolMath.getLength2D(x, y, _tmpP.x, _tmpP.y);
		x1 = mCp.x + (_r * Math.cos(_end   * Math.PI / 180));
		y1 = mCp.y + (_r * Math.sin(_end   * Math.PI / 180));
		if (min >  ToolMath.getLength2D(x, y, x1, y1)) {
			_tmpP.x = x1;
			_tmpP.y = y1;
		}
		return _tmpP;
	}

	@Override
	public double getDistanceToPoint(double x, double y) {
		double angl = (ToolMath.getAngle2D(mCp.x, mCp.y, x, y) * 180 / Math.PI);
		double s = _start;
		double e = _end;
		e -= s;
		angl -= s;
		s = 0;
		e = ToolMath.getAngl360(e);
		angl = ToolMath.getAngl360(angl);
		if ((angl > s && angl < e) || s == e) {
			return Math.abs(_r - ToolMath.getLength2D(mCp.x, mCp.y, x, y));
		}
		double min, x1, y1;
		x1 = mCp.x + (_r * Math.cos(_start * Math.PI / 180));
		y1 = mCp.y + (_r * Math.sin(_start * Math.PI / 180));
		min = ToolMath.getLength2D(x, y, x1, y1);
		x1 = mCp.x + (_r * Math.cos(_end   * Math.PI / 180));
		y1 = mCp.y + (_r * Math.sin(_end   * Math.PI / 180));
		min = Math.min(min, ToolMath.getLength2D(x, y, x1, y1));
		return min;
	}

	@Override
	public void offset(double x, double y) {
		if (x == 0 && y == 0)
			return;
		mCp.x += x;
		mCp.y += y;
		area.maximize();
		updateMinMax(area);
		updateMaxPoints();
	}

	@Override
	public void rotate(double xc, double yc, double angl) {
		if (angl == 0)
			return;
		mCp.rotate(xc, yc, angl);
		_start += (angl * 180 / Math.PI);
		_end += (angl * 180 / Math.PI);
		while (_start >= 360)
			_start -= 360;
		while (_start < 0)
			_start += 360;
		while (_end >= 360)
			_end -= 360;
		while (_end < 0)
			_end += 360;
		area.maximize();
		updateMinMax(area);
		updateMaxPoints();
	}



	@Override
	public boolean isInner(double minx, double miny, double maxx, double maxy) {
		for (int i = 0; i < _maxPts.size(); i++) {
			GPoint2Df p = _maxPts.elementAt(i);
			if (p.x < minx || p.x > maxx || p.y < miny || p.y > maxy)
				return false;
		}
		return true;
	}

	@Override
	public boolean isInner(RefList<GPoint2Df> v) {
		for (int i = 0; i < _maxPts.size(); i++) {
			GPoint2Df p = _maxPts.elementAt(i);
			if (!ToolPolygon.isInnerPolygon(v, p.x, p.y))
				return false;
		}
		return true;
	}
/*
	private GPoint2Df mCp;
	private double _r;
	private double _start;
	private double _end;
	public boolean _fill = false;
 */
	/**
	 * データの保存
	 * @param savenode
	 */
	@Override
	public void save(ObjectFolder savenode) {
		if (savenode == null)
			return;
		super.save(savenode);
		savenode.addNode("cx", mCp.x);
		savenode.addNode("cy", mCp.y);
		savenode.addNode("r", _r);
		savenode.addNode("start", _start);
		savenode.addNode("end", _end);
		savenode.addNode("fill", mFill);
		if (mFillColor != null)
			savenode.addNode("fillc", mFillColor.getRed() + "," + mFillColor.getGreen() + "," + mFillColor.getBlue());
	}
//
//	/**
//	 * @deprecated saveを使う
//	 * データの保存
//	 * @param parent
//	 */
//	public void saveGeom(AbstFile w, String space) throws Exception {
//		XMLWriter.createElementOpen("CIRCLE");
//		super.saveGeom();
//		XMLWriter.addAttr("cx", mCp.x);
//		XMLWriter.addAttr("cy", mCp.y);
//		XMLWriter.addAttr("r", _r);
//		XMLWriter.addAttr("start", _start);
//		XMLWriter.addAttr("end", _end);
//		XMLWriter.addAttr("fill", _fill);
//		XMLWriter.close(w, true, space);
//	}


//	public static Object readData(ObjectFolder of, double version) throws Exception {
//		double cx = 0, cy = 0, r = 0, start = 0, end = 0;
//		boolean fill = false;
//		ObjectNode on;
//		if ((on = of.getNode("cx")) != null)
//			cx = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("cy")) != null)
//			cy = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("r")) != null)
//			r = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("start")) != null)
//			start = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("end")) != null)
//			end = Float.valueOf((String)on.getObject()).doubleValue();
//		if ((on = of.getNode("fill")) != null)
//			fill = Integer.valueOf((String)on.getObject()).intValue() != 0;
//		GCircle gc = new GCircle(cx, cy, r, start, end);
//		gc.setFillMode(fill);
//		Geometry.readData(of, gc);
//		return gc;
//	}

	@Override
	public void drawGeom(IRichGraphics d) {
		drawGeom(d, mGeomColor, null);
	}

	@Override
	public void drawGeom(IRichGraphics d, KColor fore, KColor back) {
		if (back == null)
			back = mFillColor;
		if (fore == null)
			fore = mGeomColor;
		drawAbstDevice(d, fore, back, null);
	}

	@Override
	public void drawAlias(IRichGraphics d, KColor fore, KColor back, LocalAxis2Df la) {
		if (back == null)
			back = mFillColor;
		if (fore == null)
			fore = mGeomColor;
		drawAbstDevice(d, fore, back, la);
	}

//	public void writeCadData(CadWriter cw, LocalAxis2Df la) {
//		drawAbstDevice(null, geomColor, _fillColor, la);
//	}

	@Override
	public void drawAbstDevice(IRichGraphics d, KColor fore, KColor back, LocalAxis2Df la) {
		double x1 = mCp.x, y1 = mCp.y;
		double s = _start;
		double e = _end;
		double r = _r;
		if (la != null) {
			//TODO:注意050624修正。
			if (false) {
				x1 = la.getGlobalX(mCp.x, mCp.y);
				y1 = la.getGlobalY(mCp.x, mCp.y);
			} else {
				x1 = la.getGlobalX(mCp.x, mCp.y, mKeepAspect, scaleEnX, scaleEnY, scaleBaseX, scaleBaseY);
				y1 = la.getGlobalY(mCp.x, mCp.y, mKeepAspect, scaleEnX, scaleEnY, scaleBaseX, scaleBaseY);
			}

			s = (la.getGlobalAngl(_start * Math.PI / 180) * 180 / Math.PI);
			e = (la.getGlobalAngl(_end * Math.PI / 180) * 180 / Math.PI);
			r = la.getGlobalLength(_r);

			while (s >= 360)
				s -= 360;
			while (s < 0)
				s += 360;
			while (e >= 360)
				e -= 360;
			while (e < 0)
				e += 360;
		}
//		if (device instanceof Graphics) {
//			if (_fill) {
//				d.drawFillCircle2((Graphics)device, x1, y1, r, s, e, fore, back);
//			} else
//				d.drawCircle((Graphics)device, x1, y1, r, s, e, fore);
			if (mFill && back != null) {
				d.setColor(back);
				d.drawFillCircle(x1, y1, r, s, e, KArcType.CHORD, null);
			}
			d.setColor(fore);
			d.drawCircle(x1, y1, r, s, e, KArcType.CHORD, null);
//		}
//		else if (device instanceof CadWriter) {
//			if (s != e)
//				((CadWriter)device).writeArc(x1, y1, r, s, e, lineType, 0, fore);
//			else {
//				if (_fill)
//					((CadWriter)device).writeCircle(x1, y1, r, true, lineType, 0, back);
//				((CadWriter)device).writeCircle(x1, y1, r, false, lineType, 0, fore);
//			}
//		}
	}

	@Override
	public void drawHighLight(IRichGraphics d, KColor c, boolean outline) {
//		drawGeom(d, g, Color.red, null);
		if (outline) {
			boolean f = mFill;
			mFill = false;
			drawAbstDevice(d, c, c, null);
			mFill = f;
		}
		for (int i = 0; i < _maxPts.size(); i++)
			(_maxPts.elementAt(i)).drawHighLight(d, c, false);
	}
//
//	public String toString() {
//		return "circle [" + mCp.x +"," + mCp.y + "],[" + _r + "],[start=" + _start + "],[end=" + _end +"]";
//	}

	public void getLocalMinMax(KArea area) {
		double s, s2, e;
		s = s2 = (_start * Math.PI / 180);
		e = (_end * Math.PI / 180);

		double angl;
		if (s > e)
			angl = (Math.PI * 2 - (s - e));
		else
			angl = e - s;
//		int ss = 0;
		while (s2 >= Math.PI)
			s2 -= Math.PI * 2;
		double minx = Float.POSITIVE_INFINITY, miny = Float.POSITIVE_INFINITY, maxx = Float.NEGATIVE_INFINITY, maxy = Float.NEGATIVE_INFINITY;

		if (Math.abs(s - e) < ToolMath.EPS) {
			minx = mCp.x - _r;
			maxx = mCp.x + _r;
			miny = mCp.y - _r;
			maxy = mCp.y + _r;
		} else {
			if (s <= 0 && s + angl >= 0)
				maxx = mCp.x + _r;
			if (s <= Math.PI * 2 && s + angl >= Math.PI * 2)
				maxx = mCp.x + _r;

			if (s <= (Math.PI / 2) && s + angl >= (Math.PI / 2))
				maxy = mCp.y + _r;
			if (s <= (Math.PI / 2 + Math.PI * 2) && s + angl >= (Math.PI / 2 + Math.PI * 2))
				maxy = mCp.y + _r;

			if (s <= Math.PI && s + angl >= Math.PI)
				minx = mCp.x - _r;
			if (s <= Math.PI + Math.PI * 2 && s + angl >= Math.PI + Math.PI * 2)
				minx = mCp.x - _r;

			if (s <= (Math.PI / 2) * 3 && s + angl >= (Math.PI / 2) * 3)
				miny = mCp.y - _r;
			if (s <= (Math.PI / 2) * 3 + Math.PI * 2 && s + angl >= (Math.PI / 2) * 3 + Math.PI * 2)
				miny = mCp.y - _r;
			minx = Math.min(minx, mCp.x + (_r * Math.cos(s)));
			miny = Math.min(miny, mCp.y + (_r * Math.sin(s)));
			maxx = Math.max(maxx, mCp.x + (_r * Math.cos(e)));
			maxy = Math.max(maxy, mCp.y + (_r * Math.sin(e)));
		}
		area.updateMinMax(minx, miny);
		area.updateMinMax(maxx, maxy);
	}

//	/**
//	 * コントロールポイントの取得
//	 * @return RefList　コントロールポイント群
//	 */
//	public RefList getControlPoints() {
//		return _maxPts;
//	}

	/**
	 * 一番近いコントロールポイントの取得
	 * @return Object	一番近いコントロールポイント
	 */
	@Override
	public Object getNearControlPoint(double x, double y) {
		double min = Float.POSITIVE_INFINITY, len;
		GPoint2Df p = null;
		for (int i = 0; i < _maxPts.size(); i++) {
			GPoint2Df p1 = _maxPts.elementAt(i);
			len = p1.getDistanceToPoint(x, y);
			if (len < min) {
				min = len;
				p = p1;
			}
		}
		return p;
	}

//	/**
//	 * スナップポイントの取得
//	 * @param x	スナップしたい点のｘ座標
//	 * @param y	スナップしたい点のｙ座標
//	 * @param pt	結果の移動先バッファ
//	 * @return boolean	移動可能ならTRUE
//	 */
//	public boolean getNearSanpPoint(double x, double y, double[] pt, double eps) {
//		double min = Float.POSITIVE_INFINITY, len;
//		double xx = 0, yy = 0;
//
//		for (int i = 0; i < _maxPts.size(); i++) {
//			GPoint2Df p1 = (GPoint2Df)_maxPts.elementAt(i);
//			len = p1.getDistanceToPoint(x, y);
//			if (len < min) {
//				min = len;
//				xx = p1.x;
//				yy = p1.y;
//			}
//		}
//		if (min <= eps) {
//			pt[0] = xx;
//			pt[1] = yy;
//			return true;
//		}
//		return false;
//	}
//
//	public boolean getNearSanpBody(double x, double y, double[] pt, double eps) {
//		double angl, anglorg;
//		angl = anglorg = (double)(ToolMath.getAngle2D(mCp.x, mCp.y, x, y) * 180 / Math.PI);
//		double s = _start;
//		double e = _end;
//
//		e -= s;
//		angl -= s;
//		s = 0;
//		while (angl >= 360)
//			angl -= 360;
//		if ((angl > s && angl < e) || s == e) {
//			if (Math.abs(_r - ToolMath.getLength2D(mCp.x, mCp.y, x, y)) < eps) {
//				pt[0] = mCp.x + (double)(_r * Math.cos((anglorg) * Math.PI / 180));
//				pt[1] = mCp.y + (double)(_r * Math.sin((anglorg) * Math.PI / 180));
//				return true;
//			}
//		}
//		return false;
//	}

	/**
	 * コントロールポイントの移動
	 * @param cp　コントロールポイント
	 * @param x	移動先ｘ
	 * @param y	移動先ｙ
	 */
	@Override
	public void moveControlPoint(Object cp, double x, double y) {
		double r = ToolMath.getLength2D(x, y, mCp.x, mCp.y);
		_r = r;
		area.maximize();
		updateMinMax(area);
		updateMaxPoints();
	}

	@Override
	public void flipx(double x, double ofsx) {
		mCp.flipx(x, ofsx);
		_start = ToolMath.getAngl360((180 - _start));
		_end = ToolMath.getAngl360((180 - _end));
		double tmp = _start;
		_start = _end;
		_end = tmp;
		area.maximize();
		updateMinMax(area);
		updateMaxPoints();
	}

	@Override
	public void flipy(double y, double ofsy) {
		mCp.flipy(y, ofsy);
		_start = ToolMath.getAngl360(( - _start));
		_end = ToolMath.getAngl360(( - _end));
		double tmp = _start;
		_start = _end;
		_end = tmp;
		area.maximize();
		updateMinMax(area);
		updateMaxPoints();
	}

	@Override
	public void rot(double x, double y, double ofsx, double ofsy) {
		mCp.rot(x, y, ofsx, ofsy);

		_start = ToolMath.getAngl360(_start + 90);
		_end = ToolMath.getAngl360(_end + 90);
		if (Math.abs(_start - _end) < ToolMath.EPS)
			_start = _end = 0;

		while (_start >= 360)
			_start -= 360;
		while (_start < 0)
			_start += 360;
		while (_end >= 360)
			_end -= 360;
		while (_end < 0)
			_end += 360;
		area.maximize();
		updateMinMax(area);
		updateMaxPoints();
	}


	@Override
	public void setFillMode(boolean fill) {
		mFill = fill;
	}

	@Override
	public boolean isFillMode() {
		return mFill;
	}

	/**
	 * @return Returns the mFillColor.
	 */
	@Override
	public KColor getFillColor() {
		return mFillColor;
	}
	/**
	 * @param fillColor The mFillColor to set.
	 */
	@Override
	public void setFillColor(KColor fillColor) {
		mFillColor = fillColor;
	}

	/**
	 * @return
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureArc#getCX()
	 */
	@Override
	public double getCX() {
		return mCp.getX();
	}

	/**
	 * @return
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureArc#getCY()
	 */
	@Override
	public double getCY() {
		return mCp.getY();
	}

	/**
	 * @return
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureArc#getRadius()
	 */
	@Override
	public double getRadius() {
		return _r;
	}

	/**
	 * @return
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureArc#isCw()
	 */
	@Override
	public boolean isCw() {
		return false;
	}

	/**
	 * @param cw
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureArc#setCw(boolean)
	 */
	@Override
	public void setCw(boolean cw) {
	}

	/**
	 * @param x
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureArc#setCX(double)
	 */
	@Override
	public void setCX(double x) {
		mCp.setX(x);
	}

	/**
	 * @param y
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureArc#setCY(double)
	 */
	@Override
	public void setCY(double y) {
		mCp.setY(y);
	}

	/**
	 * @param radius
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureArc#setRadius(double)
	 */
	@Override
	public void setRadius(double radius) {
		_r = radius;
	}

	/**
	 * @return
	 * @author kawae
	 * @since 2006/01/17
	 * @see com.kt.geom.K2DPathFigureLine#getX1()
	 */
	@Override
	public double getX1() {
		return mCp.x + _r * Math.cos(_start * ToolMath.D2R);
	}

	/**
	 * @return
	 * @author kawae
	 * @since 2006/01/17
	 * @see com.kt.geom.K2DPathFigureLine#getX2()
	 */
	@Override
	public double getX2() {
		return mCp.x + _r * Math.cos(_end * ToolMath.D2R);
	}

	/**
	 * @return
	 * @author kawae
	 * @since 2006/01/17
	 * @see com.kt.geom.K2DPathFigureLine#getY1()
	 */
	@Override
	public double getY1() {
		return mCp.y + _r * Math.sin(_start * ToolMath.D2R);
	}

	/**
	 * @return
	 * @author kawae
	 * @since 2006/01/17
	 * @see com.kt.geom.K2DPathFigureLine#getY2()
	 */
	@Override
	public double getY2() {
		return mCp.y + _r * Math.sin(_end * ToolMath.D2R);
	}

	/**
	 * @param x
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureLine#setX1(double)
	 */
	@Override
	public void setX1(double x) {
	}

	/**
	 * @param x
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureLine#setX2(double)
	 */
	@Override
	public void setX2(double x) {
	}

	/**
	 * @param y
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureLine#setY1(double)
	 */
	@Override
	public void setY1(double y) {
	}

	/**
	 * @param y
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigureLine#setY2(double)
	 */
	@Override
	public void setY2(double y) {
	}

	/**
	 * @return
	 * @author kawae
	 * @since 2006/01/18
	 * @see com.kt.geom.K2DPathFigure#getType()
	 */
	@Override
	public int getType() {
		return K2DFigureType.ARC_CCW;
	}


}

