package nethome.doc;

import jp.kitec.lib.util.History;
import jp.kitec.lib.util.tree.ObjectFolder;

public class ObjectFolderProjectHistoryManager<T extends DefaultProject<T>> implements ProjectHistoryManager<T> {

	static class ProjectProvider<T extends Project> implements ObjectFolderHistoryDataConverter.ProjectProvider<T> {
		DocumentFactory factory;
		public ProjectProvider(DocumentFactory factory) {
			this.factory = factory;
		}
		@Override
		public T getProject() {
			return (T)factory.createNewProject();
		}
	}

	/** 管理プロジェクト */
	private T mProject;

	/** ヒストリー */
	private History<T, ObjectFolder> mHistory;

	/**
	 * コンストラクタ
	 */
	public ObjectFolderProjectHistoryManager(int histnum, DocumentFactory factory) {
		mHistory = new History<T, ObjectFolder>(histnum,
				new ObjectFolderHistoryDataConverter<T>(new ProjectProvider<T>(factory), factory));
	}

	@Override
	public void setProject(T project) {
		mProject = project;
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#flushHistory()
	 */
	@Override
	public void flushHistory() {
		mHistory.flushHistory();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#setHistoryObject(java.lang.Object)
	 */
	@Override
	public void setHistoryObject(Object o) {
		T hisObj = mHistory.getConverter().readHistory((ObjectFolder)o);
		if (hisObj == null)
			return;
		else {
			copyProject(hisObj);
		}
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#getLastHistory()
	 */
	@Override
	public Object getLastHistory() {
		return mHistory.getLastHistory();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#getCurrentHistory()
	 */
	@Override
	public Object getCurrentHistory() {
		return mHistory.getCurrentHistory();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#undo()
	 */
	@Override
	public boolean undo() {
		boolean flag = false;
		T hisObj = mHistory.undo();
		if (hisObj == null)
			flag = false;
		else {
			copyProject(hisObj);
			flag = true;
		}
		if (flag)
			mProject.setSaved(false);
		return flag;
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#redo()
	 */
	@Override
	public boolean redo() {
		boolean flag = false;
		T hisObj = mHistory.redo();
		if (hisObj == null)
			flag = false;
		else {
			copyProject(hisObj);
			flag = true;
		}
		if (flag)
			mProject.setSaved(false);
		return flag;
	}

	protected void copyProject(T src) {
		int currentIndex = src.getLayers().indexOf(src.getCurrentLayer());
		mProject.getLayers().clear();
		mProject.getLayers().addAll(src.getLayers());
		mProject.setCurrentLayer(currentIndex);
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#addHistory()
	 */
	@Override
	public void addHistory() {
		for (Layer l : mProject.getLayers()) {
			l.renumberID();
		}
//		Object[] obj = new Object[] {mProject.getLayers(), mProject.mActiveLayer};
		mHistory.addHistory(mProject);
		mProject.setSaved(false);
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#hasUndo()
	 */
	@Override
	public boolean hasUndo() {
		return mHistory.hasUndo();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#hasRedo()
	 */
	@Override
	public boolean hasRedo() {
		return mHistory.hasRedo();
	}

	/* (non-Javadoc)
	 * @see nethome.doc.ProjectHistoryManager#setMaxHistory(int)
	 */
	@Override
	public void setMaxHistory(int num) {
		mHistory.setMaxHistory(num);
	}
}