/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 * @author matsuzaki
 */
/**
 *
 */
package nethome.ui;

import jp.kitec.kwt.IRichGraphics;
import nethome.geom.primitive.Geometry;

public class DefaultCanvasDrawer<T extends DefaultDrawData> implements CanvasDrawer<T> {
	/**
	 * 表示
	 * @param g グラフィックスコンテキスト
	 */
	@Override
	public void draw(T data, IRichGraphics g) {
		drawGrid(data, g);
		drawPlan(data, g);
	}

	/**
	 * 追加表示
	 * @param g
	 */
	protected void drawAdditional(T data, IRichGraphics g) {
//		DrawParameters params = new DrawParameters();
		for (Geometry geom : data.mAdditionalDrawGeoms) {
//			ICustomDrawable drawable = (ICustomDrawable)geom.getAdapter(ICustomDrawable.class);
//			if (drawable != null)
//				drawable.draw(g, params);
			geom.drawGeom(g);
		}
	}

	/**
	 * グリッドの表示
	 * @param g グラフィックスコンテキスト
	 */
	protected void drawGrid(T data, IRichGraphics g) {
	}

	protected void drawPreGridObject(T data, IRichGraphics g) {
	}

	protected void drawPostGridObject(T data, IRichGraphics g) {
	}

	/**
	 * Projectの表示
	 * @param g グラフィックスコンテキスト
	 */
	protected void drawPlan(T data, IRichGraphics g) {
	}

	@Override
	public void drawDynamic(T data, IRichGraphics g) {
		drawAdditional(data, g);
		drawOptionalObject(data, g);
		drawSelectedObject(data, g);
	}

	protected void drawOptionalObject(T data, IRichGraphics g) {
//		DrawParameters params = new DrawParameters();
		for (int i = 0; i < data.mOptionalDrawElement.size(); i++) {
			Object o = data.mOptionalDrawElement.get(i);
//			if (o instanceof IAdaptable) {
//				IAdaptable adaptable = (IAdaptable)o;
//				ICustomDrawable drawable = (ICustomDrawable)adaptable.getAdapter(ICustomDrawable.class);
//				if (drawable != null) {
//					drawable.draw(g, params);
//				}
//			}
			if (o instanceof Geometry)
				((Geometry)o).drawGeom(g);
//			else if (o instanceof Command)
//				((Command)o).drawCommand(g);
		}
	}

	/**
	 * 選択されたオブジェクトの描画
	 */
	protected void drawSelectedObject(T data, IRichGraphics g) {
	}
}